/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costoptimizationhub.model.AccountEnrollmentStatus;
import software.amazon.awssdk.services.costoptimizationhub.model.AccountEnrollmentStatusesCopier;
import software.amazon.awssdk.services.costoptimizationhub.model.CostOptimizationHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnrollmentStatusesResponse
extends CostOptimizationHubResponse
implements ToCopyableBuilder<Builder, ListEnrollmentStatusesResponse> {
    private static final SdkField<List<AccountEnrollmentStatus>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(ListEnrollmentStatusesResponse.getter(ListEnrollmentStatusesResponse::items)).setter(ListEnrollmentStatusesResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountEnrollmentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_MEMBER_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeMemberAccounts").getter(ListEnrollmentStatusesResponse.getter(ListEnrollmentStatusesResponse::includeMemberAccounts)).setter(ListEnrollmentStatusesResponse.setter(Builder::includeMemberAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeMemberAccounts").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEnrollmentStatusesResponse.getter(ListEnrollmentStatusesResponse::nextToken)).setter(ListEnrollmentStatusesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, INCLUDE_MEMBER_ACCOUNTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AccountEnrollmentStatus> items;
    private final Boolean includeMemberAccounts;
    private final String nextToken;

    private ListEnrollmentStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.includeMemberAccounts = builder.includeMemberAccounts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<AccountEnrollmentStatus> items() {
        return this.items;
    }

    public final Boolean includeMemberAccounts() {
        return this.includeMemberAccounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeMemberAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnrollmentStatusesResponse)) {
            return false;
        }
        ListEnrollmentStatusesResponse other = (ListEnrollmentStatusesResponse)((Object)obj);
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.includeMemberAccounts(), other.includeMemberAccounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnrollmentStatusesResponse").add("Items", this.hasItems() ? this.items() : null).add("IncludeMemberAccounts", (Object)this.includeMemberAccounts()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "includeMemberAccounts": {
                return Optional.ofNullable(clazz.cast(this.includeMemberAccounts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnrollmentStatusesResponse, T> g) {
        return obj -> g.apply((ListEnrollmentStatusesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostOptimizationHubResponse.BuilderImpl
    implements Builder {
        private List<AccountEnrollmentStatus> items = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeMemberAccounts;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnrollmentStatusesResponse model) {
            super(model);
            this.items(model.items);
            this.includeMemberAccounts(model.includeMemberAccounts);
            this.nextToken(model.nextToken);
        }

        public final List<AccountEnrollmentStatus.Builder> getItems() {
            List<AccountEnrollmentStatus.Builder> result = AccountEnrollmentStatusesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AccountEnrollmentStatus.BuilderImpl> items) {
            this.items = AccountEnrollmentStatusesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AccountEnrollmentStatus> items) {
            this.items = AccountEnrollmentStatusesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AccountEnrollmentStatus ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AccountEnrollmentStatus.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (AccountEnrollmentStatus)((AccountEnrollmentStatus.Builder)AccountEnrollmentStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIncludeMemberAccounts() {
            return this.includeMemberAccounts;
        }

        public final void setIncludeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
        }

        @Override
        public final Builder includeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnrollmentStatusesResponse build() {
            return new ListEnrollmentStatusesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostOptimizationHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnrollmentStatusesResponse> {
        public Builder items(Collection<AccountEnrollmentStatus> var1);

        public Builder items(AccountEnrollmentStatus ... var1);

        public Builder items(Consumer<AccountEnrollmentStatus.Builder> ... var1);

        public Builder includeMemberAccounts(Boolean var1);

        public Builder nextToken(String var1);
    }
}

