/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Usage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Usage> {
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operation").getter(Usage.getter(Usage::operation)).setter(Usage.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productCode").getter(Usage.getter(Usage::productCode)).setter(Usage.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCode").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(Usage.getter(Usage::unit)).setter(Usage.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<Double> USAGE_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("usageAmount").getter(Usage.getter(Usage::usageAmount)).setter(Usage.setter(Builder::usageAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAmount").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(Usage.getter(Usage::usageType)).setter(Usage.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD, PRODUCT_CODE_FIELD, UNIT_FIELD, USAGE_AMOUNT_FIELD, USAGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String operation;
    private final String productCode;
    private final String unit;
    private final Double usageAmount;
    private final String usageType;

    private Usage(BuilderImpl builder) {
        this.operation = builder.operation;
        this.productCode = builder.productCode;
        this.unit = builder.unit;
        this.usageAmount = builder.usageAmount;
        this.usageType = builder.usageType;
    }

    public final String operation() {
        return this.operation;
    }

    public final String productCode() {
        return this.productCode;
    }

    public final String unit() {
        return this.unit;
    }

    public final Double usageAmount() {
        return this.usageAmount;
    }

    public final String usageType() {
        return this.usageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Usage)) {
            return false;
        }
        Usage other = (Usage)obj;
        return Objects.equals(this.operation(), other.operation()) && Objects.equals(this.productCode(), other.productCode()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.usageAmount(), other.usageAmount()) && Objects.equals(this.usageType(), other.usageType());
    }

    public final String toString() {
        return ToString.builder((String)"Usage").add("Operation", (Object)this.operation()).add("ProductCode", (Object)this.productCode()).add("Unit", (Object)this.unit()).add("UsageAmount", (Object)this.usageAmount()).add("UsageType", (Object)this.usageType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "productCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "usageAmount": {
                return Optional.ofNullable(clazz.cast(this.usageAmount()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Usage, T> g) {
        return obj -> g.apply((Usage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operation;
        private String productCode;
        private String unit;
        private Double usageAmount;
        private String usageType;

        private BuilderImpl() {
        }

        private BuilderImpl(Usage model) {
            this.operation(model.operation);
            this.productCode(model.productCode);
            this.unit(model.unit);
            this.usageAmount(model.usageAmount);
            this.usageType(model.usageType);
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Double getUsageAmount() {
            return this.usageAmount;
        }

        public final void setUsageAmount(Double usageAmount) {
            this.usageAmount = usageAmount;
        }

        @Override
        public final Builder usageAmount(Double usageAmount) {
            this.usageAmount = usageAmount;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public Usage build() {
            return new Usage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Usage> {
        public Builder operation(String var1);

        public Builder productCode(String var1);

        public Builder unit(String var1);

        public Builder usageAmount(Double var1);

        public Builder usageType(String var1);
    }
}

