/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeConfiguration> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("architecture").getter(ComputeConfiguration.getter(ComputeConfiguration::architecture)).setter(ComputeConfiguration.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memorySizeInMB").getter(ComputeConfiguration.getter(ComputeConfiguration::memorySizeInMB)).setter(ComputeConfiguration.setter(Builder::memorySizeInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInMB").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(ComputeConfiguration.getter(ComputeConfiguration::platform)).setter(ComputeConfiguration.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<Double> V_CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("vCpu").getter(ComputeConfiguration.getter(ComputeConfiguration::vCpu)).setter(ComputeConfiguration.setter(Builder::vCpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vCpu").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD, MEMORY_SIZE_IN_MB_FIELD, PLATFORM_FIELD, V_CPU_FIELD));
    private static final long serialVersionUID = 1L;
    private final String architecture;
    private final Integer memorySizeInMB;
    private final String platform;
    private final Double vCpu;

    private ComputeConfiguration(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.memorySizeInMB = builder.memorySizeInMB;
        this.platform = builder.platform;
        this.vCpu = builder.vCpu;
    }

    public final String architecture() {
        return this.architecture;
    }

    public final Integer memorySizeInMB() {
        return this.memorySizeInMB;
    }

    public final String platform() {
        return this.platform;
    }

    public final Double vCpu() {
        return this.vCpu;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.vCpu());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeConfiguration)) {
            return false;
        }
        ComputeConfiguration other = (ComputeConfiguration)obj;
        return Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.memorySizeInMB(), other.memorySizeInMB()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.vCpu(), other.vCpu());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeConfiguration").add("Architecture", (Object)this.architecture()).add("MemorySizeInMB", (Object)this.memorySizeInMB()).add("Platform", (Object)this.platform()).add("VCpu", (Object)this.vCpu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "memorySizeInMB": {
                return Optional.ofNullable(clazz.cast(this.memorySizeInMB()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "vCpu": {
                return Optional.ofNullable(clazz.cast(this.vCpu()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeConfiguration, T> g) {
        return obj -> g.apply((ComputeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String architecture;
        private Integer memorySizeInMB;
        private String platform;
        private Double vCpu;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeConfiguration model) {
            this.architecture(model.architecture);
            this.memorySizeInMB(model.memorySizeInMB);
            this.platform(model.platform);
            this.vCpu(model.vCpu);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final Integer getMemorySizeInMB() {
            return this.memorySizeInMB;
        }

        public final void setMemorySizeInMB(Integer memorySizeInMB) {
            this.memorySizeInMB = memorySizeInMB;
        }

        @Override
        public final Builder memorySizeInMB(Integer memorySizeInMB) {
            this.memorySizeInMB = memorySizeInMB;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final Double getVCpu() {
            return this.vCpu;
        }

        public final void setVCpu(Double vCpu) {
            this.vCpu = vCpu;
        }

        @Override
        public final Builder vCpu(Double vCpu) {
            this.vCpu = vCpu;
            return this;
        }

        public ComputeConfiguration build() {
            return new ComputeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeConfiguration> {
        public Builder architecture(String var1);

        public Builder memorySizeInMB(Integer var1);

        public Builder platform(String var1);

        public Builder vCpu(Double var1);
    }
}

