/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.LambdaFunctionConfiguration;
import software.amazon.awssdk.services.costoptimizationhub.model.ResourceCostCalculation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaFunction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaFunction> {
    private static final SdkField<LambdaFunctionConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(LambdaFunction.getter(LambdaFunction::configuration)).setter(LambdaFunction.setter(Builder::configuration)).constructor(LambdaFunctionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<ResourceCostCalculation> COST_CALCULATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("costCalculation").getter(LambdaFunction.getter(LambdaFunction::costCalculation)).setter(LambdaFunction.setter(Builder::costCalculation)).constructor(ResourceCostCalculation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCalculation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, COST_CALCULATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final LambdaFunctionConfiguration configuration;
    private final ResourceCostCalculation costCalculation;

    private LambdaFunction(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.costCalculation = builder.costCalculation;
    }

    public final LambdaFunctionConfiguration configuration() {
        return this.configuration;
    }

    public final ResourceCostCalculation costCalculation() {
        return this.costCalculation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.costCalculation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunction)) {
            return false;
        }
        LambdaFunction other = (LambdaFunction)obj;
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.costCalculation(), other.costCalculation());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaFunction").add("Configuration", (Object)this.configuration()).add("CostCalculation", (Object)this.costCalculation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "costCalculation": {
                return Optional.ofNullable(clazz.cast(this.costCalculation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunction, T> g) {
        return obj -> g.apply((LambdaFunction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LambdaFunctionConfiguration configuration;
        private ResourceCostCalculation costCalculation;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunction model) {
            this.configuration(model.configuration);
            this.costCalculation(model.costCalculation);
        }

        public final LambdaFunctionConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(LambdaFunctionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(LambdaFunctionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final ResourceCostCalculation.Builder getCostCalculation() {
            return this.costCalculation != null ? this.costCalculation.toBuilder() : null;
        }

        public final void setCostCalculation(ResourceCostCalculation.BuilderImpl costCalculation) {
            this.costCalculation = costCalculation != null ? costCalculation.build() : null;
        }

        @Override
        public final Builder costCalculation(ResourceCostCalculation costCalculation) {
            this.costCalculation = costCalculation;
            return this;
        }

        public LambdaFunction build() {
            return new LambdaFunction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaFunction> {
        public Builder configuration(LambdaFunctionConfiguration var1);

        default public Builder configuration(Consumer<LambdaFunctionConfiguration.Builder> configuration) {
            return this.configuration((LambdaFunctionConfiguration)((LambdaFunctionConfiguration.Builder)LambdaFunctionConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder costCalculation(ResourceCostCalculation var1);

        default public Builder costCalculation(Consumer<ResourceCostCalculation.Builder> costCalculation) {
            return this.costCalculation((ResourceCostCalculation)((ResourceCostCalculation.Builder)ResourceCostCalculation.builder().applyMutation(costCalculation)).build());
        }
    }
}

