/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costoptimizationhub.CostOptimizationHubClient;
import software.amazon.awssdk.services.costoptimizationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.costoptimizationhub.model.AccountEnrollmentStatus;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesResponse;

public class ListEnrollmentStatusesIterable
implements SdkIterable<ListEnrollmentStatusesResponse> {
    private final CostOptimizationHubClient client;
    private final ListEnrollmentStatusesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnrollmentStatusesIterable(CostOptimizationHubClient client, ListEnrollmentStatusesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnrollmentStatusesResponseFetcher();
    }

    public Iterator<ListEnrollmentStatusesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountEnrollmentStatus> items() {
        Function<ListEnrollmentStatusesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnrollmentStatusesResponseFetcher
    implements SyncPageFetcher<ListEnrollmentStatusesResponse> {
        private ListEnrollmentStatusesResponseFetcher() {
        }

        public boolean hasNextPage(ListEnrollmentStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnrollmentStatusesResponse nextPage(ListEnrollmentStatusesResponse previousPage) {
            if (previousPage == null) {
                return ListEnrollmentStatusesIterable.this.client.listEnrollmentStatuses(ListEnrollmentStatusesIterable.this.firstRequest);
            }
            return ListEnrollmentStatusesIterable.this.client.listEnrollmentStatuses((ListEnrollmentStatusesRequest)((Object)ListEnrollmentStatusesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

