/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AnalysisIdsCopier;
import software.amazon.awssdk.services.costexplorer.model.AnalysisStatus;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCommitmentPurchaseAnalysesRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, ListCommitmentPurchaseAnalysesRequest> {
    private static final SdkField<String> ANALYSIS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisStatus").getter(ListCommitmentPurchaseAnalysesRequest.getter(ListCommitmentPurchaseAnalysesRequest::analysisStatusAsString)).setter(ListCommitmentPurchaseAnalysesRequest.setter(Builder::analysisStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStatus").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListCommitmentPurchaseAnalysesRequest.getter(ListCommitmentPurchaseAnalysesRequest::nextPageToken)).setter(ListCommitmentPurchaseAnalysesRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(ListCommitmentPurchaseAnalysesRequest.getter(ListCommitmentPurchaseAnalysesRequest::pageSize)).setter(ListCommitmentPurchaseAnalysesRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<List<String>> ANALYSIS_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisIds").getter(ListCommitmentPurchaseAnalysesRequest.getter(ListCommitmentPurchaseAnalysesRequest::analysisIds)).setter(ListCommitmentPurchaseAnalysesRequest.setter(Builder::analysisIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_STATUS_FIELD, NEXT_PAGE_TOKEN_FIELD, PAGE_SIZE_FIELD, ANALYSIS_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCommitmentPurchaseAnalysesRequest.memberNameToFieldInitializer();
    private final String analysisStatus;
    private final String nextPageToken;
    private final Integer pageSize;
    private final List<String> analysisIds;

    private ListCommitmentPurchaseAnalysesRequest(BuilderImpl builder) {
        super(builder);
        this.analysisStatus = builder.analysisStatus;
        this.nextPageToken = builder.nextPageToken;
        this.pageSize = builder.pageSize;
        this.analysisIds = builder.analysisIds;
    }

    public final AnalysisStatus analysisStatus() {
        return AnalysisStatus.fromValue(this.analysisStatus);
    }

    public final String analysisStatusAsString() {
        return this.analysisStatus;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final boolean hasAnalysisIds() {
        return this.analysisIds != null && !(this.analysisIds instanceof SdkAutoConstructList);
    }

    public final List<String> analysisIds() {
        return this.analysisIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisIds() ? this.analysisIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommitmentPurchaseAnalysesRequest)) {
            return false;
        }
        ListCommitmentPurchaseAnalysesRequest other = (ListCommitmentPurchaseAnalysesRequest)((Object)obj);
        return Objects.equals(this.analysisStatusAsString(), other.analysisStatusAsString()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.pageSize(), other.pageSize()) && this.hasAnalysisIds() == other.hasAnalysisIds() && Objects.equals(this.analysisIds(), other.analysisIds());
    }

    public final String toString() {
        return ToString.builder((String)"ListCommitmentPurchaseAnalysesRequest").add("AnalysisStatus", (Object)this.analysisStatusAsString()).add("NextPageToken", (Object)this.nextPageToken()).add("PageSize", (Object)this.pageSize()).add("AnalysisIds", this.hasAnalysisIds() ? this.analysisIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisStatus": {
                return Optional.ofNullable(clazz.cast(this.analysisStatusAsString()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "AnalysisIds": {
                return Optional.ofNullable(clazz.cast(this.analysisIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AnalysisStatus", ANALYSIS_STATUS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("AnalysisIds", ANALYSIS_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCommitmentPurchaseAnalysesRequest, T> g) {
        return obj -> g.apply((ListCommitmentPurchaseAnalysesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String analysisStatus;
        private String nextPageToken;
        private Integer pageSize;
        private List<String> analysisIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommitmentPurchaseAnalysesRequest model) {
            super(model);
            this.analysisStatus(model.analysisStatus);
            this.nextPageToken(model.nextPageToken);
            this.pageSize(model.pageSize);
            this.analysisIds(model.analysisIds);
        }

        public final String getAnalysisStatus() {
            return this.analysisStatus;
        }

        public final void setAnalysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
        }

        @Override
        public final Builder analysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
            return this;
        }

        @Override
        public final Builder analysisStatus(AnalysisStatus analysisStatus) {
            this.analysisStatus(analysisStatus == null ? null : analysisStatus.toString());
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final Collection<String> getAnalysisIds() {
            if (this.analysisIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisIds;
        }

        public final void setAnalysisIds(Collection<String> analysisIds) {
            this.analysisIds = AnalysisIdsCopier.copy(analysisIds);
        }

        @Override
        public final Builder analysisIds(Collection<String> analysisIds) {
            this.analysisIds = AnalysisIdsCopier.copy(analysisIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisIds(String ... analysisIds) {
            this.analysisIds(Arrays.asList(analysisIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCommitmentPurchaseAnalysesRequest build() {
            return new ListCommitmentPurchaseAnalysesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCommitmentPurchaseAnalysesRequest> {
        public Builder analysisStatus(String var1);

        public Builder analysisStatus(AnalysisStatus var1);

        public Builder nextPageToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder analysisIds(Collection<String> var1);

        public Builder analysisIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

