/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costandusagereport.CostAndUsageReportClient;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse;

public class DescribeReportDefinitionsIterable
implements SdkIterable<DescribeReportDefinitionsResponse> {
    private final CostAndUsageReportClient client;
    private final DescribeReportDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReportDefinitionsIterable(CostAndUsageReportClient client, DescribeReportDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReportDefinitionsResponseFetcher();
    }

    public Iterator<DescribeReportDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeReportDefinitionsIterable resume(DescribeReportDefinitionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReportDefinitionsIterable(this.client, (DescribeReportDefinitionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeReportDefinitionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReportDefinitionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReportDefinitionsResponseFetcher
    implements SyncPageFetcher<DescribeReportDefinitionsResponse> {
        private DescribeReportDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReportDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeReportDefinitionsResponse nextPage(DescribeReportDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReportDefinitionsIterable.this.client.describeReportDefinitions(DescribeReportDefinitionsIterable.this.firstRequest);
            }
            return DescribeReportDefinitionsIterable.this.client.describeReportDefinitions((DescribeReportDefinitionsRequest)((Object)DescribeReportDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

