/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.controlcatalog.ControlCatalogClientBuilder;
import software.amazon.awssdk.services.controlcatalog.ControlCatalogServiceClientConfiguration;
import software.amazon.awssdk.services.controlcatalog.DefaultControlCatalogClientBuilder;
import software.amazon.awssdk.services.controlcatalog.model.AccessDeniedException;
import software.amazon.awssdk.services.controlcatalog.model.ControlCatalogException;
import software.amazon.awssdk.services.controlcatalog.model.GetControlRequest;
import software.amazon.awssdk.services.controlcatalog.model.GetControlResponse;
import software.amazon.awssdk.services.controlcatalog.model.InternalServerException;
import software.amazon.awssdk.services.controlcatalog.model.ListCommonControlsRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListCommonControlsResponse;
import software.amazon.awssdk.services.controlcatalog.model.ListControlsRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListControlsResponse;
import software.amazon.awssdk.services.controlcatalog.model.ListDomainsRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListDomainsResponse;
import software.amazon.awssdk.services.controlcatalog.model.ListObjectivesRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListObjectivesResponse;
import software.amazon.awssdk.services.controlcatalog.model.ResourceNotFoundException;
import software.amazon.awssdk.services.controlcatalog.model.ThrottlingException;
import software.amazon.awssdk.services.controlcatalog.model.ValidationException;
import software.amazon.awssdk.services.controlcatalog.paginators.ListCommonControlsIterable;
import software.amazon.awssdk.services.controlcatalog.paginators.ListControlsIterable;
import software.amazon.awssdk.services.controlcatalog.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.controlcatalog.paginators.ListObjectivesIterable;

@SdkPublicApi
@ThreadSafe
public interface ControlCatalogClient
extends AwsClient {
    public static final String SERVICE_NAME = "controlcatalog";
    public static final String SERVICE_METADATA_ID = "controlcatalog";

    default public GetControlResponse getControl(GetControlRequest getControlRequest) throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        throw new UnsupportedOperationException();
    }

    default public GetControlResponse getControl(Consumer<GetControlRequest.Builder> getControlRequest) throws ResourceNotFoundException, AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return this.getControl((GetControlRequest)((Object)((GetControlRequest.Builder)GetControlRequest.builder().applyMutation(getControlRequest)).build()));
    }

    default public ListCommonControlsResponse listCommonControls(ListCommonControlsRequest listCommonControlsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        throw new UnsupportedOperationException();
    }

    default public ListCommonControlsResponse listCommonControls(Consumer<ListCommonControlsRequest.Builder> listCommonControlsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return this.listCommonControls((ListCommonControlsRequest)((Object)((ListCommonControlsRequest.Builder)ListCommonControlsRequest.builder().applyMutation(listCommonControlsRequest)).build()));
    }

    default public ListCommonControlsIterable listCommonControlsPaginator(ListCommonControlsRequest listCommonControlsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return new ListCommonControlsIterable(this, listCommonControlsRequest);
    }

    default public ListCommonControlsIterable listCommonControlsPaginator(Consumer<ListCommonControlsRequest.Builder> listCommonControlsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return this.listCommonControlsPaginator((ListCommonControlsRequest)((Object)((ListCommonControlsRequest.Builder)ListCommonControlsRequest.builder().applyMutation(listCommonControlsRequest)).build()));
    }

    default public ListControlsResponse listControls(ListControlsRequest listControlsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        throw new UnsupportedOperationException();
    }

    default public ListControlsResponse listControls(Consumer<ListControlsRequest.Builder> listControlsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return this.listControls((ListControlsRequest)((Object)((ListControlsRequest.Builder)ListControlsRequest.builder().applyMutation(listControlsRequest)).build()));
    }

    default public ListControlsIterable listControlsPaginator(ListControlsRequest listControlsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return new ListControlsIterable(this, listControlsRequest);
    }

    default public ListControlsIterable listControlsPaginator(Consumer<ListControlsRequest.Builder> listControlsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return this.listControlsPaginator((ListControlsRequest)((Object)((ListControlsRequest.Builder)ListControlsRequest.builder().applyMutation(listControlsRequest)).build()));
    }

    default public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        throw new UnsupportedOperationException();
    }

    default public ListDomainsResponse listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return this.listDomains((ListDomainsRequest)((Object)((ListDomainsRequest.Builder)ListDomainsRequest.builder().applyMutation(listDomainsRequest)).build()));
    }

    default public ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return new ListDomainsIterable(this, listDomainsRequest);
    }

    default public ListDomainsIterable listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return this.listDomainsPaginator((ListDomainsRequest)((Object)((ListDomainsRequest.Builder)ListDomainsRequest.builder().applyMutation(listDomainsRequest)).build()));
    }

    default public ListObjectivesResponse listObjectives(ListObjectivesRequest listObjectivesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        throw new UnsupportedOperationException();
    }

    default public ListObjectivesResponse listObjectives(Consumer<ListObjectivesRequest.Builder> listObjectivesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return this.listObjectives((ListObjectivesRequest)((Object)((ListObjectivesRequest.Builder)ListObjectivesRequest.builder().applyMutation(listObjectivesRequest)).build()));
    }

    default public ListObjectivesIterable listObjectivesPaginator(ListObjectivesRequest listObjectivesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return new ListObjectivesIterable(this, listObjectivesRequest);
    }

    default public ListObjectivesIterable listObjectivesPaginator(Consumer<ListObjectivesRequest.Builder> listObjectivesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ControlCatalogException {
        return this.listObjectivesPaginator((ListObjectivesRequest)((Object)((ListObjectivesRequest.Builder)ListObjectivesRequest.builder().applyMutation(listObjectivesRequest)).build()));
    }

    public static ControlCatalogClient create() {
        return (ControlCatalogClient)ControlCatalogClient.builder().build();
    }

    public static ControlCatalogClientBuilder builder() {
        return new DefaultControlCatalogClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"controlcatalog");
    }

    default public ControlCatalogServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

