/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.controlcatalog.model.CommonControlMappingDetails;
import software.amazon.awssdk.services.controlcatalog.model.FrameworkMappingDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Mapping> {
    private static final SdkField<FrameworkMappingDetails> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Framework").getter(Mapping.getter(Mapping::framework)).setter(Mapping.setter(Builder::framework)).constructor(FrameworkMappingDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()}).build();
    private static final SdkField<CommonControlMappingDetails> COMMON_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CommonControl").getter(Mapping.getter(Mapping::commonControl)).setter(Mapping.setter(Builder::commonControl)).constructor(CommonControlMappingDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonControl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_FIELD, COMMON_CONTROL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Mapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FrameworkMappingDetails framework;
    private final CommonControlMappingDetails commonControl;
    private final Type type;

    private Mapping(BuilderImpl builder) {
        this.framework = builder.framework;
        this.commonControl = builder.commonControl;
        this.type = builder.type;
    }

    public final FrameworkMappingDetails framework() {
        return this.framework;
    }

    public final CommonControlMappingDetails commonControl() {
        return this.commonControl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.framework());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonControl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping)obj;
        return Objects.equals(this.framework(), other.framework()) && Objects.equals(this.commonControl(), other.commonControl());
    }

    public final String toString() {
        return ToString.builder((String)"Mapping").add("Framework", (Object)this.framework()).add("CommonControl", (Object)this.commonControl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Framework": {
                return Optional.ofNullable(clazz.cast(this.framework()));
            }
            case "CommonControl": {
                return Optional.ofNullable(clazz.cast(this.commonControl()));
            }
        }
        return Optional.empty();
    }

    public static Mapping fromFramework(FrameworkMappingDetails framework) {
        return (Mapping)Mapping.builder().framework(framework).build();
    }

    public static Mapping fromFramework(Consumer<FrameworkMappingDetails.Builder> framework) {
        FrameworkMappingDetails.Builder builder = FrameworkMappingDetails.builder();
        framework.accept(builder);
        return Mapping.fromFramework((FrameworkMappingDetails)builder.build());
    }

    public static Mapping fromCommonControl(CommonControlMappingDetails commonControl) {
        return (Mapping)Mapping.builder().commonControl(commonControl).build();
    }

    public static Mapping fromCommonControl(Consumer<CommonControlMappingDetails.Builder> commonControl) {
        CommonControlMappingDetails.Builder builder = CommonControlMappingDetails.builder();
        commonControl.accept(builder);
        return Mapping.fromCommonControl((CommonControlMappingDetails)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Framework", FRAMEWORK_FIELD);
        map.put("CommonControl", COMMON_CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Mapping, T> g) {
        return obj -> g.apply((Mapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FRAMEWORK,
        COMMON_CONTROL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private FrameworkMappingDetails framework;
        private CommonControlMappingDetails commonControl;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Mapping model) {
            this.framework(model.framework);
            this.commonControl(model.commonControl);
        }

        public final FrameworkMappingDetails.Builder getFramework() {
            return this.framework != null ? this.framework.toBuilder() : null;
        }

        public final void setFramework(FrameworkMappingDetails.BuilderImpl framework) {
            FrameworkMappingDetails oldValue = this.framework;
            this.framework = framework != null ? framework.build() : null;
            this.handleUnionValueChange(Type.FRAMEWORK, oldValue, this.framework);
        }

        @Override
        public final Builder framework(FrameworkMappingDetails framework) {
            FrameworkMappingDetails oldValue = this.framework;
            this.framework = framework;
            this.handleUnionValueChange(Type.FRAMEWORK, oldValue, this.framework);
            return this;
        }

        public final CommonControlMappingDetails.Builder getCommonControl() {
            return this.commonControl != null ? this.commonControl.toBuilder() : null;
        }

        public final void setCommonControl(CommonControlMappingDetails.BuilderImpl commonControl) {
            CommonControlMappingDetails oldValue = this.commonControl;
            this.commonControl = commonControl != null ? commonControl.build() : null;
            this.handleUnionValueChange(Type.COMMON_CONTROL, oldValue, this.commonControl);
        }

        @Override
        public final Builder commonControl(CommonControlMappingDetails commonControl) {
            CommonControlMappingDetails oldValue = this.commonControl;
            this.commonControl = commonControl;
            this.handleUnionValueChange(Type.COMMON_CONTROL, oldValue, this.commonControl);
            return this;
        }

        public Mapping build() {
            return new Mapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Mapping> {
        public Builder framework(FrameworkMappingDetails var1);

        default public Builder framework(Consumer<FrameworkMappingDetails.Builder> framework) {
            return this.framework((FrameworkMappingDetails)((FrameworkMappingDetails.Builder)FrameworkMappingDetails.builder().applyMutation(framework)).build());
        }

        public Builder commonControl(CommonControlMappingDetails var1);

        default public Builder commonControl(Consumer<CommonControlMappingDetails.Builder> commonControl) {
            return this.commonControl((CommonControlMappingDetails)((CommonControlMappingDetails.Builder)CommonControlMappingDetails.builder().applyMutation(commonControl)).build());
        }
    }
}

