/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ControlSeverity {
    LOW("LOW"),
    MEDIUM("MEDIUM"),
    HIGH("HIGH"),
    CRITICAL("CRITICAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ControlSeverity> VALUE_MAP;
    private final String value;

    private ControlSeverity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ControlSeverity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ControlSeverity> knownValues() {
        EnumSet<ControlSeverity> knownValues = EnumSet.allOf(ControlSeverity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ControlSeverity.class, ControlSeverity::toString);
    }
}

