/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controlcatalog.model.AssociatedDomainSummary;
import software.amazon.awssdk.services.controlcatalog.model.AssociatedObjectiveSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommonControlSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommonControlSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CommonControlSummary.getter(CommonControlSummary::arn)).setter(CommonControlSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CommonControlSummary.getter(CommonControlSummary::name)).setter(CommonControlSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CommonControlSummary.getter(CommonControlSummary::description)).setter(CommonControlSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<AssociatedDomainSummary> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Domain").getter(CommonControlSummary.getter(CommonControlSummary::domain)).setter(CommonControlSummary.setter(Builder::domain)).constructor(AssociatedDomainSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<AssociatedObjectiveSummary> OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Objective").getter(CommonControlSummary.getter(CommonControlSummary::objective)).setter(CommonControlSummary.setter(Builder::objective)).constructor(AssociatedObjectiveSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objective").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(CommonControlSummary.getter(CommonControlSummary::createTime)).setter(CommonControlSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(CommonControlSummary.getter(CommonControlSummary::lastUpdateTime)).setter(CommonControlSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DOMAIN_FIELD, OBJECTIVE_FIELD, CREATE_TIME_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final AssociatedDomainSummary domain;
    private final AssociatedObjectiveSummary objective;
    private final Instant createTime;
    private final Instant lastUpdateTime;

    private CommonControlSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.domain = builder.domain;
        this.objective = builder.objective;
        this.createTime = builder.createTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final AssociatedDomainSummary domain() {
        return this.domain;
    }

    public final AssociatedObjectiveSummary objective() {
        return this.objective;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.objective());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommonControlSummary)) {
            return false;
        }
        CommonControlSummary other = (CommonControlSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.objective(), other.objective()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"CommonControlSummary").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Domain", (Object)this.domain()).add("Objective", (Object)this.objective()).add("CreateTime", (Object)this.createTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Objective": {
                return Optional.ofNullable(clazz.cast(this.objective()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommonControlSummary, T> g) {
        return obj -> g.apply((CommonControlSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private AssociatedDomainSummary domain;
        private AssociatedObjectiveSummary objective;
        private Instant createTime;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CommonControlSummary model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.domain(model.domain);
            this.objective(model.objective);
            this.createTime(model.createTime);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AssociatedDomainSummary.Builder getDomain() {
            return this.domain != null ? this.domain.toBuilder() : null;
        }

        public final void setDomain(AssociatedDomainSummary.BuilderImpl domain) {
            this.domain = domain != null ? domain.build() : null;
        }

        @Override
        public final Builder domain(AssociatedDomainSummary domain) {
            this.domain = domain;
            return this;
        }

        public final AssociatedObjectiveSummary.Builder getObjective() {
            return this.objective != null ? this.objective.toBuilder() : null;
        }

        public final void setObjective(AssociatedObjectiveSummary.BuilderImpl objective) {
            this.objective = objective != null ? objective.build() : null;
        }

        @Override
        public final Builder objective(AssociatedObjectiveSummary objective) {
            this.objective = objective;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public CommonControlSummary build() {
            return new CommonControlSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommonControlSummary> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder domain(AssociatedDomainSummary var1);

        default public Builder domain(Consumer<AssociatedDomainSummary.Builder> domain) {
            return this.domain((AssociatedDomainSummary)((AssociatedDomainSummary.Builder)AssociatedDomainSummary.builder().applyMutation(domain)).build());
        }

        public Builder objective(AssociatedObjectiveSummary var1);

        default public Builder objective(Consumer<AssociatedObjectiveSummary.Builder> objective) {
            return this.objective((AssociatedObjectiveSummary)((AssociatedObjectiveSummary.Builder)AssociatedObjectiveSummary.builder().applyMutation(objective)).build());
        }

        public Builder createTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

