/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcases.model.FieldNamespace;
import software.amazon.awssdk.services.connectcases.model.FieldType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldSummary> {
    private static final SdkField<String> FIELD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldArn").getter(FieldSummary.getter(FieldSummary::fieldArn)).setter(FieldSummary.setter(Builder::fieldArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldArn").build()}).build();
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldId").getter(FieldSummary.getter(FieldSummary::fieldId)).setter(FieldSummary.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(FieldSummary.getter(FieldSummary::name)).setter(FieldSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(FieldSummary.getter(FieldSummary::namespaceAsString)).setter(FieldSummary.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FieldSummary.getter(FieldSummary::typeAsString)).setter(FieldSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ARN_FIELD, FIELD_ID_FIELD, NAME_FIELD, NAMESPACE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FieldSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldArn;
    private final String fieldId;
    private final String name;
    private final String namespace;
    private final String type;

    private FieldSummary(BuilderImpl builder) {
        this.fieldArn = builder.fieldArn;
        this.fieldId = builder.fieldId;
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.type = builder.type;
    }

    public final String fieldArn() {
        return this.fieldArn;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final String name() {
        return this.name;
    }

    public final FieldNamespace namespace() {
        return FieldNamespace.fromValue(this.namespace);
    }

    public final String namespaceAsString() {
        return this.namespace;
    }

    public final FieldType type() {
        return FieldType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldSummary)) {
            return false;
        }
        FieldSummary other = (FieldSummary)obj;
        return Objects.equals(this.fieldArn(), other.fieldArn()) && Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.namespaceAsString(), other.namespaceAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FieldSummary").add("FieldArn", (Object)this.fieldArn()).add("FieldId", (Object)this.fieldId()).add("Name", (Object)this.name()).add("Namespace", (Object)this.namespaceAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldArn": {
                return Optional.ofNullable(clazz.cast(this.fieldArn()));
            }
            case "fieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespaceAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("fieldArn", FIELD_ARN_FIELD);
        map.put("fieldId", FIELD_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldSummary, T> g) {
        return obj -> g.apply((FieldSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldArn;
        private String fieldId;
        private String name;
        private String namespace;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldSummary model) {
            this.fieldArn(model.fieldArn);
            this.fieldId(model.fieldId);
            this.name(model.name);
            this.namespace(model.namespace);
            this.type(model.type);
        }

        public final String getFieldArn() {
            return this.fieldArn;
        }

        public final void setFieldArn(String fieldArn) {
            this.fieldArn = fieldArn;
        }

        @Override
        public final Builder fieldArn(String fieldArn) {
            this.fieldArn = fieldArn;
            return this;
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(FieldNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FieldType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public FieldSummary build() {
            return new FieldSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldSummary> {
        public Builder fieldArn(String var1);

        public Builder fieldId(String var1);

        public Builder name(String var1);

        public Builder namespace(String var1);

        public Builder namespace(FieldNamespace var1);

        public Builder type(String var1);

        public Builder type(FieldType var1);
    }
}

