/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcases.model.CaseEventIncludedData;
import software.amazon.awssdk.services.connectcases.model.RelatedItemEventIncludedData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventIncludedData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventIncludedData> {
    private static final SdkField<CaseEventIncludedData> CASE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("caseData").getter(EventIncludedData.getter(EventIncludedData::caseData)).setter(EventIncludedData.setter(Builder::caseData)).constructor(CaseEventIncludedData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseData").build()}).build();
    private static final SdkField<RelatedItemEventIncludedData> RELATED_ITEM_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("relatedItemData").getter(EventIncludedData.getter(EventIncludedData::relatedItemData)).setter(EventIncludedData.setter(Builder::relatedItemData)).constructor(RelatedItemEventIncludedData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_DATA_FIELD, RELATED_ITEM_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("caseData", CASE_DATA_FIELD);
            this.put("relatedItemData", RELATED_ITEM_DATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CaseEventIncludedData caseData;
    private final RelatedItemEventIncludedData relatedItemData;

    private EventIncludedData(BuilderImpl builder) {
        this.caseData = builder.caseData;
        this.relatedItemData = builder.relatedItemData;
    }

    public final CaseEventIncludedData caseData() {
        return this.caseData;
    }

    public final RelatedItemEventIncludedData relatedItemData() {
        return this.relatedItemData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caseData());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedItemData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventIncludedData)) {
            return false;
        }
        EventIncludedData other = (EventIncludedData)obj;
        return Objects.equals(this.caseData(), other.caseData()) && Objects.equals(this.relatedItemData(), other.relatedItemData());
    }

    public final String toString() {
        return ToString.builder((String)"EventIncludedData").add("CaseData", (Object)this.caseData()).add("RelatedItemData", (Object)this.relatedItemData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseData": {
                return Optional.ofNullable(clazz.cast(this.caseData()));
            }
            case "relatedItemData": {
                return Optional.ofNullable(clazz.cast(this.relatedItemData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EventIncludedData, T> g) {
        return obj -> g.apply((EventIncludedData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CaseEventIncludedData caseData;
        private RelatedItemEventIncludedData relatedItemData;

        private BuilderImpl() {
        }

        private BuilderImpl(EventIncludedData model) {
            this.caseData(model.caseData);
            this.relatedItemData(model.relatedItemData);
        }

        public final CaseEventIncludedData.Builder getCaseData() {
            return this.caseData != null ? this.caseData.toBuilder() : null;
        }

        public final void setCaseData(CaseEventIncludedData.BuilderImpl caseData) {
            this.caseData = caseData != null ? caseData.build() : null;
        }

        @Override
        public final Builder caseData(CaseEventIncludedData caseData) {
            this.caseData = caseData;
            return this;
        }

        public final RelatedItemEventIncludedData.Builder getRelatedItemData() {
            return this.relatedItemData != null ? this.relatedItemData.toBuilder() : null;
        }

        public final void setRelatedItemData(RelatedItemEventIncludedData.BuilderImpl relatedItemData) {
            this.relatedItemData = relatedItemData != null ? relatedItemData.build() : null;
        }

        @Override
        public final Builder relatedItemData(RelatedItemEventIncludedData relatedItemData) {
            this.relatedItemData = relatedItemData;
            return this;
        }

        public EventIncludedData build() {
            return new EventIncludedData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventIncludedData> {
        public Builder caseData(CaseEventIncludedData var1);

        default public Builder caseData(Consumer<CaseEventIncludedData.Builder> caseData) {
            return this.caseData((CaseEventIncludedData)((CaseEventIncludedData.Builder)CaseEventIncludedData.builder().applyMutation(caseData)).build());
        }

        public Builder relatedItemData(RelatedItemEventIncludedData var1);

        default public Builder relatedItemData(Consumer<RelatedItemEventIncludedData.Builder> relatedItemData) {
            return this.relatedItemData((RelatedItemEventIncludedData)((RelatedItemEventIncludedData.Builder)RelatedItemEventIncludedData.builder().applyMutation(relatedItemData)).build());
        }
    }
}

