/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.CurrentMetricResult;
import software.amazon.awssdk.services.connect.model.CurrentMetricResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCurrentMetricDataResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, GetCurrentMetricDataResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCurrentMetricDataResponse.getter(GetCurrentMetricDataResponse::nextToken)).setter(GetCurrentMetricDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<CurrentMetricResult>> METRIC_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetCurrentMetricDataResponse.getter(GetCurrentMetricDataResponse::metricResults)).setter(GetCurrentMetricDataResponse.setter(Builder::metricResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CurrentMetricResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> DATA_SNAPSHOT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetCurrentMetricDataResponse.getter(GetCurrentMetricDataResponse::dataSnapshotTime)).setter(GetCurrentMetricDataResponse.setter(Builder::dataSnapshotTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSnapshotTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, METRIC_RESULTS_FIELD, DATA_SNAPSHOT_TIME_FIELD));
    private final String nextToken;
    private final List<CurrentMetricResult> metricResults;
    private final Instant dataSnapshotTime;

    private GetCurrentMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.metricResults = builder.metricResults;
        this.dataSnapshotTime = builder.dataSnapshotTime;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<CurrentMetricResult> metricResults() {
        return this.metricResults;
    }

    public Instant dataSnapshotTime() {
        return this.dataSnapshotTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSnapshotTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCurrentMetricDataResponse)) {
            return false;
        }
        GetCurrentMetricDataResponse other = (GetCurrentMetricDataResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.metricResults(), other.metricResults()) && Objects.equals(this.dataSnapshotTime(), other.dataSnapshotTime());
    }

    public String toString() {
        return ToString.builder((String)"GetCurrentMetricDataResponse").add("NextToken", (Object)this.nextToken()).add("MetricResults", this.metricResults()).add("DataSnapshotTime", (Object)this.dataSnapshotTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MetricResults": {
                return Optional.ofNullable(clazz.cast(this.metricResults()));
            }
            case "DataSnapshotTime": {
                return Optional.ofNullable(clazz.cast(this.dataSnapshotTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCurrentMetricDataResponse, T> g) {
        return obj -> g.apply((GetCurrentMetricDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CurrentMetricResult> metricResults = DefaultSdkAutoConstructList.getInstance();
        private Instant dataSnapshotTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCurrentMetricDataResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.metricResults(model.metricResults);
            this.dataSnapshotTime(model.dataSnapshotTime);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CurrentMetricResult.Builder> getMetricResults() {
            return this.metricResults != null ? (Collection)this.metricResults.stream().map(CurrentMetricResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricResults(Collection<CurrentMetricResult> metricResults) {
            this.metricResults = CurrentMetricResultsCopier.copy(metricResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(CurrentMetricResult ... metricResults) {
            this.metricResults(Arrays.asList(metricResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(Consumer<CurrentMetricResult.Builder> ... metricResults) {
            this.metricResults(Stream.of(metricResults).map(c -> (CurrentMetricResult)((CurrentMetricResult.Builder)CurrentMetricResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricResults(Collection<CurrentMetricResult.BuilderImpl> metricResults) {
            this.metricResults = CurrentMetricResultsCopier.copyFromBuilder(metricResults);
        }

        public final Instant getDataSnapshotTime() {
            return this.dataSnapshotTime;
        }

        @Override
        public final Builder dataSnapshotTime(Instant dataSnapshotTime) {
            this.dataSnapshotTime = dataSnapshotTime;
            return this;
        }

        public final void setDataSnapshotTime(Instant dataSnapshotTime) {
            this.dataSnapshotTime = dataSnapshotTime;
        }

        @Override
        public GetCurrentMetricDataResponse build() {
            return new GetCurrentMetricDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCurrentMetricDataResponse> {
        public Builder nextToken(String var1);

        public Builder metricResults(Collection<CurrentMetricResult> var1);

        public Builder metricResults(CurrentMetricResult ... var1);

        public Builder metricResults(Consumer<CurrentMetricResult.Builder> ... var1);

        public Builder dataSnapshotTime(Instant var1);
    }
}

