/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed theme configuration for a workspace, including colors, images, and typography.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceThemeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceThemeConfig.Builder, WorkspaceThemeConfig> {
    private static final SdkField<WorkspaceThemePalette> PALETTE_FIELD = SdkField
            .<WorkspaceThemePalette> builder(MarshallingType.SDK_POJO).memberName("Palette")
            .getter(getter(WorkspaceThemeConfig::palette)).setter(setter(Builder::palette))
            .constructor(WorkspaceThemePalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Palette").build()).build();

    private static final SdkField<WorkspaceThemeImages> IMAGES_FIELD = SdkField
            .<WorkspaceThemeImages> builder(MarshallingType.SDK_POJO).memberName("Images")
            .getter(getter(WorkspaceThemeConfig::images)).setter(setter(Builder::images))
            .constructor(WorkspaceThemeImages::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Images").build()).build();

    private static final SdkField<WorkspaceThemeTypography> TYPOGRAPHY_FIELD = SdkField
            .<WorkspaceThemeTypography> builder(MarshallingType.SDK_POJO).memberName("Typography")
            .getter(getter(WorkspaceThemeConfig::typography)).setter(setter(Builder::typography))
            .constructor(WorkspaceThemeTypography::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Typography").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PALETTE_FIELD, IMAGES_FIELD,
            TYPOGRAPHY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WorkspaceThemePalette palette;

    private final WorkspaceThemeImages images;

    private final WorkspaceThemeTypography typography;

    private WorkspaceThemeConfig(BuilderImpl builder) {
        this.palette = builder.palette;
        this.images = builder.images;
        this.typography = builder.typography;
    }

    /**
     * <p>
     * The color palette configuration for the workspace theme.
     * </p>
     * 
     * @return The color palette configuration for the workspace theme.
     */
    public final WorkspaceThemePalette palette() {
        return palette;
    }

    /**
     * <p>
     * The image assets used in the workspace theme.
     * </p>
     * 
     * @return The image assets used in the workspace theme.
     */
    public final WorkspaceThemeImages images() {
        return images;
    }

    /**
     * <p>
     * The typography configuration for the workspace theme.
     * </p>
     * 
     * @return The typography configuration for the workspace theme.
     */
    public final WorkspaceThemeTypography typography() {
        return typography;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(palette());
        hashCode = 31 * hashCode + Objects.hashCode(images());
        hashCode = 31 * hashCode + Objects.hashCode(typography());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceThemeConfig)) {
            return false;
        }
        WorkspaceThemeConfig other = (WorkspaceThemeConfig) obj;
        return Objects.equals(palette(), other.palette()) && Objects.equals(images(), other.images())
                && Objects.equals(typography(), other.typography());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceThemeConfig").add("Palette", palette()).add("Images", images())
                .add("Typography", typography()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Palette":
            return Optional.ofNullable(clazz.cast(palette()));
        case "Images":
            return Optional.ofNullable(clazz.cast(images()));
        case "Typography":
            return Optional.ofNullable(clazz.cast(typography()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Palette", PALETTE_FIELD);
        map.put("Images", IMAGES_FIELD);
        map.put("Typography", TYPOGRAPHY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceThemeConfig, T> g) {
        return obj -> g.apply((WorkspaceThemeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceThemeConfig> {
        /**
         * <p>
         * The color palette configuration for the workspace theme.
         * </p>
         * 
         * @param palette
         *        The color palette configuration for the workspace theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder palette(WorkspaceThemePalette palette);

        /**
         * <p>
         * The color palette configuration for the workspace theme.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceThemePalette.Builder} avoiding
         * the need to create one manually via {@link WorkspaceThemePalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceThemePalette.Builder#build()} is called immediately and
         * its result is passed to {@link #palette(WorkspaceThemePalette)}.
         * 
         * @param palette
         *        a consumer that will call methods on {@link WorkspaceThemePalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #palette(WorkspaceThemePalette)
         */
        default Builder palette(Consumer<WorkspaceThemePalette.Builder> palette) {
            return palette(WorkspaceThemePalette.builder().applyMutation(palette).build());
        }

        /**
         * <p>
         * The image assets used in the workspace theme.
         * </p>
         * 
         * @param images
         *        The image assets used in the workspace theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(WorkspaceThemeImages images);

        /**
         * <p>
         * The image assets used in the workspace theme.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceThemeImages.Builder} avoiding
         * the need to create one manually via {@link WorkspaceThemeImages#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceThemeImages.Builder#build()} is called immediately and
         * its result is passed to {@link #images(WorkspaceThemeImages)}.
         * 
         * @param images
         *        a consumer that will call methods on {@link WorkspaceThemeImages.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(WorkspaceThemeImages)
         */
        default Builder images(Consumer<WorkspaceThemeImages.Builder> images) {
            return images(WorkspaceThemeImages.builder().applyMutation(images).build());
        }

        /**
         * <p>
         * The typography configuration for the workspace theme.
         * </p>
         * 
         * @param typography
         *        The typography configuration for the workspace theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typography(WorkspaceThemeTypography typography);

        /**
         * <p>
         * The typography configuration for the workspace theme.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceThemeTypography.Builder}
         * avoiding the need to create one manually via {@link WorkspaceThemeTypography#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceThemeTypography.Builder#build()} is called immediately
         * and its result is passed to {@link #typography(WorkspaceThemeTypography)}.
         * 
         * @param typography
         *        a consumer that will call methods on {@link WorkspaceThemeTypography.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typography(WorkspaceThemeTypography)
         */
        default Builder typography(Consumer<WorkspaceThemeTypography.Builder> typography) {
            return typography(WorkspaceThemeTypography.builder().applyMutation(typography).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WorkspaceThemePalette palette;

        private WorkspaceThemeImages images;

        private WorkspaceThemeTypography typography;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceThemeConfig model) {
            palette(model.palette);
            images(model.images);
            typography(model.typography);
        }

        public final WorkspaceThemePalette.Builder getPalette() {
            return palette != null ? palette.toBuilder() : null;
        }

        public final void setPalette(WorkspaceThemePalette.BuilderImpl palette) {
            this.palette = palette != null ? palette.build() : null;
        }

        @Override
        public final Builder palette(WorkspaceThemePalette palette) {
            this.palette = palette;
            return this;
        }

        public final WorkspaceThemeImages.Builder getImages() {
            return images != null ? images.toBuilder() : null;
        }

        public final void setImages(WorkspaceThemeImages.BuilderImpl images) {
            this.images = images != null ? images.build() : null;
        }

        @Override
        public final Builder images(WorkspaceThemeImages images) {
            this.images = images;
            return this;
        }

        public final WorkspaceThemeTypography.Builder getTypography() {
            return typography != null ? typography.toBuilder() : null;
        }

        public final void setTypography(WorkspaceThemeTypography.BuilderImpl typography) {
            this.typography = typography != null ? typography.build() : null;
        }

        @Override
        public final Builder typography(WorkspaceThemeTypography typography) {
            this.typography = typography;
            return this;
        }

        @Override
        public WorkspaceThemeConfig build() {
            return new WorkspaceThemeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
