/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains theme configuration for a workspace, supporting both light and dark modes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceTheme implements SdkPojo, Serializable, ToCopyableBuilder<WorkspaceTheme.Builder, WorkspaceTheme> {
    private static final SdkField<WorkspaceThemeConfig> LIGHT_FIELD = SdkField
            .<WorkspaceThemeConfig> builder(MarshallingType.SDK_POJO).memberName("Light").getter(getter(WorkspaceTheme::light))
            .setter(setter(Builder::light)).constructor(WorkspaceThemeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Light").build()).build();

    private static final SdkField<WorkspaceThemeConfig> DARK_FIELD = SdkField
            .<WorkspaceThemeConfig> builder(MarshallingType.SDK_POJO).memberName("Dark").getter(getter(WorkspaceTheme::dark))
            .setter(setter(Builder::dark)).constructor(WorkspaceThemeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dark").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIGHT_FIELD, DARK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WorkspaceThemeConfig light;

    private final WorkspaceThemeConfig dark;

    private WorkspaceTheme(BuilderImpl builder) {
        this.light = builder.light;
        this.dark = builder.dark;
    }

    /**
     * <p>
     * The theme configuration for light mode.
     * </p>
     * 
     * @return The theme configuration for light mode.
     */
    public final WorkspaceThemeConfig light() {
        return light;
    }

    /**
     * <p>
     * The theme configuration for dark mode.
     * </p>
     * 
     * @return The theme configuration for dark mode.
     */
    public final WorkspaceThemeConfig dark() {
        return dark;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(light());
        hashCode = 31 * hashCode + Objects.hashCode(dark());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceTheme)) {
            return false;
        }
        WorkspaceTheme other = (WorkspaceTheme) obj;
        return Objects.equals(light(), other.light()) && Objects.equals(dark(), other.dark());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceTheme").add("Light", light()).add("Dark", dark()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Light":
            return Optional.ofNullable(clazz.cast(light()));
        case "Dark":
            return Optional.ofNullable(clazz.cast(dark()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Light", LIGHT_FIELD);
        map.put("Dark", DARK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceTheme, T> g) {
        return obj -> g.apply((WorkspaceTheme) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceTheme> {
        /**
         * <p>
         * The theme configuration for light mode.
         * </p>
         * 
         * @param light
         *        The theme configuration for light mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder light(WorkspaceThemeConfig light);

        /**
         * <p>
         * The theme configuration for light mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceThemeConfig.Builder} avoiding
         * the need to create one manually via {@link WorkspaceThemeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceThemeConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #light(WorkspaceThemeConfig)}.
         * 
         * @param light
         *        a consumer that will call methods on {@link WorkspaceThemeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #light(WorkspaceThemeConfig)
         */
        default Builder light(Consumer<WorkspaceThemeConfig.Builder> light) {
            return light(WorkspaceThemeConfig.builder().applyMutation(light).build());
        }

        /**
         * <p>
         * The theme configuration for dark mode.
         * </p>
         * 
         * @param dark
         *        The theme configuration for dark mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dark(WorkspaceThemeConfig dark);

        /**
         * <p>
         * The theme configuration for dark mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceThemeConfig.Builder} avoiding
         * the need to create one manually via {@link WorkspaceThemeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceThemeConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #dark(WorkspaceThemeConfig)}.
         * 
         * @param dark
         *        a consumer that will call methods on {@link WorkspaceThemeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dark(WorkspaceThemeConfig)
         */
        default Builder dark(Consumer<WorkspaceThemeConfig.Builder> dark) {
            return dark(WorkspaceThemeConfig.builder().applyMutation(dark).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WorkspaceThemeConfig light;

        private WorkspaceThemeConfig dark;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceTheme model) {
            light(model.light);
            dark(model.dark);
        }

        public final WorkspaceThemeConfig.Builder getLight() {
            return light != null ? light.toBuilder() : null;
        }

        public final void setLight(WorkspaceThemeConfig.BuilderImpl light) {
            this.light = light != null ? light.build() : null;
        }

        @Override
        public final Builder light(WorkspaceThemeConfig light) {
            this.light = light;
            return this;
        }

        public final WorkspaceThemeConfig.Builder getDark() {
            return dark != null ? dark.toBuilder() : null;
        }

        public final void setDark(WorkspaceThemeConfig.BuilderImpl dark) {
            this.dark = dark != null ? dark.build() : null;
        }

        @Override
        public final Builder dark(WorkspaceThemeConfig dark) {
            this.dark = dark;
            return this;
        }

        @Override
        public WorkspaceTheme build() {
            return new WorkspaceTheme(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
