/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a page configuration in a workspace, including the view assigned to the page.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspacePage implements SdkPojo, Serializable, ToCopyableBuilder<WorkspacePage.Builder, WorkspacePage> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(WorkspacePage::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> PAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Page")
            .getter(getter(WorkspacePage::page)).setter(setter(Builder::page))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Page").build()).build();

    private static final SdkField<String> SLUG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Slug")
            .getter(getter(WorkspacePage::slug)).setter(setter(Builder::slug))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slug").build()).build();

    private static final SdkField<String> INPUT_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputData").getter(getter(WorkspacePage::inputData)).setter(setter(Builder::inputData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            PAGE_FIELD, SLUG_FIELD, INPUT_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String page;

    private final String slug;

    private final String inputData;

    private WorkspacePage(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.page = builder.page;
        this.slug = builder.slug;
        this.inputData = builder.inputData;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the view associated with this page.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the view associated with this page.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The page identifier. System pages include <code>HOME</code> and <code>AGENT_EXPERIENCE</code>.
     * </p>
     * 
     * @return The page identifier. System pages include <code>HOME</code> and <code>AGENT_EXPERIENCE</code>.
     */
    public final String page() {
        return page;
    }

    /**
     * <p>
     * The URL-friendly identifier for the page.
     * </p>
     * 
     * @return The URL-friendly identifier for the page.
     */
    public final String slug() {
        return slug;
    }

    /**
     * <p>
     * A JSON string containing input parameters passed to the view when the page is rendered.
     * </p>
     * 
     * @return A JSON string containing input parameters passed to the view when the page is rendered.
     */
    public final String inputData() {
        return inputData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(page());
        hashCode = 31 * hashCode + Objects.hashCode(slug());
        hashCode = 31 * hashCode + Objects.hashCode(inputData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspacePage)) {
            return false;
        }
        WorkspacePage other = (WorkspacePage) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(page(), other.page())
                && Objects.equals(slug(), other.slug()) && Objects.equals(inputData(), other.inputData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspacePage").add("ResourceArn", resourceArn()).add("Page", page()).add("Slug", slug())
                .add("InputData", inputData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Page":
            return Optional.ofNullable(clazz.cast(page()));
        case "Slug":
            return Optional.ofNullable(clazz.cast(slug()));
        case "InputData":
            return Optional.ofNullable(clazz.cast(inputData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Page", PAGE_FIELD);
        map.put("Slug", SLUG_FIELD);
        map.put("InputData", INPUT_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspacePage, T> g) {
        return obj -> g.apply((WorkspacePage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspacePage> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the view associated with this page.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the view associated with this page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The page identifier. System pages include <code>HOME</code> and <code>AGENT_EXPERIENCE</code>.
         * </p>
         * 
         * @param page
         *        The page identifier. System pages include <code>HOME</code> and <code>AGENT_EXPERIENCE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder page(String page);

        /**
         * <p>
         * The URL-friendly identifier for the page.
         * </p>
         * 
         * @param slug
         *        The URL-friendly identifier for the page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slug(String slug);

        /**
         * <p>
         * A JSON string containing input parameters passed to the view when the page is rendered.
         * </p>
         * 
         * @param inputData
         *        A JSON string containing input parameters passed to the view when the page is rendered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputData(String inputData);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String page;

        private String slug;

        private String inputData;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspacePage model) {
            resourceArn(model.resourceArn);
            page(model.page);
            slug(model.slug);
            inputData(model.inputData);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPage() {
            return page;
        }

        public final void setPage(String page) {
            this.page = page;
        }

        @Override
        public final Builder page(String page) {
            this.page = page;
            return this;
        }

        public final String getSlug() {
            return slug;
        }

        public final void setSlug(String slug) {
            this.slug = slug;
        }

        @Override
        public final Builder slug(String slug) {
            this.slug = slug;
            return this;
        }

        public final String getInputData() {
            return inputData;
        }

        public final void setInputData(String inputData) {
            this.inputData = inputData;
        }

        @Override
        public final Builder inputData(String inputData) {
            this.inputData = inputData;
            return this;
        }

        @Override
        public WorkspacePage build() {
            return new WorkspacePage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
