/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the search criteria for filtering views.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewSearchCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<ViewSearchCriteria.Builder, ViewSearchCriteria> {
    private static final SdkField<List<ViewSearchCriteria>> OR_CONDITIONS_FIELD = SdkField
            .<List<ViewSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("OrConditions")
            .getter(getter(ViewSearchCriteria::orConditions))
            .setter(setter(Builder::orConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ViewSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(ViewSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ViewSearchCriteria>> AND_CONDITIONS_FIELD = SdkField
            .<List<ViewSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("AndConditions")
            .getter(getter(ViewSearchCriteria::andConditions))
            .setter(setter(Builder::andConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ViewSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(ViewSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField
            .<StringCondition> builder(MarshallingType.SDK_POJO).memberName("StringCondition")
            .getter(getter(ViewSearchCriteria::stringCondition)).setter(setter(Builder::stringCondition))
            .constructor(StringCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()).build();

    private static final SdkField<String> VIEW_TYPE_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewTypeCondition").getter(getter(ViewSearchCriteria::viewTypeConditionAsString))
            .setter(setter(Builder::viewTypeCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewTypeCondition").build()).build();

    private static final SdkField<String> VIEW_STATUS_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewStatusCondition").getter(getter(ViewSearchCriteria::viewStatusConditionAsString))
            .setter(setter(Builder::viewStatusCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewStatusCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD,
            AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD, VIEW_TYPE_CONDITION_FIELD, VIEW_STATUS_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ViewSearchCriteria> orConditions;

    private final List<ViewSearchCriteria> andConditions;

    private final StringCondition stringCondition;

    private final String viewTypeCondition;

    private final String viewStatusCondition;

    private ViewSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
        this.viewTypeCondition = builder.viewTypeCondition;
        this.viewStatusCondition = builder.viewStatusCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrConditions() {
        return orConditions != null && !(orConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions to be met, where at least one condition must be satisfied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrConditions} method.
     * </p>
     * 
     * @return A list of conditions to be met, where at least one condition must be satisfied.
     */
    public final List<ViewSearchCriteria> orConditions() {
        return orConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndConditions() {
        return andConditions != null && !(andConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions that must all be satisfied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndConditions} method.
     * </p>
     * 
     * @return A list of conditions that must all be satisfied.
     */
    public final List<ViewSearchCriteria> andConditions() {
        return andConditions;
    }

    /**
     * Returns the value of the StringCondition property for this object.
     * 
     * @return The value of the StringCondition property for this object.
     */
    public final StringCondition stringCondition() {
        return stringCondition;
    }

    /**
     * <p>
     * A condition that filters views by their type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #viewTypeCondition}
     * will return {@link ViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #viewTypeConditionAsString}.
     * </p>
     * 
     * @return A condition that filters views by their type.
     * @see ViewType
     */
    public final ViewType viewTypeCondition() {
        return ViewType.fromValue(viewTypeCondition);
    }

    /**
     * <p>
     * A condition that filters views by their type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #viewTypeCondition}
     * will return {@link ViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #viewTypeConditionAsString}.
     * </p>
     * 
     * @return A condition that filters views by their type.
     * @see ViewType
     */
    public final String viewTypeConditionAsString() {
        return viewTypeCondition;
    }

    /**
     * <p>
     * A condition that filters views by their status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #viewStatusCondition} will return {@link ViewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #viewStatusConditionAsString}.
     * </p>
     * 
     * @return A condition that filters views by their status.
     * @see ViewStatus
     */
    public final ViewStatus viewStatusCondition() {
        return ViewStatus.fromValue(viewStatusCondition);
    }

    /**
     * <p>
     * A condition that filters views by their status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #viewStatusCondition} will return {@link ViewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #viewStatusConditionAsString}.
     * </p>
     * 
     * @return A condition that filters views by their status.
     * @see ViewStatus
     */
    public final String viewStatusConditionAsString() {
        return viewStatusCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrConditions() ? orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAndConditions() ? andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(viewTypeConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(viewStatusConditionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewSearchCriteria)) {
            return false;
        }
        ViewSearchCriteria other = (ViewSearchCriteria) obj;
        return hasOrConditions() == other.hasOrConditions() && Objects.equals(orConditions(), other.orConditions())
                && hasAndConditions() == other.hasAndConditions() && Objects.equals(andConditions(), other.andConditions())
                && Objects.equals(stringCondition(), other.stringCondition())
                && Objects.equals(viewTypeConditionAsString(), other.viewTypeConditionAsString())
                && Objects.equals(viewStatusConditionAsString(), other.viewStatusConditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewSearchCriteria").add("OrConditions", hasOrConditions() ? orConditions() : null)
                .add("AndConditions", hasAndConditions() ? andConditions() : null).add("StringCondition", stringCondition())
                .add("ViewTypeCondition", viewTypeConditionAsString()).add("ViewStatusCondition", viewStatusConditionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrConditions":
            return Optional.ofNullable(clazz.cast(orConditions()));
        case "AndConditions":
            return Optional.ofNullable(clazz.cast(andConditions()));
        case "StringCondition":
            return Optional.ofNullable(clazz.cast(stringCondition()));
        case "ViewTypeCondition":
            return Optional.ofNullable(clazz.cast(viewTypeConditionAsString()));
        case "ViewStatusCondition":
            return Optional.ofNullable(clazz.cast(viewStatusConditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrConditions", OR_CONDITIONS_FIELD);
        map.put("AndConditions", AND_CONDITIONS_FIELD);
        map.put("StringCondition", STRING_CONDITION_FIELD);
        map.put("ViewTypeCondition", VIEW_TYPE_CONDITION_FIELD);
        map.put("ViewStatusCondition", VIEW_STATUS_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewSearchCriteria, T> g) {
        return obj -> g.apply((ViewSearchCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewSearchCriteria> {
        /**
         * <p>
         * A list of conditions to be met, where at least one condition must be satisfied.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions to be met, where at least one condition must be satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<ViewSearchCriteria> orConditions);

        /**
         * <p>
         * A list of conditions to be met, where at least one condition must be satisfied.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions to be met, where at least one condition must be satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(ViewSearchCriteria... orConditions);

        /**
         * <p>
         * A list of conditions to be met, where at least one condition must be satisfied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ViewSearchCriteria.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.ViewSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ViewSearchCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #orConditions(List<ViewSearchCriteria>)}.
         * 
         * @param orConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ViewSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orConditions(java.util.Collection<ViewSearchCriteria>)
         */
        Builder orConditions(Consumer<Builder>... orConditions);

        /**
         * <p>
         * A list of conditions that must all be satisfied.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions that must all be satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(Collection<ViewSearchCriteria> andConditions);

        /**
         * <p>
         * A list of conditions that must all be satisfied.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions that must all be satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(ViewSearchCriteria... andConditions);

        /**
         * <p>
         * A list of conditions that must all be satisfied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ViewSearchCriteria.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.ViewSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ViewSearchCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #andConditions(List<ViewSearchCriteria>)}.
         * 
         * @param andConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ViewSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andConditions(java.util.Collection<ViewSearchCriteria>)
         */
        Builder andConditions(Consumer<Builder>... andConditions);

        /**
         * Sets the value of the StringCondition property for this object.
         *
         * @param stringCondition
         *        The new value for the StringCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringCondition(StringCondition stringCondition);

        /**
         * Sets the value of the StringCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StringCondition.Builder} avoiding the
         * need to create one manually via {@link StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stringCondition(StringCondition)}.
         * 
         * @param stringCondition
         *        a consumer that will call methods on {@link StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringCondition(StringCondition)
         */
        default Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return stringCondition(StringCondition.builder().applyMutation(stringCondition).build());
        }

        /**
         * <p>
         * A condition that filters views by their type.
         * </p>
         * 
         * @param viewTypeCondition
         *        A condition that filters views by their type.
         * @see ViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewType
         */
        Builder viewTypeCondition(String viewTypeCondition);

        /**
         * <p>
         * A condition that filters views by their type.
         * </p>
         * 
         * @param viewTypeCondition
         *        A condition that filters views by their type.
         * @see ViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewType
         */
        Builder viewTypeCondition(ViewType viewTypeCondition);

        /**
         * <p>
         * A condition that filters views by their status.
         * </p>
         * 
         * @param viewStatusCondition
         *        A condition that filters views by their status.
         * @see ViewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewStatus
         */
        Builder viewStatusCondition(String viewStatusCondition);

        /**
         * <p>
         * A condition that filters views by their status.
         * </p>
         * 
         * @param viewStatusCondition
         *        A condition that filters views by their status.
         * @see ViewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewStatus
         */
        Builder viewStatusCondition(ViewStatus viewStatusCondition);
    }

    static final class BuilderImpl implements Builder {
        private List<ViewSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();

        private List<ViewSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();

        private StringCondition stringCondition;

        private String viewTypeCondition;

        private String viewStatusCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewSearchCriteria model) {
            orConditions(model.orConditions);
            andConditions(model.andConditions);
            stringCondition(model.stringCondition);
            viewTypeCondition(model.viewTypeCondition);
            viewStatusCondition(model.viewStatusCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = ViewSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = ViewSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<ViewSearchCriteria> orConditions) {
            this.orConditions = ViewSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(ViewSearchCriteria... orConditions) {
            orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder>... orConditions) {
            orConditions(Stream.of(orConditions).map(c -> ViewSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = ViewSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = ViewSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<ViewSearchCriteria> andConditions) {
            this.andConditions = ViewSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(ViewSearchCriteria... andConditions) {
            andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder>... andConditions) {
            andConditions(Stream.of(andConditions).map(c -> ViewSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return stringCondition != null ? stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        public final String getViewTypeCondition() {
            return viewTypeCondition;
        }

        public final void setViewTypeCondition(String viewTypeCondition) {
            this.viewTypeCondition = viewTypeCondition;
        }

        @Override
        public final Builder viewTypeCondition(String viewTypeCondition) {
            this.viewTypeCondition = viewTypeCondition;
            return this;
        }

        @Override
        public final Builder viewTypeCondition(ViewType viewTypeCondition) {
            this.viewTypeCondition(viewTypeCondition == null ? null : viewTypeCondition.toString());
            return this;
        }

        public final String getViewStatusCondition() {
            return viewStatusCondition;
        }

        public final void setViewStatusCondition(String viewStatusCondition) {
            this.viewStatusCondition = viewStatusCondition;
        }

        @Override
        public final Builder viewStatusCondition(String viewStatusCondition) {
            this.viewStatusCondition = viewStatusCondition;
            return this;
        }

        @Override
        public final Builder viewStatusCondition(ViewStatus viewStatusCondition) {
            this.viewStatusCondition(viewStatusCondition == null ? null : viewStatusCondition.toString());
            return this;
        }

        @Override
        public ViewSearchCriteria build() {
            return new ViewSearchCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
