/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkspacePageRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateWorkspacePageRequest.Builder, UpdateWorkspacePageRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateWorkspacePageRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceId").getter(getter(UpdateWorkspacePageRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkspaceId").build()).build();

    private static final SdkField<String> PAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Page")
            .getter(getter(UpdateWorkspacePageRequest::page)).setter(setter(Builder::page))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Page").build()).build();

    private static final SdkField<String> NEW_PAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewPage").getter(getter(UpdateWorkspacePageRequest::newPage)).setter(setter(Builder::newPage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPage").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(UpdateWorkspacePageRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> SLUG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Slug")
            .getter(getter(UpdateWorkspacePageRequest::slug)).setter(setter(Builder::slug))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slug").build()).build();

    private static final SdkField<String> INPUT_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputData").getter(getter(UpdateWorkspacePageRequest::inputData)).setter(setter(Builder::inputData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            WORKSPACE_ID_FIELD, PAGE_FIELD, NEW_PAGE_FIELD, RESOURCE_ARN_FIELD, SLUG_FIELD, INPUT_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String workspaceId;

    private final String page;

    private final String newPage;

    private final String resourceArn;

    private final String slug;

    private final String inputData;

    private UpdateWorkspacePageRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.workspaceId = builder.workspaceId;
        this.page = builder.page;
        this.newPage = builder.newPage;
        this.resourceArn = builder.resourceArn;
        this.slug = builder.slug;
        this.inputData = builder.inputData;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the workspace.
     * </p>
     * 
     * @return The identifier of the workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The current page identifier.
     * </p>
     * 
     * @return The current page identifier.
     */
    public final String page() {
        return page;
    }

    /**
     * <p>
     * The new page identifier, if changing the page name.
     * </p>
     * 
     * @return The new page identifier, if changing the page name.
     */
    public final String newPage() {
        return newPage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the view to associate with the page.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the view to associate with the page.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The URL-friendly identifier for the page.
     * </p>
     * 
     * @return The URL-friendly identifier for the page.
     */
    public final String slug() {
        return slug;
    }

    /**
     * <p>
     * A JSON string containing input parameters for the view.
     * </p>
     * 
     * @return A JSON string containing input parameters for the view.
     */
    public final String inputData() {
        return inputData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(page());
        hashCode = 31 * hashCode + Objects.hashCode(newPage());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(slug());
        hashCode = 31 * hashCode + Objects.hashCode(inputData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspacePageRequest)) {
            return false;
        }
        UpdateWorkspacePageRequest other = (UpdateWorkspacePageRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(workspaceId(), other.workspaceId())
                && Objects.equals(page(), other.page()) && Objects.equals(newPage(), other.newPage())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(slug(), other.slug())
                && Objects.equals(inputData(), other.inputData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkspacePageRequest").add("InstanceId", instanceId()).add("WorkspaceId", workspaceId())
                .add("Page", page()).add("NewPage", newPage()).add("ResourceArn", resourceArn()).add("Slug", slug())
                .add("InputData", inputData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "WorkspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "Page":
            return Optional.ofNullable(clazz.cast(page()));
        case "NewPage":
            return Optional.ofNullable(clazz.cast(newPage()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Slug":
            return Optional.ofNullable(clazz.cast(slug()));
        case "InputData":
            return Optional.ofNullable(clazz.cast(inputData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        map.put("Page", PAGE_FIELD);
        map.put("NewPage", NEW_PAGE_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Slug", SLUG_FIELD);
        map.put("InputData", INPUT_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspacePageRequest, T> g) {
        return obj -> g.apply((UpdateWorkspacePageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkspacePageRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the workspace.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The current page identifier.
         * </p>
         * 
         * @param page
         *        The current page identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder page(String page);

        /**
         * <p>
         * The new page identifier, if changing the page name.
         * </p>
         * 
         * @param newPage
         *        The new page identifier, if changing the page name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPage(String newPage);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the view to associate with the page.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the view to associate with the page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The URL-friendly identifier for the page.
         * </p>
         * 
         * @param slug
         *        The URL-friendly identifier for the page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slug(String slug);

        /**
         * <p>
         * A JSON string containing input parameters for the view.
         * </p>
         * 
         * @param inputData
         *        A JSON string containing input parameters for the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputData(String inputData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String workspaceId;

        private String page;

        private String newPage;

        private String resourceArn;

        private String slug;

        private String inputData;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspacePageRequest model) {
            super(model);
            instanceId(model.instanceId);
            workspaceId(model.workspaceId);
            page(model.page);
            newPage(model.newPage);
            resourceArn(model.resourceArn);
            slug(model.slug);
            inputData(model.inputData);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getPage() {
            return page;
        }

        public final void setPage(String page) {
            this.page = page;
        }

        @Override
        public final Builder page(String page) {
            this.page = page;
            return this;
        }

        public final String getNewPage() {
            return newPage;
        }

        public final void setNewPage(String newPage) {
            this.newPage = newPage;
        }

        @Override
        public final Builder newPage(String newPage) {
            this.newPage = newPage;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getSlug() {
            return slug;
        }

        public final void setSlug(String slug) {
            this.slug = slug;
        }

        @Override
        public final Builder slug(String slug) {
            this.slug = slug;
            return this;
        }

        public final String getInputData() {
            return inputData;
        }

        public final void setInputData(String inputData) {
            this.inputData = inputData;
        }

        @Override
        public final Builder inputData(String inputData) {
            this.inputData = inputData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspacePageRequest build() {
            return new UpdateWorkspacePageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
