/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTaskTemplateRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateTaskTemplateRequest.Builder, UpdateTaskTemplateRequest> {
    private static final SdkField<String> TASK_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskTemplateId").getter(getter(UpdateTaskTemplateRequest::taskTemplateId))
            .setter(setter(Builder::taskTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TaskTemplateId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateTaskTemplateRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateTaskTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateTaskTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(UpdateTaskTemplateRequest::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final SdkField<String> SELF_ASSIGN_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelfAssignFlowId").getter(getter(UpdateTaskTemplateRequest::selfAssignFlowId))
            .setter(setter(Builder::selfAssignFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfAssignFlowId").build()).build();

    private static final SdkField<TaskTemplateConstraints> CONSTRAINTS_FIELD = SdkField
            .<TaskTemplateConstraints> builder(MarshallingType.SDK_POJO).memberName("Constraints")
            .getter(getter(UpdateTaskTemplateRequest::constraints)).setter(setter(Builder::constraints))
            .constructor(TaskTemplateConstraints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()).build();

    private static final SdkField<TaskTemplateDefaults> DEFAULTS_FIELD = SdkField
            .<TaskTemplateDefaults> builder(MarshallingType.SDK_POJO).memberName("Defaults")
            .getter(getter(UpdateTaskTemplateRequest::defaults)).setter(setter(Builder::defaults))
            .constructor(TaskTemplateDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Defaults").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateTaskTemplateRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<TaskTemplateField>> FIELDS_FIELD = SdkField
            .<List<TaskTemplateField>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(UpdateTaskTemplateRequest::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskTemplateField> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskTemplateField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TEMPLATE_ID_FIELD,
            INSTANCE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CONTACT_FLOW_ID_FIELD, SELF_ASSIGN_FLOW_ID_FIELD,
            CONSTRAINTS_FIELD, DEFAULTS_FIELD, STATUS_FIELD, FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskTemplateId;

    private final String instanceId;

    private final String name;

    private final String description;

    private final String contactFlowId;

    private final String selfAssignFlowId;

    private final TaskTemplateConstraints constraints;

    private final TaskTemplateDefaults defaults;

    private final String status;

    private final List<TaskTemplateField> fields;

    private UpdateTaskTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.taskTemplateId = builder.taskTemplateId;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.description = builder.description;
        this.contactFlowId = builder.contactFlowId;
        this.selfAssignFlowId = builder.selfAssignFlowId;
        this.constraints = builder.constraints;
        this.defaults = builder.defaults;
        this.status = builder.status;
        this.fields = builder.fields;
    }

    /**
     * <p>
     * A unique identifier for the task template.
     * </p>
     * 
     * @return A unique identifier for the task template.
     */
    public final String taskTemplateId() {
        return taskTemplateId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the task template.
     * </p>
     * 
     * @return The name of the task template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the task template.
     * </p>
     * 
     * @return The description of the task template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the flow that runs by default when a task is created by referencing this template.
     * </p>
     * 
     * @return The identifier of the flow that runs by default when a task is created by referencing this template.
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    /**
     * <p>
     * The ContactFlowId for the flow that will be run if this template is used to create a self-assigned task.
     * </p>
     * 
     * @return The ContactFlowId for the flow that will be run if this template is used to create a self-assigned task.
     */
    public final String selfAssignFlowId() {
        return selfAssignFlowId;
    }

    /**
     * <p>
     * Constraints that are applicable to the fields listed.
     * </p>
     * 
     * @return Constraints that are applicable to the fields listed.
     */
    public final TaskTemplateConstraints constraints() {
        return constraints;
    }

    /**
     * <p>
     * The default values for fields when a task is created by referencing this template.
     * </p>
     * 
     * @return The default values for fields when a task is created by referencing this template.
     */
    public final TaskTemplateDefaults defaults() {
        return defaults;
    }

    /**
     * <p>
     * Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be
     * created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task that
     * refers to this template cannot be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can
     *         only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>,
     *         then a task that refers to this template cannot be created.
     * @see TaskTemplateStatus
     */
    public final TaskTemplateStatus status() {
        return TaskTemplateStatus.fromValue(status);
    }

    /**
     * <p>
     * Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be
     * created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task that
     * refers to this template cannot be created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can
     *         only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>,
     *         then a task that refers to this template cannot be created.
     * @see TaskTemplateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Fields that are part of the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return Fields that are part of the template.
     */
    public final List<TaskTemplateField> fields() {
        return fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(selfAssignFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(constraints());
        hashCode = 31 * hashCode + Objects.hashCode(defaults());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskTemplateRequest)) {
            return false;
        }
        UpdateTaskTemplateRequest other = (UpdateTaskTemplateRequest) obj;
        return Objects.equals(taskTemplateId(), other.taskTemplateId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(contactFlowId(), other.contactFlowId())
                && Objects.equals(selfAssignFlowId(), other.selfAssignFlowId())
                && Objects.equals(constraints(), other.constraints()) && Objects.equals(defaults(), other.defaults())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTaskTemplateRequest").add("TaskTemplateId", taskTemplateId())
                .add("InstanceId", instanceId()).add("Name", name()).add("Description", description())
                .add("ContactFlowId", contactFlowId()).add("SelfAssignFlowId", selfAssignFlowId())
                .add("Constraints", constraints()).add("Defaults", defaults()).add("Status", statusAsString())
                .add("Fields", hasFields() ? fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskTemplateId":
            return Optional.ofNullable(clazz.cast(taskTemplateId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "SelfAssignFlowId":
            return Optional.ofNullable(clazz.cast(selfAssignFlowId()));
        case "Constraints":
            return Optional.ofNullable(clazz.cast(constraints()));
        case "Defaults":
            return Optional.ofNullable(clazz.cast(defaults()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskTemplateId", TASK_TEMPLATE_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("SelfAssignFlowId", SELF_ASSIGN_FLOW_ID_FIELD);
        map.put("Constraints", CONSTRAINTS_FIELD);
        map.put("Defaults", DEFAULTS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskTemplateRequest, T> g) {
        return obj -> g.apply((UpdateTaskTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTaskTemplateRequest> {
        /**
         * <p>
         * A unique identifier for the task template.
         * </p>
         * 
         * @param taskTemplateId
         *        A unique identifier for the task template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskTemplateId(String taskTemplateId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the task template.
         * </p>
         * 
         * @param name
         *        The name of the task template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the task template.
         * </p>
         * 
         * @param description
         *        The description of the task template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the flow that runs by default when a task is created by referencing this template.
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the flow that runs by default when a task is created by referencing this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * The ContactFlowId for the flow that will be run if this template is used to create a self-assigned task.
         * </p>
         * 
         * @param selfAssignFlowId
         *        The ContactFlowId for the flow that will be run if this template is used to create a self-assigned
         *        task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfAssignFlowId(String selfAssignFlowId);

        /**
         * <p>
         * Constraints that are applicable to the fields listed.
         * </p>
         * 
         * @param constraints
         *        Constraints that are applicable to the fields listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraints(TaskTemplateConstraints constraints);

        /**
         * <p>
         * Constraints that are applicable to the fields listed.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskTemplateConstraints.Builder} avoiding
         * the need to create one manually via {@link TaskTemplateConstraints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskTemplateConstraints.Builder#build()} is called immediately
         * and its result is passed to {@link #constraints(TaskTemplateConstraints)}.
         * 
         * @param constraints
         *        a consumer that will call methods on {@link TaskTemplateConstraints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraints(TaskTemplateConstraints)
         */
        default Builder constraints(Consumer<TaskTemplateConstraints.Builder> constraints) {
            return constraints(TaskTemplateConstraints.builder().applyMutation(constraints).build());
        }

        /**
         * <p>
         * The default values for fields when a task is created by referencing this template.
         * </p>
         * 
         * @param defaults
         *        The default values for fields when a task is created by referencing this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaults(TaskTemplateDefaults defaults);

        /**
         * <p>
         * The default values for fields when a task is created by referencing this template.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskTemplateDefaults.Builder} avoiding
         * the need to create one manually via {@link TaskTemplateDefaults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskTemplateDefaults.Builder#build()} is called immediately and
         * its result is passed to {@link #defaults(TaskTemplateDefaults)}.
         * 
         * @param defaults
         *        a consumer that will call methods on {@link TaskTemplateDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaults(TaskTemplateDefaults)
         */
        default Builder defaults(Consumer<TaskTemplateDefaults.Builder> defaults) {
            return defaults(TaskTemplateDefaults.builder().applyMutation(defaults).build());
        }

        /**
         * <p>
         * Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be
         * created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task
         * that refers to this template cannot be created.
         * </p>
         * 
         * @param status
         *        Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can
         *        only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>,
         *        then a task that refers to this template cannot be created.
         * @see TaskTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskTemplateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be
         * created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task
         * that refers to this template cannot be created.
         * </p>
         * 
         * @param status
         *        Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can
         *        only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>,
         *        then a task that refers to this template cannot be created.
         * @see TaskTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskTemplateStatus
         */
        Builder status(TaskTemplateStatus status);

        /**
         * <p>
         * Fields that are part of the template.
         * </p>
         * 
         * @param fields
         *        Fields that are part of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<TaskTemplateField> fields);

        /**
         * <p>
         * Fields that are part of the template.
         * </p>
         * 
         * @param fields
         *        Fields that are part of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(TaskTemplateField... fields);

        /**
         * <p>
         * Fields that are part of the template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.TaskTemplateField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.TaskTemplateField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.TaskTemplateField.Builder#build()} is called immediately
         * and its result is passed to {@link #fields(List<TaskTemplateField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.TaskTemplateField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<TaskTemplateField>)
         */
        Builder fields(Consumer<TaskTemplateField.Builder>... fields);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String taskTemplateId;

        private String instanceId;

        private String name;

        private String description;

        private String contactFlowId;

        private String selfAssignFlowId;

        private TaskTemplateConstraints constraints;

        private TaskTemplateDefaults defaults;

        private String status;

        private List<TaskTemplateField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskTemplateRequest model) {
            super(model);
            taskTemplateId(model.taskTemplateId);
            instanceId(model.instanceId);
            name(model.name);
            description(model.description);
            contactFlowId(model.contactFlowId);
            selfAssignFlowId(model.selfAssignFlowId);
            constraints(model.constraints);
            defaults(model.defaults);
            status(model.status);
            fields(model.fields);
        }

        public final String getTaskTemplateId() {
            return taskTemplateId;
        }

        public final void setTaskTemplateId(String taskTemplateId) {
            this.taskTemplateId = taskTemplateId;
        }

        @Override
        public final Builder taskTemplateId(String taskTemplateId) {
            this.taskTemplateId = taskTemplateId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getSelfAssignFlowId() {
            return selfAssignFlowId;
        }

        public final void setSelfAssignFlowId(String selfAssignFlowId) {
            this.selfAssignFlowId = selfAssignFlowId;
        }

        @Override
        public final Builder selfAssignFlowId(String selfAssignFlowId) {
            this.selfAssignFlowId = selfAssignFlowId;
            return this;
        }

        public final TaskTemplateConstraints.Builder getConstraints() {
            return constraints != null ? constraints.toBuilder() : null;
        }

        public final void setConstraints(TaskTemplateConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public final Builder constraints(TaskTemplateConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final TaskTemplateDefaults.Builder getDefaults() {
            return defaults != null ? defaults.toBuilder() : null;
        }

        public final void setDefaults(TaskTemplateDefaults.BuilderImpl defaults) {
            this.defaults = defaults != null ? defaults.build() : null;
        }

        @Override
        public final Builder defaults(TaskTemplateDefaults defaults) {
            this.defaults = defaults;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<TaskTemplateField.Builder> getFields() {
            List<TaskTemplateField.Builder> result = TaskTemplateFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<TaskTemplateField.BuilderImpl> fields) {
            this.fields = TaskTemplateFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<TaskTemplateField> fields) {
            this.fields = TaskTemplateFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(TaskTemplateField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<TaskTemplateField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> TaskTemplateField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTaskTemplateRequest build() {
            return new UpdateTaskTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
