/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityProfileRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateSecurityProfileRequest.Builder, UpdateSecurityProfileRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateSecurityProfileRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(UpdateSecurityProfileRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECURITY_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityProfileId").getter(getter(UpdateSecurityProfileRequest::securityProfileId))
            .setter(setter(Builder::securityProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SecurityProfileId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateSecurityProfileRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<Map<String, String>> ALLOWED_ACCESS_CONTROL_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AllowedAccessControlTags")
            .getter(getter(UpdateSecurityProfileRequest::allowedAccessControlTags))
            .setter(setter(Builder::allowedAccessControlTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAccessControlTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> TAG_RESTRICTED_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagRestrictedResources")
            .getter(getter(UpdateSecurityProfileRequest::tagRestrictedResources))
            .setter(setter(Builder::tagRestrictedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagRestrictedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Application>> APPLICATIONS_FIELD = SdkField
            .<List<Application>> builder(MarshallingType.LIST)
            .memberName("Applications")
            .getter(getter(UpdateSecurityProfileRequest::applications))
            .setter(setter(Builder::applications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Application> builder(MarshallingType.SDK_POJO)
                                            .constructor(Application::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> HIERARCHY_RESTRICTED_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HierarchyRestrictedResources")
            .getter(getter(UpdateSecurityProfileRequest::hierarchyRestrictedResources))
            .setter(setter(Builder::hierarchyRestrictedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyRestrictedResources")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllowedAccessControlHierarchyGroupId")
            .getter(getter(UpdateSecurityProfileRequest::allowedAccessControlHierarchyGroupId))
            .setter(setter(Builder::allowedAccessControlHierarchyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AllowedAccessControlHierarchyGroupId").build()).build();

    private static final SdkField<List<FlowModule>> ALLOWED_FLOW_MODULES_FIELD = SdkField
            .<List<FlowModule>> builder(MarshallingType.LIST)
            .memberName("AllowedFlowModules")
            .getter(getter(UpdateSecurityProfileRequest::allowedFlowModules))
            .setter(setter(Builder::allowedFlowModules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedFlowModules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowModule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowModule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<GranularAccessControlConfiguration> GRANULAR_ACCESS_CONTROL_CONFIGURATION_FIELD = SdkField
            .<GranularAccessControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("GranularAccessControlConfiguration")
            .getter(getter(UpdateSecurityProfileRequest::granularAccessControlConfiguration))
            .setter(setter(Builder::granularAccessControlConfiguration))
            .constructor(GranularAccessControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranularAccessControlConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            PERMISSIONS_FIELD, SECURITY_PROFILE_ID_FIELD, INSTANCE_ID_FIELD, ALLOWED_ACCESS_CONTROL_TAGS_FIELD,
            TAG_RESTRICTED_RESOURCES_FIELD, APPLICATIONS_FIELD, HIERARCHY_RESTRICTED_RESOURCES_FIELD,
            ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD, ALLOWED_FLOW_MODULES_FIELD,
            GRANULAR_ACCESS_CONTROL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final List<String> permissions;

    private final String securityProfileId;

    private final String instanceId;

    private final Map<String, String> allowedAccessControlTags;

    private final List<String> tagRestrictedResources;

    private final List<Application> applications;

    private final List<String> hierarchyRestrictedResources;

    private final String allowedAccessControlHierarchyGroupId;

    private final List<FlowModule> allowedFlowModules;

    private final GranularAccessControlConfiguration granularAccessControlConfiguration;

    private UpdateSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.permissions = builder.permissions;
        this.securityProfileId = builder.securityProfileId;
        this.instanceId = builder.instanceId;
        this.allowedAccessControlTags = builder.allowedAccessControlTags;
        this.tagRestrictedResources = builder.tagRestrictedResources;
        this.applications = builder.applications;
        this.hierarchyRestrictedResources = builder.hierarchyRestrictedResources;
        this.allowedAccessControlHierarchyGroupId = builder.allowedAccessControlHierarchyGroupId;
        this.allowedFlowModules = builder.allowedFlowModules;
        this.granularAccessControlConfiguration = builder.granularAccessControlConfiguration;
    }

    /**
     * <p>
     * The description of the security profile.
     * </p>
     * 
     * @return The description of the security profile.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions granted to a security profile. For a list of valid permissions, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile
     * permissions</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The permissions granted to a security profile. For a list of valid permissions, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security
     *         profile permissions</a>.
     */
    public final List<String> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The identifier for the security profle.
     * </p>
     * 
     * @return The identifier for the security profle.
     */
    public final String securityProfileId() {
        return securityProfileId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAccessControlTags property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedAccessControlTags() {
        return allowedAccessControlTags != null && !(allowedAccessControlTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAccessControlTags} method.
     * </p>
     * 
     * @return The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     */
    public final Map<String, String> allowedAccessControlTags() {
        return allowedAccessControlTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagRestrictedResources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTagRestrictedResources() {
        return tagRestrictedResources != null && !(tagRestrictedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagRestrictedResources} method.
     * </p>
     * 
     * @return The list of resources that a security profile applies tag restrictions to in Amazon Connect.
     */
    public final List<String> tagRestrictedResources() {
        return tagRestrictedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Applications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplications() {
        return applications != null && !(applications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the third-party application's metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplications} method.
     * </p>
     * 
     * @return A list of the third-party application's metadata.
     */
    public final List<Application> applications() {
        return applications;
    }

    /**
     * For responses, this returns true if the service returned a value for the HierarchyRestrictedResources property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHierarchyRestrictedResources() {
        return hierarchyRestrictedResources != null && !(hierarchyRestrictedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following are
     * acceptable ResourceNames: <code>User</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHierarchyRestrictedResources} method.
     * </p>
     * 
     * @return The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
     *         Following are acceptable ResourceNames: <code>User</code>.
     */
    public final List<String> hierarchyRestrictedResources() {
        return hierarchyRestrictedResources;
    }

    /**
     * <p>
     * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon
     * Connect.
     * </p>
     * 
     * @return The identifier of the hierarchy group that a security profile uses to restrict access to resources in
     *         Amazon Connect.
     */
    public final String allowedAccessControlHierarchyGroupId() {
        return allowedAccessControlHierarchyGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedFlowModules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedFlowModules() {
        return allowedFlowModules != null && !(allowedFlowModules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Flow Modules an AI Agent can invoke as a tool
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedFlowModules} method.
     * </p>
     * 
     * @return A list of Flow Modules an AI Agent can invoke as a tool
     */
    public final List<FlowModule> allowedFlowModules() {
        return allowedFlowModules;
    }

    /**
     * <p>
     * The granular access control configuration for the security profile, including data table permissions.
     * </p>
     * 
     * @return The granular access control configuration for the security profile, including data table permissions.
     */
    public final GranularAccessControlConfiguration granularAccessControlConfiguration() {
        return granularAccessControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAccessControlTags() ? allowedAccessControlTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagRestrictedResources() ? tagRestrictedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasApplications() ? applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHierarchyRestrictedResources() ? hierarchyRestrictedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowedAccessControlHierarchyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedFlowModules() ? allowedFlowModules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(granularAccessControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileRequest)) {
            return false;
        }
        UpdateSecurityProfileRequest other = (UpdateSecurityProfileRequest) obj;
        return Objects.equals(description(), other.description()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissions(), other.permissions())
                && Objects.equals(securityProfileId(), other.securityProfileId())
                && Objects.equals(instanceId(), other.instanceId())
                && hasAllowedAccessControlTags() == other.hasAllowedAccessControlTags()
                && Objects.equals(allowedAccessControlTags(), other.allowedAccessControlTags())
                && hasTagRestrictedResources() == other.hasTagRestrictedResources()
                && Objects.equals(tagRestrictedResources(), other.tagRestrictedResources())
                && hasApplications() == other.hasApplications() && Objects.equals(applications(), other.applications())
                && hasHierarchyRestrictedResources() == other.hasHierarchyRestrictedResources()
                && Objects.equals(hierarchyRestrictedResources(), other.hierarchyRestrictedResources())
                && Objects.equals(allowedAccessControlHierarchyGroupId(), other.allowedAccessControlHierarchyGroupId())
                && hasAllowedFlowModules() == other.hasAllowedFlowModules()
                && Objects.equals(allowedFlowModules(), other.allowedFlowModules())
                && Objects.equals(granularAccessControlConfiguration(), other.granularAccessControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecurityProfileRequest").add("Description", description())
                .add("Permissions", hasPermissions() ? permissions() : null).add("SecurityProfileId", securityProfileId())
                .add("InstanceId", instanceId())
                .add("AllowedAccessControlTags", hasAllowedAccessControlTags() ? allowedAccessControlTags() : null)
                .add("TagRestrictedResources", hasTagRestrictedResources() ? tagRestrictedResources() : null)
                .add("Applications", hasApplications() ? applications() : null)
                .add("HierarchyRestrictedResources", hasHierarchyRestrictedResources() ? hierarchyRestrictedResources() : null)
                .add("AllowedAccessControlHierarchyGroupId", allowedAccessControlHierarchyGroupId())
                .add("AllowedFlowModules", hasAllowedFlowModules() ? allowedFlowModules() : null)
                .add("GranularAccessControlConfiguration", granularAccessControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "SecurityProfileId":
            return Optional.ofNullable(clazz.cast(securityProfileId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AllowedAccessControlTags":
            return Optional.ofNullable(clazz.cast(allowedAccessControlTags()));
        case "TagRestrictedResources":
            return Optional.ofNullable(clazz.cast(tagRestrictedResources()));
        case "Applications":
            return Optional.ofNullable(clazz.cast(applications()));
        case "HierarchyRestrictedResources":
            return Optional.ofNullable(clazz.cast(hierarchyRestrictedResources()));
        case "AllowedAccessControlHierarchyGroupId":
            return Optional.ofNullable(clazz.cast(allowedAccessControlHierarchyGroupId()));
        case "AllowedFlowModules":
            return Optional.ofNullable(clazz.cast(allowedFlowModules()));
        case "GranularAccessControlConfiguration":
            return Optional.ofNullable(clazz.cast(granularAccessControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("SecurityProfileId", SECURITY_PROFILE_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AllowedAccessControlTags", ALLOWED_ACCESS_CONTROL_TAGS_FIELD);
        map.put("TagRestrictedResources", TAG_RESTRICTED_RESOURCES_FIELD);
        map.put("Applications", APPLICATIONS_FIELD);
        map.put("HierarchyRestrictedResources", HIERARCHY_RESTRICTED_RESOURCES_FIELD);
        map.put("AllowedAccessControlHierarchyGroupId", ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD);
        map.put("AllowedFlowModules", ALLOWED_FLOW_MODULES_FIELD);
        map.put("GranularAccessControlConfiguration", GRANULAR_ACCESS_CONTROL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityProfileRequest, T> g) {
        return obj -> g.apply((UpdateSecurityProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSecurityProfileRequest> {
        /**
         * <p>
         * The description of the security profile.
         * </p>
         * 
         * @param description
         *        The description of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The permissions granted to a security profile. For a list of valid permissions, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security
         * profile permissions</a>.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to a security profile. For a list of valid permissions, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of
         *        security profile permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<String> permissions);

        /**
         * <p>
         * The permissions granted to a security profile. For a list of valid permissions, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security
         * profile permissions</a>.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to a security profile. For a list of valid permissions, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of
         *        security profile permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(String... permissions);

        /**
         * <p>
         * The identifier for the security profle.
         * </p>
         * 
         * @param securityProfileId
         *        The identifier for the security profle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileId(String securityProfileId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         * </p>
         * 
         * @param allowedAccessControlTags
         *        The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAccessControlTags(Map<String, String> allowedAccessControlTags);

        /**
         * <p>
         * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         * </p>
         * 
         * @param tagRestrictedResources
         *        The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagRestrictedResources(Collection<String> tagRestrictedResources);

        /**
         * <p>
         * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         * </p>
         * 
         * @param tagRestrictedResources
         *        The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagRestrictedResources(String... tagRestrictedResources);

        /**
         * <p>
         * A list of the third-party application's metadata.
         * </p>
         * 
         * @param applications
         *        A list of the third-party application's metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<Application> applications);

        /**
         * <p>
         * A list of the third-party application's metadata.
         * </p>
         * 
         * @param applications
         *        A list of the third-party application's metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Application... applications);

        /**
         * <p>
         * A list of the third-party application's metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.Application.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.Application#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.Application.Builder#build()} is called immediately and
         * its result is passed to {@link #applications(List<Application>)}.
         * 
         * @param applications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.Application.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applications(java.util.Collection<Application>)
         */
        Builder applications(Consumer<Application.Builder>... applications);

        /**
         * <p>
         * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following
         * are acceptable ResourceNames: <code>User</code>.
         * </p>
         * 
         * @param hierarchyRestrictedResources
         *        The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
         *        Following are acceptable ResourceNames: <code>User</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyRestrictedResources(Collection<String> hierarchyRestrictedResources);

        /**
         * <p>
         * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following
         * are acceptable ResourceNames: <code>User</code>.
         * </p>
         * 
         * @param hierarchyRestrictedResources
         *        The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
         *        Following are acceptable ResourceNames: <code>User</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyRestrictedResources(String... hierarchyRestrictedResources);

        /**
         * <p>
         * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon
         * Connect.
         * </p>
         * 
         * @param allowedAccessControlHierarchyGroupId
         *        The identifier of the hierarchy group that a security profile uses to restrict access to resources in
         *        Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAccessControlHierarchyGroupId(String allowedAccessControlHierarchyGroupId);

        /**
         * <p>
         * A list of Flow Modules an AI Agent can invoke as a tool
         * </p>
         * 
         * @param allowedFlowModules
         *        A list of Flow Modules an AI Agent can invoke as a tool
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFlowModules(Collection<FlowModule> allowedFlowModules);

        /**
         * <p>
         * A list of Flow Modules an AI Agent can invoke as a tool
         * </p>
         * 
         * @param allowedFlowModules
         *        A list of Flow Modules an AI Agent can invoke as a tool
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedFlowModules(FlowModule... allowedFlowModules);

        /**
         * <p>
         * A list of Flow Modules an AI Agent can invoke as a tool
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.FlowModule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.FlowModule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.FlowModule.Builder#build()} is called immediately and
         * its result is passed to {@link #allowedFlowModules(List<FlowModule>)}.
         * 
         * @param allowedFlowModules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.FlowModule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedFlowModules(java.util.Collection<FlowModule>)
         */
        Builder allowedFlowModules(Consumer<FlowModule.Builder>... allowedFlowModules);

        /**
         * <p>
         * The granular access control configuration for the security profile, including data table permissions.
         * </p>
         * 
         * @param granularAccessControlConfiguration
         *        The granular access control configuration for the security profile, including data table permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granularAccessControlConfiguration(GranularAccessControlConfiguration granularAccessControlConfiguration);

        /**
         * <p>
         * The granular access control configuration for the security profile, including data table permissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GranularAccessControlConfiguration.Builder} avoiding the need to create one manually via
         * {@link GranularAccessControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GranularAccessControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #granularAccessControlConfiguration(GranularAccessControlConfiguration)}.
         * 
         * @param granularAccessControlConfiguration
         *        a consumer that will call methods on {@link GranularAccessControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #granularAccessControlConfiguration(GranularAccessControlConfiguration)
         */
        default Builder granularAccessControlConfiguration(
                Consumer<GranularAccessControlConfiguration.Builder> granularAccessControlConfiguration) {
            return granularAccessControlConfiguration(GranularAccessControlConfiguration.builder()
                    .applyMutation(granularAccessControlConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String description;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private String securityProfileId;

        private String instanceId;

        private Map<String, String> allowedAccessControlTags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> tagRestrictedResources = DefaultSdkAutoConstructList.getInstance();

        private List<Application> applications = DefaultSdkAutoConstructList.getInstance();

        private List<String> hierarchyRestrictedResources = DefaultSdkAutoConstructList.getInstance();

        private String allowedAccessControlHierarchyGroupId;

        private List<FlowModule> allowedFlowModules = DefaultSdkAutoConstructList.getInstance();

        private GranularAccessControlConfiguration granularAccessControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityProfileRequest model) {
            super(model);
            description(model.description);
            permissions(model.permissions);
            securityProfileId(model.securityProfileId);
            instanceId(model.instanceId);
            allowedAccessControlTags(model.allowedAccessControlTags);
            tagRestrictedResources(model.tagRestrictedResources);
            applications(model.applications);
            hierarchyRestrictedResources(model.hierarchyRestrictedResources);
            allowedAccessControlHierarchyGroupId(model.allowedAccessControlHierarchyGroupId);
            allowedFlowModules(model.allowedFlowModules);
            granularAccessControlConfiguration(model.granularAccessControlConfiguration);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final String getSecurityProfileId() {
            return securityProfileId;
        }

        public final void setSecurityProfileId(String securityProfileId) {
            this.securityProfileId = securityProfileId;
        }

        @Override
        public final Builder securityProfileId(String securityProfileId) {
            this.securityProfileId = securityProfileId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Map<String, String> getAllowedAccessControlTags() {
            if (allowedAccessControlTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return allowedAccessControlTags;
        }

        public final void setAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
            this.allowedAccessControlTags = AllowedAccessControlTagsCopier.copy(allowedAccessControlTags);
        }

        @Override
        public final Builder allowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
            this.allowedAccessControlTags = AllowedAccessControlTagsCopier.copy(allowedAccessControlTags);
            return this;
        }

        public final Collection<String> getTagRestrictedResources() {
            if (tagRestrictedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return tagRestrictedResources;
        }

        public final void setTagRestrictedResources(Collection<String> tagRestrictedResources) {
            this.tagRestrictedResources = TagRestrictedResourceListCopier.copy(tagRestrictedResources);
        }

        @Override
        public final Builder tagRestrictedResources(Collection<String> tagRestrictedResources) {
            this.tagRestrictedResources = TagRestrictedResourceListCopier.copy(tagRestrictedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagRestrictedResources(String... tagRestrictedResources) {
            tagRestrictedResources(Arrays.asList(tagRestrictedResources));
            return this;
        }

        public final List<Application.Builder> getApplications() {
            List<Application.Builder> result = ApplicationsCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationsCopier.copyFromBuilder(applications);
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<Application.Builder>... applications) {
            applications(Stream.of(applications).map(c -> Application.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getHierarchyRestrictedResources() {
            if (hierarchyRestrictedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return hierarchyRestrictedResources;
        }

        public final void setHierarchyRestrictedResources(Collection<String> hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources = HierarchyRestrictedResourceListCopier.copy(hierarchyRestrictedResources);
        }

        @Override
        public final Builder hierarchyRestrictedResources(Collection<String> hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources = HierarchyRestrictedResourceListCopier.copy(hierarchyRestrictedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchyRestrictedResources(String... hierarchyRestrictedResources) {
            hierarchyRestrictedResources(Arrays.asList(hierarchyRestrictedResources));
            return this;
        }

        public final String getAllowedAccessControlHierarchyGroupId() {
            return allowedAccessControlHierarchyGroupId;
        }

        public final void setAllowedAccessControlHierarchyGroupId(String allowedAccessControlHierarchyGroupId) {
            this.allowedAccessControlHierarchyGroupId = allowedAccessControlHierarchyGroupId;
        }

        @Override
        public final Builder allowedAccessControlHierarchyGroupId(String allowedAccessControlHierarchyGroupId) {
            this.allowedAccessControlHierarchyGroupId = allowedAccessControlHierarchyGroupId;
            return this;
        }

        public final List<FlowModule.Builder> getAllowedFlowModules() {
            List<FlowModule.Builder> result = AllowedFlowModulesCopier.copyToBuilder(this.allowedFlowModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedFlowModules(Collection<FlowModule.BuilderImpl> allowedFlowModules) {
            this.allowedFlowModules = AllowedFlowModulesCopier.copyFromBuilder(allowedFlowModules);
        }

        @Override
        public final Builder allowedFlowModules(Collection<FlowModule> allowedFlowModules) {
            this.allowedFlowModules = AllowedFlowModulesCopier.copy(allowedFlowModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFlowModules(FlowModule... allowedFlowModules) {
            allowedFlowModules(Arrays.asList(allowedFlowModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFlowModules(Consumer<FlowModule.Builder>... allowedFlowModules) {
            allowedFlowModules(Stream.of(allowedFlowModules).map(c -> FlowModule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final GranularAccessControlConfiguration.Builder getGranularAccessControlConfiguration() {
            return granularAccessControlConfiguration != null ? granularAccessControlConfiguration.toBuilder() : null;
        }

        public final void setGranularAccessControlConfiguration(
                GranularAccessControlConfiguration.BuilderImpl granularAccessControlConfiguration) {
            this.granularAccessControlConfiguration = granularAccessControlConfiguration != null ? granularAccessControlConfiguration
                    .build() : null;
        }

        @Override
        public final Builder granularAccessControlConfiguration(
                GranularAccessControlConfiguration granularAccessControlConfiguration) {
            this.granularAccessControlConfiguration = granularAccessControlConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityProfileRequest build() {
            return new UpdateSecurityProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
