/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactEvaluationResponse extends ConnectResponse implements
        ToCopyableBuilder<UpdateContactEvaluationResponse.Builder, UpdateContactEvaluationResponse> {
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationId").getter(getter(UpdateContactEvaluationResponse::evaluationId))
            .setter(setter(Builder::evaluationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationId").build()).build();

    private static final SdkField<String> EVALUATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationArn").getter(getter(UpdateContactEvaluationResponse::evaluationArn))
            .setter(setter(Builder::evaluationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ID_FIELD,
            EVALUATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String evaluationId;

    private final String evaluationArn;

    private UpdateContactEvaluationResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationId = builder.evaluationId;
        this.evaluationArn = builder.evaluationArn;
    }

    /**
     * <p>
     * A unique identifier for the contact evaluation.
     * </p>
     * 
     * @return A unique identifier for the contact evaluation.
     */
    public final String evaluationId() {
        return evaluationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the contact evaluation resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the contact evaluation resource.
     */
    public final String evaluationArn() {
        return evaluationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactEvaluationResponse)) {
            return false;
        }
        UpdateContactEvaluationResponse other = (UpdateContactEvaluationResponse) obj;
        return Objects.equals(evaluationId(), other.evaluationId()) && Objects.equals(evaluationArn(), other.evaluationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContactEvaluationResponse").add("EvaluationId", evaluationId())
                .add("EvaluationArn", evaluationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.ofNullable(clazz.cast(evaluationId()));
        case "EvaluationArn":
            return Optional.ofNullable(clazz.cast(evaluationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EvaluationId", EVALUATION_ID_FIELD);
        map.put("EvaluationArn", EVALUATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactEvaluationResponse, T> g) {
        return obj -> g.apply((UpdateContactEvaluationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContactEvaluationResponse> {
        /**
         * <p>
         * A unique identifier for the contact evaluation.
         * </p>
         * 
         * @param evaluationId
         *        A unique identifier for the contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the contact evaluation resource.
         * </p>
         * 
         * @param evaluationArn
         *        The Amazon Resource Name (ARN) for the contact evaluation resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationArn(String evaluationArn);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String evaluationId;

        private String evaluationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactEvaluationResponse model) {
            super(model);
            evaluationId(model.evaluationId);
            evaluationArn(model.evaluationArn);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final String getEvaluationArn() {
            return evaluationArn;
        }

        public final void setEvaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
        }

        @Override
        public final Builder evaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
            return this;
        }

        @Override
        public UpdateContactEvaluationResponse build() {
            return new UpdateContactEvaluationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
