/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartContactStreamingRequest extends ConnectRequest implements
        ToCopyableBuilder<StartContactStreamingRequest.Builder, StartContactStreamingRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StartContactStreamingRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(StartContactStreamingRequest::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<ChatStreamingConfiguration> CHAT_STREAMING_CONFIGURATION_FIELD = SdkField
            .<ChatStreamingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ChatStreamingConfiguration")
            .getter(getter(StartContactStreamingRequest::chatStreamingConfiguration))
            .setter(setter(Builder::chatStreamingConfiguration))
            .constructor(ChatStreamingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatStreamingConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartContactStreamingRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_ID_FIELD, CHAT_STREAMING_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String contactId;

    private final ChatStreamingConfiguration chatStreamingConfiguration;

    private final String clientToken;

    private StartContactStreamingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.chatStreamingConfiguration = builder.chatStreamingConfiguration;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the contact. This is the identifier of the contact associated with the first interaction with
     * the contact center.
     * </p>
     * 
     * @return The identifier of the contact. This is the identifier of the contact associated with the first
     *         interaction with the contact center.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The streaming configuration, such as the Amazon SNS streaming endpoint.
     * </p>
     * 
     * @return The streaming configuration, such as the Amazon SNS streaming endpoint.
     */
    public final ChatStreamingConfiguration chatStreamingConfiguration() {
        return chatStreamingConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(chatStreamingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContactStreamingRequest)) {
            return false;
        }
        StartContactStreamingRequest other = (StartContactStreamingRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(contactId(), other.contactId())
                && Objects.equals(chatStreamingConfiguration(), other.chatStreamingConfiguration())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartContactStreamingRequest").add("InstanceId", instanceId()).add("ContactId", contactId())
                .add("ChatStreamingConfiguration", chatStreamingConfiguration()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "ChatStreamingConfiguration":
            return Optional.ofNullable(clazz.cast(chatStreamingConfiguration()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("ChatStreamingConfiguration", CHAT_STREAMING_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartContactStreamingRequest, T> g) {
        return obj -> g.apply((StartContactStreamingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartContactStreamingRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the contact. This is the identifier of the contact associated with the first interaction
         * with the contact center.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact. This is the identifier of the contact associated with the first
         *        interaction with the contact center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The streaming configuration, such as the Amazon SNS streaming endpoint.
         * </p>
         * 
         * @param chatStreamingConfiguration
         *        The streaming configuration, such as the Amazon SNS streaming endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatStreamingConfiguration(ChatStreamingConfiguration chatStreamingConfiguration);

        /**
         * <p>
         * The streaming configuration, such as the Amazon SNS streaming endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChatStreamingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ChatStreamingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatStreamingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #chatStreamingConfiguration(ChatStreamingConfiguration)}.
         * 
         * @param chatStreamingConfiguration
         *        a consumer that will call methods on {@link ChatStreamingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chatStreamingConfiguration(ChatStreamingConfiguration)
         */
        default Builder chatStreamingConfiguration(Consumer<ChatStreamingConfiguration.Builder> chatStreamingConfiguration) {
            return chatStreamingConfiguration(ChatStreamingConfiguration.builder().applyMutation(chatStreamingConfiguration)
                    .build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactId;

        private ChatStreamingConfiguration chatStreamingConfiguration;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartContactStreamingRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactId(model.contactId);
            chatStreamingConfiguration(model.chatStreamingConfiguration);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final ChatStreamingConfiguration.Builder getChatStreamingConfiguration() {
            return chatStreamingConfiguration != null ? chatStreamingConfiguration.toBuilder() : null;
        }

        public final void setChatStreamingConfiguration(ChatStreamingConfiguration.BuilderImpl chatStreamingConfiguration) {
            this.chatStreamingConfiguration = chatStreamingConfiguration != null ? chatStreamingConfiguration.build() : null;
        }

        @Override
        public final Builder chatStreamingConfiguration(ChatStreamingConfiguration chatStreamingConfiguration) {
            this.chatStreamingConfiguration = chatStreamingConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartContactStreamingRequest build() {
            return new StartContactStreamingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
