/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendOutboundEmailRequest extends ConnectRequest implements
        ToCopyableBuilder<SendOutboundEmailRequest.Builder, SendOutboundEmailRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SendOutboundEmailRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<EmailAddressInfo> FROM_EMAIL_ADDRESS_FIELD = SdkField
            .<EmailAddressInfo> builder(MarshallingType.SDK_POJO).memberName("FromEmailAddress")
            .getter(getter(SendOutboundEmailRequest::fromEmailAddress)).setter(setter(Builder::fromEmailAddress))
            .constructor(EmailAddressInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()).build();

    private static final SdkField<EmailAddressInfo> DESTINATION_EMAIL_ADDRESS_FIELD = SdkField
            .<EmailAddressInfo> builder(MarshallingType.SDK_POJO).memberName("DestinationEmailAddress")
            .getter(getter(SendOutboundEmailRequest::destinationEmailAddress)).setter(setter(Builder::destinationEmailAddress))
            .constructor(EmailAddressInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEmailAddress").build())
            .build();

    private static final SdkField<OutboundAdditionalRecipients> ADDITIONAL_RECIPIENTS_FIELD = SdkField
            .<OutboundAdditionalRecipients> builder(MarshallingType.SDK_POJO).memberName("AdditionalRecipients")
            .getter(getter(SendOutboundEmailRequest::additionalRecipients)).setter(setter(Builder::additionalRecipients))
            .constructor(OutboundAdditionalRecipients::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRecipients").build())
            .build();

    private static final SdkField<OutboundEmailContent> EMAIL_MESSAGE_FIELD = SdkField
            .<OutboundEmailContent> builder(MarshallingType.SDK_POJO).memberName("EmailMessage")
            .getter(getter(SendOutboundEmailRequest::emailMessage)).setter(setter(Builder::emailMessage))
            .constructor(OutboundEmailContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()).build();

    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficType").getter(getter(SendOutboundEmailRequest::trafficTypeAsString))
            .setter(setter(Builder::trafficType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType").build()).build();

    private static final SdkField<SourceCampaign> SOURCE_CAMPAIGN_FIELD = SdkField
            .<SourceCampaign> builder(MarshallingType.SDK_POJO).memberName("SourceCampaign")
            .getter(getter(SendOutboundEmailRequest::sourceCampaign)).setter(setter(Builder::sourceCampaign))
            .constructor(SourceCampaign::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCampaign").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(SendOutboundEmailRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            FROM_EMAIL_ADDRESS_FIELD, DESTINATION_EMAIL_ADDRESS_FIELD, ADDITIONAL_RECIPIENTS_FIELD, EMAIL_MESSAGE_FIELD,
            TRAFFIC_TYPE_FIELD, SOURCE_CAMPAIGN_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final EmailAddressInfo fromEmailAddress;

    private final EmailAddressInfo destinationEmailAddress;

    private final OutboundAdditionalRecipients additionalRecipients;

    private final OutboundEmailContent emailMessage;

    private final String trafficType;

    private final SourceCampaign sourceCampaign;

    private final String clientToken;

    private SendOutboundEmailRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.destinationEmailAddress = builder.destinationEmailAddress;
        this.additionalRecipients = builder.additionalRecipients;
        this.emailMessage = builder.emailMessage;
        this.trafficType = builder.trafficType;
        this.sourceCampaign = builder.sourceCampaign;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The email address to be used for sending email.
     * </p>
     * 
     * @return The email address to be used for sending email.
     */
    public final EmailAddressInfo fromEmailAddress() {
        return fromEmailAddress;
    }

    /**
     * <p>
     * The email address to send the email to.
     * </p>
     * 
     * @return The email address to send the email to.
     */
    public final EmailAddressInfo destinationEmailAddress() {
        return destinationEmailAddress;
    }

    /**
     * <p>
     * The additional recipients address of the email in CC.
     * </p>
     * 
     * @return The additional recipients address of the email in CC.
     */
    public final OutboundAdditionalRecipients additionalRecipients() {
        return additionalRecipients;
    }

    /**
     * <p>
     * The email message body to be sent to the newly created email.
     * </p>
     * 
     * @return The email message body to be sent to the newly created email.
     */
    public final OutboundEmailContent emailMessage() {
        return emailMessage;
    }

    /**
     * <p>
     * Denotes the class of traffic.
     * </p>
     * <note>
     * <p>
     * Only the CAMPAIGN traffic type is supported.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeAsString}.
     * </p>
     * 
     * @return Denotes the class of traffic.</p> <note>
     *         <p>
     *         Only the CAMPAIGN traffic type is supported.
     *         </p>
     * @see TrafficType
     */
    public final TrafficType trafficType() {
        return TrafficType.fromValue(trafficType);
    }

    /**
     * <p>
     * Denotes the class of traffic.
     * </p>
     * <note>
     * <p>
     * Only the CAMPAIGN traffic type is supported.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeAsString}.
     * </p>
     * 
     * @return Denotes the class of traffic.</p> <note>
     *         <p>
     *         Only the CAMPAIGN traffic type is supported.
     *         </p>
     * @see TrafficType
     */
    public final String trafficTypeAsString() {
        return trafficType;
    }

    /**
     * <p>
     * A Campaign object need for Campaign traffic type.
     * </p>
     * 
     * @return A Campaign object need for Campaign traffic type.
     */
    public final SourceCampaign sourceCampaign() {
        return sourceCampaign;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(destinationEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(additionalRecipients());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(trafficTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCampaign());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendOutboundEmailRequest)) {
            return false;
        }
        SendOutboundEmailRequest other = (SendOutboundEmailRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(fromEmailAddress(), other.fromEmailAddress())
                && Objects.equals(destinationEmailAddress(), other.destinationEmailAddress())
                && Objects.equals(additionalRecipients(), other.additionalRecipients())
                && Objects.equals(emailMessage(), other.emailMessage())
                && Objects.equals(trafficTypeAsString(), other.trafficTypeAsString())
                && Objects.equals(sourceCampaign(), other.sourceCampaign()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendOutboundEmailRequest").add("InstanceId", instanceId())
                .add("FromEmailAddress", fromEmailAddress()).add("DestinationEmailAddress", destinationEmailAddress())
                .add("AdditionalRecipients", additionalRecipients()).add("EmailMessage", emailMessage())
                .add("TrafficType", trafficTypeAsString()).add("SourceCampaign", sourceCampaign())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "FromEmailAddress":
            return Optional.ofNullable(clazz.cast(fromEmailAddress()));
        case "DestinationEmailAddress":
            return Optional.ofNullable(clazz.cast(destinationEmailAddress()));
        case "AdditionalRecipients":
            return Optional.ofNullable(clazz.cast(additionalRecipients()));
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        case "TrafficType":
            return Optional.ofNullable(clazz.cast(trafficTypeAsString()));
        case "SourceCampaign":
            return Optional.ofNullable(clazz.cast(sourceCampaign()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
        map.put("DestinationEmailAddress", DESTINATION_EMAIL_ADDRESS_FIELD);
        map.put("AdditionalRecipients", ADDITIONAL_RECIPIENTS_FIELD);
        map.put("EmailMessage", EMAIL_MESSAGE_FIELD);
        map.put("TrafficType", TRAFFIC_TYPE_FIELD);
        map.put("SourceCampaign", SOURCE_CAMPAIGN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendOutboundEmailRequest, T> g) {
        return obj -> g.apply((SendOutboundEmailRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendOutboundEmailRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The email address to be used for sending email.
         * </p>
         * 
         * @param fromEmailAddress
         *        The email address to be used for sending email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromEmailAddress(EmailAddressInfo fromEmailAddress);

        /**
         * <p>
         * The email address to be used for sending email.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailAddressInfo.Builder} avoiding the
         * need to create one manually via {@link EmailAddressInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailAddressInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #fromEmailAddress(EmailAddressInfo)}.
         * 
         * @param fromEmailAddress
         *        a consumer that will call methods on {@link EmailAddressInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fromEmailAddress(EmailAddressInfo)
         */
        default Builder fromEmailAddress(Consumer<EmailAddressInfo.Builder> fromEmailAddress) {
            return fromEmailAddress(EmailAddressInfo.builder().applyMutation(fromEmailAddress).build());
        }

        /**
         * <p>
         * The email address to send the email to.
         * </p>
         * 
         * @param destinationEmailAddress
         *        The email address to send the email to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationEmailAddress(EmailAddressInfo destinationEmailAddress);

        /**
         * <p>
         * The email address to send the email to.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailAddressInfo.Builder} avoiding the
         * need to create one manually via {@link EmailAddressInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailAddressInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationEmailAddress(EmailAddressInfo)}.
         * 
         * @param destinationEmailAddress
         *        a consumer that will call methods on {@link EmailAddressInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationEmailAddress(EmailAddressInfo)
         */
        default Builder destinationEmailAddress(Consumer<EmailAddressInfo.Builder> destinationEmailAddress) {
            return destinationEmailAddress(EmailAddressInfo.builder().applyMutation(destinationEmailAddress).build());
        }

        /**
         * <p>
         * The additional recipients address of the email in CC.
         * </p>
         * 
         * @param additionalRecipients
         *        The additional recipients address of the email in CC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalRecipients(OutboundAdditionalRecipients additionalRecipients);

        /**
         * <p>
         * The additional recipients address of the email in CC.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutboundAdditionalRecipients.Builder}
         * avoiding the need to create one manually via {@link OutboundAdditionalRecipients#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundAdditionalRecipients.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalRecipients(OutboundAdditionalRecipients)}.
         * 
         * @param additionalRecipients
         *        a consumer that will call methods on {@link OutboundAdditionalRecipients.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalRecipients(OutboundAdditionalRecipients)
         */
        default Builder additionalRecipients(Consumer<OutboundAdditionalRecipients.Builder> additionalRecipients) {
            return additionalRecipients(OutboundAdditionalRecipients.builder().applyMutation(additionalRecipients).build());
        }

        /**
         * <p>
         * The email message body to be sent to the newly created email.
         * </p>
         * 
         * @param emailMessage
         *        The email message body to be sent to the newly created email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(OutboundEmailContent emailMessage);

        /**
         * <p>
         * The email message body to be sent to the newly created email.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutboundEmailContent.Builder} avoiding
         * the need to create one manually via {@link OutboundEmailContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundEmailContent.Builder#build()} is called immediately and
         * its result is passed to {@link #emailMessage(OutboundEmailContent)}.
         * 
         * @param emailMessage
         *        a consumer that will call methods on {@link OutboundEmailContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailMessage(OutboundEmailContent)
         */
        default Builder emailMessage(Consumer<OutboundEmailContent.Builder> emailMessage) {
            return emailMessage(OutboundEmailContent.builder().applyMutation(emailMessage).build());
        }

        /**
         * <p>
         * Denotes the class of traffic.
         * </p>
         * <note>
         * <p>
         * Only the CAMPAIGN traffic type is supported.
         * </p>
         * </note>
         * 
         * @param trafficType
         *        Denotes the class of traffic.</p> <note>
         *        <p>
         *        Only the CAMPAIGN traffic type is supported.
         *        </p>
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(String trafficType);

        /**
         * <p>
         * Denotes the class of traffic.
         * </p>
         * <note>
         * <p>
         * Only the CAMPAIGN traffic type is supported.
         * </p>
         * </note>
         * 
         * @param trafficType
         *        Denotes the class of traffic.</p> <note>
         *        <p>
         *        Only the CAMPAIGN traffic type is supported.
         *        </p>
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(TrafficType trafficType);

        /**
         * <p>
         * A Campaign object need for Campaign traffic type.
         * </p>
         * 
         * @param sourceCampaign
         *        A Campaign object need for Campaign traffic type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCampaign(SourceCampaign sourceCampaign);

        /**
         * <p>
         * A Campaign object need for Campaign traffic type.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceCampaign.Builder} avoiding the need
         * to create one manually via {@link SourceCampaign#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceCampaign.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceCampaign(SourceCampaign)}.
         * 
         * @param sourceCampaign
         *        a consumer that will call methods on {@link SourceCampaign.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceCampaign(SourceCampaign)
         */
        default Builder sourceCampaign(Consumer<SourceCampaign.Builder> sourceCampaign) {
            return sourceCampaign(SourceCampaign.builder().applyMutation(sourceCampaign).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private EmailAddressInfo fromEmailAddress;

        private EmailAddressInfo destinationEmailAddress;

        private OutboundAdditionalRecipients additionalRecipients;

        private OutboundEmailContent emailMessage;

        private String trafficType;

        private SourceCampaign sourceCampaign;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendOutboundEmailRequest model) {
            super(model);
            instanceId(model.instanceId);
            fromEmailAddress(model.fromEmailAddress);
            destinationEmailAddress(model.destinationEmailAddress);
            additionalRecipients(model.additionalRecipients);
            emailMessage(model.emailMessage);
            trafficType(model.trafficType);
            sourceCampaign(model.sourceCampaign);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final EmailAddressInfo.Builder getFromEmailAddress() {
            return fromEmailAddress != null ? fromEmailAddress.toBuilder() : null;
        }

        public final void setFromEmailAddress(EmailAddressInfo.BuilderImpl fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress != null ? fromEmailAddress.build() : null;
        }

        @Override
        public final Builder fromEmailAddress(EmailAddressInfo fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final EmailAddressInfo.Builder getDestinationEmailAddress() {
            return destinationEmailAddress != null ? destinationEmailAddress.toBuilder() : null;
        }

        public final void setDestinationEmailAddress(EmailAddressInfo.BuilderImpl destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress != null ? destinationEmailAddress.build() : null;
        }

        @Override
        public final Builder destinationEmailAddress(EmailAddressInfo destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress;
            return this;
        }

        public final OutboundAdditionalRecipients.Builder getAdditionalRecipients() {
            return additionalRecipients != null ? additionalRecipients.toBuilder() : null;
        }

        public final void setAdditionalRecipients(OutboundAdditionalRecipients.BuilderImpl additionalRecipients) {
            this.additionalRecipients = additionalRecipients != null ? additionalRecipients.build() : null;
        }

        @Override
        public final Builder additionalRecipients(OutboundAdditionalRecipients additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        public final OutboundEmailContent.Builder getEmailMessage() {
            return emailMessage != null ? emailMessage.toBuilder() : null;
        }

        public final void setEmailMessage(OutboundEmailContent.BuilderImpl emailMessage) {
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
        }

        @Override
        public final Builder emailMessage(OutboundEmailContent emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final String getTrafficType() {
            return trafficType;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType == null ? null : trafficType.toString());
            return this;
        }

        public final SourceCampaign.Builder getSourceCampaign() {
            return sourceCampaign != null ? sourceCampaign.toBuilder() : null;
        }

        public final void setSourceCampaign(SourceCampaign.BuilderImpl sourceCampaign) {
            this.sourceCampaign = sourceCampaign != null ? sourceCampaign.build() : null;
        }

        @Override
        public final Builder sourceCampaign(SourceCampaign sourceCampaign) {
            this.sourceCampaign = sourceCampaign;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendOutboundEmailRequest build() {
            return new SendOutboundEmailRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
