/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a reference. <code>ReferenceSummary</code> contains only one non null field
 * between the URL and attachment based on the reference type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceSummary.Builder, ReferenceSummary> {
    private static final SdkField<UrlReference> URL_FIELD = SdkField.<UrlReference> builder(MarshallingType.SDK_POJO)
            .memberName("Url").getter(getter(ReferenceSummary::url)).setter(setter(Builder::url))
            .constructor(UrlReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<AttachmentReference> ATTACHMENT_FIELD = SdkField
            .<AttachmentReference> builder(MarshallingType.SDK_POJO).memberName("Attachment")
            .getter(getter(ReferenceSummary::attachment)).setter(setter(Builder::attachment))
            .constructor(AttachmentReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()).build();

    private static final SdkField<EmailMessageReference> EMAIL_MESSAGE_FIELD = SdkField
            .<EmailMessageReference> builder(MarshallingType.SDK_POJO).memberName("EmailMessage")
            .getter(getter(ReferenceSummary::emailMessage)).setter(setter(Builder::emailMessage))
            .constructor(EmailMessageReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()).build();

    private static final SdkField<EmailMessageReference> EMAIL_MESSAGE_PLAIN_TEXT_FIELD = SdkField
            .<EmailMessageReference> builder(MarshallingType.SDK_POJO).memberName("EmailMessagePlainText")
            .getter(getter(ReferenceSummary::emailMessagePlainText)).setter(setter(Builder::emailMessagePlainText))
            .constructor(EmailMessageReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessagePlainText").build())
            .build();

    private static final SdkField<StringReference> STRING_FIELD = SdkField.<StringReference> builder(MarshallingType.SDK_POJO)
            .memberName("String").getter(getter(ReferenceSummary::string)).setter(setter(Builder::string))
            .constructor(StringReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("String").build()).build();

    private static final SdkField<NumberReference> NUMBER_FIELD = SdkField.<NumberReference> builder(MarshallingType.SDK_POJO)
            .memberName("Number").getter(getter(ReferenceSummary::number)).setter(setter(Builder::number))
            .constructor(NumberReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Number").build()).build();

    private static final SdkField<DateReference> DATE_FIELD = SdkField.<DateReference> builder(MarshallingType.SDK_POJO)
            .memberName("Date").getter(getter(ReferenceSummary::date)).setter(setter(Builder::date))
            .constructor(DateReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()).build();

    private static final SdkField<EmailReference> EMAIL_FIELD = SdkField.<EmailReference> builder(MarshallingType.SDK_POJO)
            .memberName("Email").getter(getter(ReferenceSummary::email)).setter(setter(Builder::email))
            .constructor(EmailReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, ATTACHMENT_FIELD,
            EMAIL_MESSAGE_FIELD, EMAIL_MESSAGE_PLAIN_TEXT_FIELD, STRING_FIELD, NUMBER_FIELD, DATE_FIELD, EMAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UrlReference url;

    private final AttachmentReference attachment;

    private final EmailMessageReference emailMessage;

    private final EmailMessageReference emailMessagePlainText;

    private final StringReference string;

    private final NumberReference number;

    private final DateReference date;

    private final EmailReference email;

    private final Type type;

    private ReferenceSummary(BuilderImpl builder) {
        this.url = builder.url;
        this.attachment = builder.attachment;
        this.emailMessage = builder.emailMessage;
        this.emailMessagePlainText = builder.emailMessagePlainText;
        this.string = builder.string;
        this.number = builder.number;
        this.date = builder.date;
        this.email = builder.email;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
     * </p>
     * 
     * @return Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
     */
    public final UrlReference url() {
        return url;
    }

    /**
     * <p>
     * Information about the reference when the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise, null.
     * </p>
     * 
     * @return Information about the reference when the <code>referenceType</code> is <code>ATTACHMENT</code>.
     *         Otherwise, null.
     */
    public final AttachmentReference attachment() {
        return attachment;
    }

    /**
     * <p>
     * Information about the reference when the referenceType is <code>EMAIL_MESSAGE</code>. Otherwise, null.
     * </p>
     * 
     * @return Information about the reference when the referenceType is <code>EMAIL_MESSAGE</code>. Otherwise, null.
     */
    public final EmailMessageReference emailMessage() {
        return emailMessage;
    }

    /**
     * Returns the value of the EmailMessagePlainText property for this object.
     * 
     * @return The value of the EmailMessagePlainText property for this object.
     */
    public final EmailMessageReference emailMessagePlainText() {
        return emailMessagePlainText;
    }

    /**
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise, null.
     * </p>
     * 
     * @return Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise,
     *         null.
     */
    public final StringReference string() {
        return string;
    }

    /**
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise, null.
     * </p>
     * 
     * @return Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise,
     *         null.
     */
    public final NumberReference number() {
        return number;
    }

    /**
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise, null.
     * </p>
     * 
     * @return Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise, null.
     */
    public final DateReference date() {
        return date;
    }

    /**
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise, null.
     * </p>
     * 
     * @return Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise, null.
     */
    public final EmailReference email() {
        return email;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessagePlainText());
        hashCode = 31 * hashCode + Objects.hashCode(string());
        hashCode = 31 * hashCode + Objects.hashCode(number());
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceSummary)) {
            return false;
        }
        ReferenceSummary other = (ReferenceSummary) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(attachment(), other.attachment())
                && Objects.equals(emailMessage(), other.emailMessage())
                && Objects.equals(emailMessagePlainText(), other.emailMessagePlainText())
                && Objects.equals(string(), other.string()) && Objects.equals(number(), other.number())
                && Objects.equals(date(), other.date()) && Objects.equals(email(), other.email());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceSummary").add("Url", url()).add("Attachment", attachment())
                .add("EmailMessage", emailMessage()).add("EmailMessagePlainText", emailMessagePlainText())
                .add("String", string()).add("Number", number()).add("Date", date()).add("Email", email()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        case "EmailMessagePlainText":
            return Optional.ofNullable(clazz.cast(emailMessagePlainText()));
        case "String":
            return Optional.ofNullable(clazz.cast(string()));
        case "Number":
            return Optional.ofNullable(clazz.cast(number()));
        case "Date":
            return Optional.ofNullable(clazz.cast(date()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #url()} initialized to the given value.
     *
     * <p>
     * Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
     * </p>
     * 
     * @param url
     *        Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
     */
    public static ReferenceSummary fromUrl(UrlReference url) {
        return builder().url(url).build();
    }

    /**
     * Create an instance of this class with {@link #url()} initialized to the given value.
     *
     * <p>
     * Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
     * </p>
     * 
     * @param url
     *        Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
     */
    public static ReferenceSummary fromUrl(Consumer<UrlReference.Builder> url) {
        UrlReference.Builder builder = UrlReference.builder();
        url.accept(builder);
        return fromUrl(builder.build());
    }

    /**
     * Create an instance of this class with {@link #attachment()} initialized to the given value.
     *
     * <p>
     * Information about the reference when the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise, null.
     * </p>
     * 
     * @param attachment
     *        Information about the reference when the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise,
     *        null.
     */
    public static ReferenceSummary fromAttachment(AttachmentReference attachment) {
        return builder().attachment(attachment).build();
    }

    /**
     * Create an instance of this class with {@link #attachment()} initialized to the given value.
     *
     * <p>
     * Information about the reference when the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise, null.
     * </p>
     * 
     * @param attachment
     *        Information about the reference when the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise,
     *        null.
     */
    public static ReferenceSummary fromAttachment(Consumer<AttachmentReference.Builder> attachment) {
        AttachmentReference.Builder builder = AttachmentReference.builder();
        attachment.accept(builder);
        return fromAttachment(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emailMessage()} initialized to the given value.
     *
     * <p>
     * Information about the reference when the referenceType is <code>EMAIL_MESSAGE</code>. Otherwise, null.
     * </p>
     * 
     * @param emailMessage
     *        Information about the reference when the referenceType is <code>EMAIL_MESSAGE</code>. Otherwise, null.
     */
    public static ReferenceSummary fromEmailMessage(EmailMessageReference emailMessage) {
        return builder().emailMessage(emailMessage).build();
    }

    /**
     * Create an instance of this class with {@link #emailMessage()} initialized to the given value.
     *
     * <p>
     * Information about the reference when the referenceType is <code>EMAIL_MESSAGE</code>. Otherwise, null.
     * </p>
     * 
     * @param emailMessage
     *        Information about the reference when the referenceType is <code>EMAIL_MESSAGE</code>. Otherwise, null.
     */
    public static ReferenceSummary fromEmailMessage(Consumer<EmailMessageReference.Builder> emailMessage) {
        EmailMessageReference.Builder builder = EmailMessageReference.builder();
        emailMessage.accept(builder);
        return fromEmailMessage(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emailMessagePlainText()} initialized to the given value.
     *
     * Sets the value of the EmailMessagePlainText property for this object.
     *
     * @param emailMessagePlainText
     *        The new value for the EmailMessagePlainText property for this object.
     */
    public static ReferenceSummary fromEmailMessagePlainText(EmailMessageReference emailMessagePlainText) {
        return builder().emailMessagePlainText(emailMessagePlainText).build();
    }

    /**
     * Create an instance of this class with {@link #emailMessagePlainText()} initialized to the given value.
     *
     * Sets the value of the EmailMessagePlainText property for this object.
     *
     * @param emailMessagePlainText
     *        The new value for the EmailMessagePlainText property for this object.
     */
    public static ReferenceSummary fromEmailMessagePlainText(Consumer<EmailMessageReference.Builder> emailMessagePlainText) {
        EmailMessageReference.Builder builder = EmailMessageReference.builder();
        emailMessagePlainText.accept(builder);
        return fromEmailMessagePlainText(builder.build());
    }

    /**
     * Create an instance of this class with {@link #string()} initialized to the given value.
     *
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise, null.
     * </p>
     * 
     * @param string
     *        Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise, null.
     */
    public static ReferenceSummary fromString(StringReference string) {
        return builder().string(string).build();
    }

    /**
     * Create an instance of this class with {@link #string()} initialized to the given value.
     *
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise, null.
     * </p>
     * 
     * @param string
     *        Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise, null.
     */
    public static ReferenceSummary fromString(Consumer<StringReference.Builder> string) {
        StringReference.Builder builder = StringReference.builder();
        string.accept(builder);
        return fromString(builder.build());
    }

    /**
     * Create an instance of this class with {@link #number()} initialized to the given value.
     *
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise, null.
     * </p>
     * 
     * @param number
     *        Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise, null.
     */
    public static ReferenceSummary fromNumber(NumberReference number) {
        return builder().number(number).build();
    }

    /**
     * Create an instance of this class with {@link #number()} initialized to the given value.
     *
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise, null.
     * </p>
     * 
     * @param number
     *        Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise, null.
     */
    public static ReferenceSummary fromNumber(Consumer<NumberReference.Builder> number) {
        NumberReference.Builder builder = NumberReference.builder();
        number.accept(builder);
        return fromNumber(builder.build());
    }

    /**
     * Create an instance of this class with {@link #date()} initialized to the given value.
     *
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise, null.
     * </p>
     * 
     * @param date
     *        Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise, null.
     */
    public static ReferenceSummary fromDate(DateReference date) {
        return builder().date(date).build();
    }

    /**
     * Create an instance of this class with {@link #date()} initialized to the given value.
     *
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise, null.
     * </p>
     * 
     * @param date
     *        Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise, null.
     */
    public static ReferenceSummary fromDate(Consumer<DateReference.Builder> date) {
        DateReference.Builder builder = DateReference.builder();
        date.accept(builder);
        return fromDate(builder.build());
    }

    /**
     * Create an instance of this class with {@link #email()} initialized to the given value.
     *
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise, null.
     * </p>
     * 
     * @param email
     *        Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise, null.
     */
    public static ReferenceSummary fromEmail(EmailReference email) {
        return builder().email(email).build();
    }

    /**
     * Create an instance of this class with {@link #email()} initialized to the given value.
     *
     * <p>
     * Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise, null.
     * </p>
     * 
     * @param email
     *        Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise, null.
     */
    public static ReferenceSummary fromEmail(Consumer<EmailReference.Builder> email) {
        EmailReference.Builder builder = EmailReference.builder();
        email.accept(builder);
        return fromEmail(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Url", URL_FIELD);
        map.put("Attachment", ATTACHMENT_FIELD);
        map.put("EmailMessage", EMAIL_MESSAGE_FIELD);
        map.put("EmailMessagePlainText", EMAIL_MESSAGE_PLAIN_TEXT_FIELD);
        map.put("String", STRING_FIELD);
        map.put("Number", NUMBER_FIELD);
        map.put("Date", DATE_FIELD);
        map.put("Email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferenceSummary, T> g) {
        return obj -> g.apply((ReferenceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceSummary> {
        /**
         * <p>
         * Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
         * </p>
         * 
         * @param url
         *        Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise,
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(UrlReference url);

        /**
         * <p>
         * Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise, null.
         * </p>
         * This is a convenience method that creates an instance of the {@link UrlReference.Builder} avoiding the need
         * to create one manually via {@link UrlReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UrlReference.Builder#build()} is called immediately and its
         * result is passed to {@link #url(UrlReference)}.
         * 
         * @param url
         *        a consumer that will call methods on {@link UrlReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #url(UrlReference)
         */
        default Builder url(Consumer<UrlReference.Builder> url) {
            return url(UrlReference.builder().applyMutation(url).build());
        }

        /**
         * <p>
         * Information about the reference when the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise,
         * null.
         * </p>
         * 
         * @param attachment
         *        Information about the reference when the <code>referenceType</code> is <code>ATTACHMENT</code>.
         *        Otherwise, null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(AttachmentReference attachment);

        /**
         * <p>
         * Information about the reference when the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise,
         * null.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttachmentReference.Builder} avoiding the
         * need to create one manually via {@link AttachmentReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttachmentReference.Builder#build()} is called immediately and
         * its result is passed to {@link #attachment(AttachmentReference)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link AttachmentReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(AttachmentReference)
         */
        default Builder attachment(Consumer<AttachmentReference.Builder> attachment) {
            return attachment(AttachmentReference.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * Information about the reference when the referenceType is <code>EMAIL_MESSAGE</code>. Otherwise, null.
         * </p>
         * 
         * @param emailMessage
         *        Information about the reference when the referenceType is <code>EMAIL_MESSAGE</code>. Otherwise, null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(EmailMessageReference emailMessage);

        /**
         * <p>
         * Information about the reference when the referenceType is <code>EMAIL_MESSAGE</code>. Otherwise, null.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailMessageReference.Builder} avoiding
         * the need to create one manually via {@link EmailMessageReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailMessageReference.Builder#build()} is called immediately and
         * its result is passed to {@link #emailMessage(EmailMessageReference)}.
         * 
         * @param emailMessage
         *        a consumer that will call methods on {@link EmailMessageReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailMessage(EmailMessageReference)
         */
        default Builder emailMessage(Consumer<EmailMessageReference.Builder> emailMessage) {
            return emailMessage(EmailMessageReference.builder().applyMutation(emailMessage).build());
        }

        /**
         * Sets the value of the EmailMessagePlainText property for this object.
         *
         * @param emailMessagePlainText
         *        The new value for the EmailMessagePlainText property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessagePlainText(EmailMessageReference emailMessagePlainText);

        /**
         * Sets the value of the EmailMessagePlainText property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EmailMessageReference.Builder} avoiding
         * the need to create one manually via {@link EmailMessageReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailMessageReference.Builder#build()} is called immediately and
         * its result is passed to {@link #emailMessagePlainText(EmailMessageReference)}.
         * 
         * @param emailMessagePlainText
         *        a consumer that will call methods on {@link EmailMessageReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailMessagePlainText(EmailMessageReference)
         */
        default Builder emailMessagePlainText(Consumer<EmailMessageReference.Builder> emailMessagePlainText) {
            return emailMessagePlainText(EmailMessageReference.builder().applyMutation(emailMessagePlainText).build());
        }

        /**
         * <p>
         * Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise, null.
         * </p>
         * 
         * @param string
         *        Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise,
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder string(StringReference string);

        /**
         * <p>
         * Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise, null.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringReference.Builder} avoiding the
         * need to create one manually via {@link StringReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringReference.Builder#build()} is called immediately and its
         * result is passed to {@link #string(StringReference)}.
         * 
         * @param string
         *        a consumer that will call methods on {@link StringReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #string(StringReference)
         */
        default Builder string(Consumer<StringReference.Builder> string) {
            return string(StringReference.builder().applyMutation(string).build());
        }

        /**
         * <p>
         * Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise, null.
         * </p>
         * 
         * @param number
         *        Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise,
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder number(NumberReference number);

        /**
         * <p>
         * Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise, null.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumberReference.Builder} avoiding the
         * need to create one manually via {@link NumberReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumberReference.Builder#build()} is called immediately and its
         * result is passed to {@link #number(NumberReference)}.
         * 
         * @param number
         *        a consumer that will call methods on {@link NumberReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #number(NumberReference)
         */
        default Builder number(Consumer<NumberReference.Builder> number) {
            return number(NumberReference.builder().applyMutation(number).build());
        }

        /**
         * <p>
         * Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise, null.
         * </p>
         * 
         * @param date
         *        Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise,
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(DateReference date);

        /**
         * <p>
         * Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise, null.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateReference.Builder} avoiding the need
         * to create one manually via {@link DateReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateReference.Builder#build()} is called immediately and its
         * result is passed to {@link #date(DateReference)}.
         * 
         * @param date
         *        a consumer that will call methods on {@link DateReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #date(DateReference)
         */
        default Builder date(Consumer<DateReference.Builder> date) {
            return date(DateReference.builder().applyMutation(date).build());
        }

        /**
         * <p>
         * Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise, null.
         * </p>
         * 
         * @param email
         *        Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise,
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(EmailReference email);

        /**
         * <p>
         * Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise, null.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailReference.Builder} avoiding the need
         * to create one manually via {@link EmailReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailReference.Builder#build()} is called immediately and its
         * result is passed to {@link #email(EmailReference)}.
         * 
         * @param email
         *        a consumer that will call methods on {@link EmailReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #email(EmailReference)
         */
        default Builder email(Consumer<EmailReference.Builder> email) {
            return email(EmailReference.builder().applyMutation(email).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UrlReference url;

        private AttachmentReference attachment;

        private EmailMessageReference emailMessage;

        private EmailMessageReference emailMessagePlainText;

        private StringReference string;

        private NumberReference number;

        private DateReference date;

        private EmailReference email;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceSummary model) {
            url(model.url);
            attachment(model.attachment);
            emailMessage(model.emailMessage);
            emailMessagePlainText(model.emailMessagePlainText);
            string(model.string);
            number(model.number);
            date(model.date);
            email(model.email);
        }

        public final UrlReference.Builder getUrl() {
            return url != null ? url.toBuilder() : null;
        }

        public final void setUrl(UrlReference.BuilderImpl url) {
            Object oldValue = this.url;
            this.url = url != null ? url.build() : null;
            handleUnionValueChange(Type.URL, oldValue, this.url);
        }

        @Override
        public final Builder url(UrlReference url) {
            Object oldValue = this.url;
            this.url = url;
            handleUnionValueChange(Type.URL, oldValue, this.url);
            return this;
        }

        public final AttachmentReference.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(AttachmentReference.BuilderImpl attachment) {
            Object oldValue = this.attachment;
            this.attachment = attachment != null ? attachment.build() : null;
            handleUnionValueChange(Type.ATTACHMENT, oldValue, this.attachment);
        }

        @Override
        public final Builder attachment(AttachmentReference attachment) {
            Object oldValue = this.attachment;
            this.attachment = attachment;
            handleUnionValueChange(Type.ATTACHMENT, oldValue, this.attachment);
            return this;
        }

        public final EmailMessageReference.Builder getEmailMessage() {
            return emailMessage != null ? emailMessage.toBuilder() : null;
        }

        public final void setEmailMessage(EmailMessageReference.BuilderImpl emailMessage) {
            Object oldValue = this.emailMessage;
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
            handleUnionValueChange(Type.EMAIL_MESSAGE, oldValue, this.emailMessage);
        }

        @Override
        public final Builder emailMessage(EmailMessageReference emailMessage) {
            Object oldValue = this.emailMessage;
            this.emailMessage = emailMessage;
            handleUnionValueChange(Type.EMAIL_MESSAGE, oldValue, this.emailMessage);
            return this;
        }

        public final EmailMessageReference.Builder getEmailMessagePlainText() {
            return emailMessagePlainText != null ? emailMessagePlainText.toBuilder() : null;
        }

        public final void setEmailMessagePlainText(EmailMessageReference.BuilderImpl emailMessagePlainText) {
            Object oldValue = this.emailMessagePlainText;
            this.emailMessagePlainText = emailMessagePlainText != null ? emailMessagePlainText.build() : null;
            handleUnionValueChange(Type.EMAIL_MESSAGE_PLAIN_TEXT, oldValue, this.emailMessagePlainText);
        }

        @Override
        public final Builder emailMessagePlainText(EmailMessageReference emailMessagePlainText) {
            Object oldValue = this.emailMessagePlainText;
            this.emailMessagePlainText = emailMessagePlainText;
            handleUnionValueChange(Type.EMAIL_MESSAGE_PLAIN_TEXT, oldValue, this.emailMessagePlainText);
            return this;
        }

        public final StringReference.Builder getString() {
            return string != null ? string.toBuilder() : null;
        }

        public final void setString(StringReference.BuilderImpl string) {
            Object oldValue = this.string;
            this.string = string != null ? string.build() : null;
            handleUnionValueChange(Type.STRING, oldValue, this.string);
        }

        @Override
        public final Builder string(StringReference string) {
            Object oldValue = this.string;
            this.string = string;
            handleUnionValueChange(Type.STRING, oldValue, this.string);
            return this;
        }

        public final NumberReference.Builder getNumber() {
            return number != null ? number.toBuilder() : null;
        }

        public final void setNumber(NumberReference.BuilderImpl number) {
            Object oldValue = this.number;
            this.number = number != null ? number.build() : null;
            handleUnionValueChange(Type.NUMBER, oldValue, this.number);
        }

        @Override
        public final Builder number(NumberReference number) {
            Object oldValue = this.number;
            this.number = number;
            handleUnionValueChange(Type.NUMBER, oldValue, this.number);
            return this;
        }

        public final DateReference.Builder getDate() {
            return date != null ? date.toBuilder() : null;
        }

        public final void setDate(DateReference.BuilderImpl date) {
            Object oldValue = this.date;
            this.date = date != null ? date.build() : null;
            handleUnionValueChange(Type.DATE, oldValue, this.date);
        }

        @Override
        public final Builder date(DateReference date) {
            Object oldValue = this.date;
            this.date = date;
            handleUnionValueChange(Type.DATE, oldValue, this.date);
            return this;
        }

        public final EmailReference.Builder getEmail() {
            return email != null ? email.toBuilder() : null;
        }

        public final void setEmail(EmailReference.BuilderImpl email) {
            Object oldValue = this.email;
            this.email = email != null ? email.build() : null;
            handleUnionValueChange(Type.EMAIL, oldValue, this.email);
        }

        @Override
        public final Builder email(EmailReference email) {
            Object oldValue = this.email;
            this.email = email;
            handleUnionValueChange(Type.EMAIL, oldValue, this.email);
            return this;
        }

        @Override
        public ReferenceSummary build() {
            return new ReferenceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ReferenceSummary#type()
     */
    public enum Type {
        URL,

        ATTACHMENT,

        EMAIL_MESSAGE,

        EMAIL_MESSAGE_PLAIN_TEXT,

        STRING,

        NUMBER,

        DATE,

        EMAIL,

        UNKNOWN_TO_SDK_VERSION
    }
}
