/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contact data associated with quick connect operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuickConnectContactData implements SdkPojo, Serializable,
        ToCopyableBuilder<QuickConnectContactData.Builder, QuickConnectContactData> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(QuickConnectContactData::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<Instant> INITIATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InitiationTimestamp").getter(getter(QuickConnectContactData::initiationTimestamp))
            .setter(setter(Builder::initiationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTimestamp").build())
            .build();

    private static final SdkField<String> QUICK_CONNECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuickConnectId").getter(getter(QuickConnectContactData::quickConnectId))
            .setter(setter(Builder::quickConnectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectId").build()).build();

    private static final SdkField<String> QUICK_CONNECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuickConnectName").getter(getter(QuickConnectContactData::quickConnectName))
            .setter(setter(Builder::quickConnectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectName").build()).build();

    private static final SdkField<String> QUICK_CONNECT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuickConnectType").getter(getter(QuickConnectContactData::quickConnectTypeAsString))
            .setter(setter(Builder::quickConnectType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            INITIATION_TIMESTAMP_FIELD, QUICK_CONNECT_ID_FIELD, QUICK_CONNECT_NAME_FIELD, QUICK_CONNECT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactId;

    private final Instant initiationTimestamp;

    private final String quickConnectId;

    private final String quickConnectName;

    private final String quickConnectType;

    private QuickConnectContactData(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.initiationTimestamp = builder.initiationTimestamp;
        this.quickConnectId = builder.quickConnectId;
        this.quickConnectName = builder.quickConnectName;
        this.quickConnectType = builder.quickConnectType;
    }

    /**
     * <p>
     * The contact ID for quick connect contact data.
     * </p>
     * 
     * @return The contact ID for quick connect contact data.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * Timestamp when the quick connect contact was initiated.
     * </p>
     * 
     * @return Timestamp when the quick connect contact was initiated.
     */
    public final Instant initiationTimestamp() {
        return initiationTimestamp;
    }

    /**
     * <p>
     * The quick connect ID.
     * </p>
     * 
     * @return The quick connect ID.
     */
    public final String quickConnectId() {
        return quickConnectId;
    }

    /**
     * <p>
     * The name of the quick connect.
     * </p>
     * 
     * @return The name of the quick connect.
     */
    public final String quickConnectName() {
        return quickConnectName;
    }

    /**
     * <p>
     * The type of the quick connect.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #quickConnectType}
     * will return {@link QuickConnectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #quickConnectTypeAsString}.
     * </p>
     * 
     * @return The type of the quick connect.
     * @see QuickConnectType
     */
    public final QuickConnectType quickConnectType() {
        return QuickConnectType.fromValue(quickConnectType);
    }

    /**
     * <p>
     * The type of the quick connect.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #quickConnectType}
     * will return {@link QuickConnectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #quickConnectTypeAsString}.
     * </p>
     * 
     * @return The type of the quick connect.
     * @see QuickConnectType
     */
    public final String quickConnectTypeAsString() {
        return quickConnectType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(initiationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(quickConnectId());
        hashCode = 31 * hashCode + Objects.hashCode(quickConnectName());
        hashCode = 31 * hashCode + Objects.hashCode(quickConnectTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickConnectContactData)) {
            return false;
        }
        QuickConnectContactData other = (QuickConnectContactData) obj;
        return Objects.equals(contactId(), other.contactId())
                && Objects.equals(initiationTimestamp(), other.initiationTimestamp())
                && Objects.equals(quickConnectId(), other.quickConnectId())
                && Objects.equals(quickConnectName(), other.quickConnectName())
                && Objects.equals(quickConnectTypeAsString(), other.quickConnectTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuickConnectContactData").add("ContactId", contactId())
                .add("InitiationTimestamp", initiationTimestamp()).add("QuickConnectId", quickConnectId())
                .add("QuickConnectName", quickConnectName()).add("QuickConnectType", quickConnectTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "InitiationTimestamp":
            return Optional.ofNullable(clazz.cast(initiationTimestamp()));
        case "QuickConnectId":
            return Optional.ofNullable(clazz.cast(quickConnectId()));
        case "QuickConnectName":
            return Optional.ofNullable(clazz.cast(quickConnectName()));
        case "QuickConnectType":
            return Optional.ofNullable(clazz.cast(quickConnectTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("InitiationTimestamp", INITIATION_TIMESTAMP_FIELD);
        map.put("QuickConnectId", QUICK_CONNECT_ID_FIELD);
        map.put("QuickConnectName", QUICK_CONNECT_NAME_FIELD);
        map.put("QuickConnectType", QUICK_CONNECT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuickConnectContactData, T> g) {
        return obj -> g.apply((QuickConnectContactData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuickConnectContactData> {
        /**
         * <p>
         * The contact ID for quick connect contact data.
         * </p>
         * 
         * @param contactId
         *        The contact ID for quick connect contact data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * Timestamp when the quick connect contact was initiated.
         * </p>
         * 
         * @param initiationTimestamp
         *        Timestamp when the quick connect contact was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiationTimestamp(Instant initiationTimestamp);

        /**
         * <p>
         * The quick connect ID.
         * </p>
         * 
         * @param quickConnectId
         *        The quick connect ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectId(String quickConnectId);

        /**
         * <p>
         * The name of the quick connect.
         * </p>
         * 
         * @param quickConnectName
         *        The name of the quick connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectName(String quickConnectName);

        /**
         * <p>
         * The type of the quick connect.
         * </p>
         * 
         * @param quickConnectType
         *        The type of the quick connect.
         * @see QuickConnectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuickConnectType
         */
        Builder quickConnectType(String quickConnectType);

        /**
         * <p>
         * The type of the quick connect.
         * </p>
         * 
         * @param quickConnectType
         *        The type of the quick connect.
         * @see QuickConnectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuickConnectType
         */
        Builder quickConnectType(QuickConnectType quickConnectType);
    }

    static final class BuilderImpl implements Builder {
        private String contactId;

        private Instant initiationTimestamp;

        private String quickConnectId;

        private String quickConnectName;

        private String quickConnectType;

        private BuilderImpl() {
        }

        private BuilderImpl(QuickConnectContactData model) {
            contactId(model.contactId);
            initiationTimestamp(model.initiationTimestamp);
            quickConnectId(model.quickConnectId);
            quickConnectName(model.quickConnectName);
            quickConnectType(model.quickConnectType);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final Instant getInitiationTimestamp() {
            return initiationTimestamp;
        }

        public final void setInitiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
        }

        @Override
        public final Builder initiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
            return this;
        }

        public final String getQuickConnectId() {
            return quickConnectId;
        }

        public final void setQuickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
        }

        @Override
        public final Builder quickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
            return this;
        }

        public final String getQuickConnectName() {
            return quickConnectName;
        }

        public final void setQuickConnectName(String quickConnectName) {
            this.quickConnectName = quickConnectName;
        }

        @Override
        public final Builder quickConnectName(String quickConnectName) {
            this.quickConnectName = quickConnectName;
            return this;
        }

        public final String getQuickConnectType() {
            return quickConnectType;
        }

        public final void setQuickConnectType(String quickConnectType) {
            this.quickConnectType = quickConnectType;
        }

        @Override
        public final Builder quickConnectType(String quickConnectType) {
            this.quickConnectType = quickConnectType;
            return this;
        }

        @Override
        public final Builder quickConnectType(QuickConnectType quickConnectType) {
            this.quickConnectType(quickConnectType == null ? null : quickConnectType.toString());
            return this;
        }

        @Override
        public QuickConnectContactData build() {
            return new QuickConnectContactData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
