/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains color configuration for navigation elements in a workspace theme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PaletteNavigation implements SdkPojo, Serializable,
        ToCopyableBuilder<PaletteNavigation.Builder, PaletteNavigation> {
    private static final SdkField<String> BACKGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Background").getter(getter(PaletteNavigation::background)).setter(setter(Builder::background))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Background").build()).build();

    private static final SdkField<String> TEXT_BACKGROUND_HOVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextBackgroundHover").getter(getter(PaletteNavigation::textBackgroundHover))
            .setter(setter(Builder::textBackgroundHover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextBackgroundHover").build())
            .build();

    private static final SdkField<String> TEXT_BACKGROUND_ACTIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextBackgroundActive").getter(getter(PaletteNavigation::textBackgroundActive))
            .setter(setter(Builder::textBackgroundActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextBackgroundActive").build())
            .build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(PaletteNavigation::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> TEXT_HOVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextHover").getter(getter(PaletteNavigation::textHover)).setter(setter(Builder::textHover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextHover").build()).build();

    private static final SdkField<String> TEXT_ACTIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextActive").getter(getter(PaletteNavigation::textActive)).setter(setter(Builder::textActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextActive").build()).build();

    private static final SdkField<Boolean> INVERT_ACTIONS_COLORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InvertActionsColors").getter(getter(PaletteNavigation::invertActionsColors))
            .setter(setter(Builder::invertActionsColors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvertActionsColors").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKGROUND_FIELD,
            TEXT_BACKGROUND_HOVER_FIELD, TEXT_BACKGROUND_ACTIVE_FIELD, TEXT_FIELD, TEXT_HOVER_FIELD, TEXT_ACTIVE_FIELD,
            INVERT_ACTIONS_COLORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String background;

    private final String textBackgroundHover;

    private final String textBackgroundActive;

    private final String text;

    private final String textHover;

    private final String textActive;

    private final Boolean invertActionsColors;

    private PaletteNavigation(BuilderImpl builder) {
        this.background = builder.background;
        this.textBackgroundHover = builder.textBackgroundHover;
        this.textBackgroundActive = builder.textBackgroundActive;
        this.text = builder.text;
        this.textHover = builder.textHover;
        this.textActive = builder.textActive;
        this.invertActionsColors = builder.invertActionsColors;
    }

    /**
     * <p>
     * The background color of the navigation area.
     * </p>
     * 
     * @return The background color of the navigation area.
     */
    public final String background() {
        return background;
    }

    /**
     * <p>
     * The background color when hovering over navigation text.
     * </p>
     * 
     * @return The background color when hovering over navigation text.
     */
    public final String textBackgroundHover() {
        return textBackgroundHover;
    }

    /**
     * <p>
     * The background color for active navigation items.
     * </p>
     * 
     * @return The background color for active navigation items.
     */
    public final String textBackgroundActive() {
        return textBackgroundActive;
    }

    /**
     * <p>
     * The text color in the navigation area.
     * </p>
     * 
     * @return The text color in the navigation area.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The text color when hovering over navigation items.
     * </p>
     * 
     * @return The text color when hovering over navigation items.
     */
    public final String textHover() {
        return textHover;
    }

    /**
     * <p>
     * The text color for active navigation items.
     * </p>
     * 
     * @return The text color for active navigation items.
     */
    public final String textActive() {
        return textActive;
    }

    /**
     * <p>
     * Whether to invert the colors of action buttons in the navigation area.
     * </p>
     * 
     * @return Whether to invert the colors of action buttons in the navigation area.
     */
    public final Boolean invertActionsColors() {
        return invertActionsColors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(background());
        hashCode = 31 * hashCode + Objects.hashCode(textBackgroundHover());
        hashCode = 31 * hashCode + Objects.hashCode(textBackgroundActive());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(textHover());
        hashCode = 31 * hashCode + Objects.hashCode(textActive());
        hashCode = 31 * hashCode + Objects.hashCode(invertActionsColors());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaletteNavigation)) {
            return false;
        }
        PaletteNavigation other = (PaletteNavigation) obj;
        return Objects.equals(background(), other.background())
                && Objects.equals(textBackgroundHover(), other.textBackgroundHover())
                && Objects.equals(textBackgroundActive(), other.textBackgroundActive()) && Objects.equals(text(), other.text())
                && Objects.equals(textHover(), other.textHover()) && Objects.equals(textActive(), other.textActive())
                && Objects.equals(invertActionsColors(), other.invertActionsColors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PaletteNavigation").add("Background", background())
                .add("TextBackgroundHover", textBackgroundHover()).add("TextBackgroundActive", textBackgroundActive())
                .add("Text", text()).add("TextHover", textHover()).add("TextActive", textActive())
                .add("InvertActionsColors", invertActionsColors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Background":
            return Optional.ofNullable(clazz.cast(background()));
        case "TextBackgroundHover":
            return Optional.ofNullable(clazz.cast(textBackgroundHover()));
        case "TextBackgroundActive":
            return Optional.ofNullable(clazz.cast(textBackgroundActive()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "TextHover":
            return Optional.ofNullable(clazz.cast(textHover()));
        case "TextActive":
            return Optional.ofNullable(clazz.cast(textActive()));
        case "InvertActionsColors":
            return Optional.ofNullable(clazz.cast(invertActionsColors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Background", BACKGROUND_FIELD);
        map.put("TextBackgroundHover", TEXT_BACKGROUND_HOVER_FIELD);
        map.put("TextBackgroundActive", TEXT_BACKGROUND_ACTIVE_FIELD);
        map.put("Text", TEXT_FIELD);
        map.put("TextHover", TEXT_HOVER_FIELD);
        map.put("TextActive", TEXT_ACTIVE_FIELD);
        map.put("InvertActionsColors", INVERT_ACTIONS_COLORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PaletteNavigation, T> g) {
        return obj -> g.apply((PaletteNavigation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PaletteNavigation> {
        /**
         * <p>
         * The background color of the navigation area.
         * </p>
         * 
         * @param background
         *        The background color of the navigation area.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder background(String background);

        /**
         * <p>
         * The background color when hovering over navigation text.
         * </p>
         * 
         * @param textBackgroundHover
         *        The background color when hovering over navigation text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textBackgroundHover(String textBackgroundHover);

        /**
         * <p>
         * The background color for active navigation items.
         * </p>
         * 
         * @param textBackgroundActive
         *        The background color for active navigation items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textBackgroundActive(String textBackgroundActive);

        /**
         * <p>
         * The text color in the navigation area.
         * </p>
         * 
         * @param text
         *        The text color in the navigation area.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The text color when hovering over navigation items.
         * </p>
         * 
         * @param textHover
         *        The text color when hovering over navigation items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textHover(String textHover);

        /**
         * <p>
         * The text color for active navigation items.
         * </p>
         * 
         * @param textActive
         *        The text color for active navigation items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textActive(String textActive);

        /**
         * <p>
         * Whether to invert the colors of action buttons in the navigation area.
         * </p>
         * 
         * @param invertActionsColors
         *        Whether to invert the colors of action buttons in the navigation area.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invertActionsColors(Boolean invertActionsColors);
    }

    static final class BuilderImpl implements Builder {
        private String background;

        private String textBackgroundHover;

        private String textBackgroundActive;

        private String text;

        private String textHover;

        private String textActive;

        private Boolean invertActionsColors;

        private BuilderImpl() {
        }

        private BuilderImpl(PaletteNavigation model) {
            background(model.background);
            textBackgroundHover(model.textBackgroundHover);
            textBackgroundActive(model.textBackgroundActive);
            text(model.text);
            textHover(model.textHover);
            textActive(model.textActive);
            invertActionsColors(model.invertActionsColors);
        }

        public final String getBackground() {
            return background;
        }

        public final void setBackground(String background) {
            this.background = background;
        }

        @Override
        public final Builder background(String background) {
            this.background = background;
            return this;
        }

        public final String getTextBackgroundHover() {
            return textBackgroundHover;
        }

        public final void setTextBackgroundHover(String textBackgroundHover) {
            this.textBackgroundHover = textBackgroundHover;
        }

        @Override
        public final Builder textBackgroundHover(String textBackgroundHover) {
            this.textBackgroundHover = textBackgroundHover;
            return this;
        }

        public final String getTextBackgroundActive() {
            return textBackgroundActive;
        }

        public final void setTextBackgroundActive(String textBackgroundActive) {
            this.textBackgroundActive = textBackgroundActive;
        }

        @Override
        public final Builder textBackgroundActive(String textBackgroundActive) {
            this.textBackgroundActive = textBackgroundActive;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getTextHover() {
            return textHover;
        }

        public final void setTextHover(String textHover) {
            this.textHover = textHover;
        }

        @Override
        public final Builder textHover(String textHover) {
            this.textHover = textHover;
            return this;
        }

        public final String getTextActive() {
            return textActive;
        }

        public final void setTextActive(String textActive) {
            this.textActive = textActive;
        }

        @Override
        public final Builder textActive(String textActive) {
            this.textActive = textActive;
            return this;
        }

        public final Boolean getInvertActionsColors() {
            return invertActionsColors;
        }

        public final void setInvertActionsColors(Boolean invertActionsColors) {
            this.invertActionsColors = invertActionsColors;
        }

        @Override
        public final Builder invertActionsColors(Boolean invertActionsColors) {
            this.invertActionsColors = invertActionsColors;
            return this;
        }

        @Override
        public PaletteNavigation build() {
            return new PaletteNavigation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
