/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains color configuration for canvas elements in a workspace theme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PaletteCanvas implements SdkPojo, Serializable, ToCopyableBuilder<PaletteCanvas.Builder, PaletteCanvas> {
    private static final SdkField<String> CONTAINER_BACKGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerBackground").getter(getter(PaletteCanvas::containerBackground))
            .setter(setter(Builder::containerBackground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerBackground").build())
            .build();

    private static final SdkField<String> PAGE_BACKGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageBackground").getter(getter(PaletteCanvas::pageBackground)).setter(setter(Builder::pageBackground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageBackground").build()).build();

    private static final SdkField<String> ACTIVE_BACKGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveBackground").getter(getter(PaletteCanvas::activeBackground))
            .setter(setter(Builder::activeBackground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveBackground").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_BACKGROUND_FIELD,
            PAGE_BACKGROUND_FIELD, ACTIVE_BACKGROUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String containerBackground;

    private final String pageBackground;

    private final String activeBackground;

    private PaletteCanvas(BuilderImpl builder) {
        this.containerBackground = builder.containerBackground;
        this.pageBackground = builder.pageBackground;
        this.activeBackground = builder.activeBackground;
    }

    /**
     * <p>
     * The background color for container elements.
     * </p>
     * 
     * @return The background color for container elements.
     */
    public final String containerBackground() {
        return containerBackground;
    }

    /**
     * <p>
     * The background color for page elements.
     * </p>
     * 
     * @return The background color for page elements.
     */
    public final String pageBackground() {
        return pageBackground;
    }

    /**
     * <p>
     * The background color for active elements.
     * </p>
     * 
     * @return The background color for active elements.
     */
    public final String activeBackground() {
        return activeBackground;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerBackground());
        hashCode = 31 * hashCode + Objects.hashCode(pageBackground());
        hashCode = 31 * hashCode + Objects.hashCode(activeBackground());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaletteCanvas)) {
            return false;
        }
        PaletteCanvas other = (PaletteCanvas) obj;
        return Objects.equals(containerBackground(), other.containerBackground())
                && Objects.equals(pageBackground(), other.pageBackground())
                && Objects.equals(activeBackground(), other.activeBackground());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PaletteCanvas").add("ContainerBackground", containerBackground())
                .add("PageBackground", pageBackground()).add("ActiveBackground", activeBackground()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerBackground":
            return Optional.ofNullable(clazz.cast(containerBackground()));
        case "PageBackground":
            return Optional.ofNullable(clazz.cast(pageBackground()));
        case "ActiveBackground":
            return Optional.ofNullable(clazz.cast(activeBackground()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContainerBackground", CONTAINER_BACKGROUND_FIELD);
        map.put("PageBackground", PAGE_BACKGROUND_FIELD);
        map.put("ActiveBackground", ACTIVE_BACKGROUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PaletteCanvas, T> g) {
        return obj -> g.apply((PaletteCanvas) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PaletteCanvas> {
        /**
         * <p>
         * The background color for container elements.
         * </p>
         * 
         * @param containerBackground
         *        The background color for container elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerBackground(String containerBackground);

        /**
         * <p>
         * The background color for page elements.
         * </p>
         * 
         * @param pageBackground
         *        The background color for page elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageBackground(String pageBackground);

        /**
         * <p>
         * The background color for active elements.
         * </p>
         * 
         * @param activeBackground
         *        The background color for active elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeBackground(String activeBackground);
    }

    static final class BuilderImpl implements Builder {
        private String containerBackground;

        private String pageBackground;

        private String activeBackground;

        private BuilderImpl() {
        }

        private BuilderImpl(PaletteCanvas model) {
            containerBackground(model.containerBackground);
            pageBackground(model.pageBackground);
            activeBackground(model.activeBackground);
        }

        public final String getContainerBackground() {
            return containerBackground;
        }

        public final void setContainerBackground(String containerBackground) {
            this.containerBackground = containerBackground;
        }

        @Override
        public final Builder containerBackground(String containerBackground) {
            this.containerBackground = containerBackground;
            return this;
        }

        public final String getPageBackground() {
            return pageBackground;
        }

        public final void setPageBackground(String pageBackground) {
            this.pageBackground = pageBackground;
        }

        @Override
        public final Builder pageBackground(String pageBackground) {
            this.pageBackground = pageBackground;
            return this;
        }

        public final String getActiveBackground() {
            return activeBackground;
        }

        public final void setActiveBackground(String activeBackground) {
            this.activeBackground = activeBackground;
        }

        @Override
        public final Builder activeBackground(String activeBackground) {
            this.activeBackground = activeBackground;
            return this;
        }

        @Override
        public PaletteCanvas build() {
            return new PaletteCanvas(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
