/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata information for next contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NextContactMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<NextContactMetadata.Builder, NextContactMetadata> {
    private static final SdkField<QuickConnectContactData> QUICK_CONNECT_CONTACT_DATA_FIELD = SdkField
            .<QuickConnectContactData> builder(MarshallingType.SDK_POJO).memberName("QuickConnectContactData")
            .getter(getter(NextContactMetadata::quickConnectContactData)).setter(setter(Builder::quickConnectContactData))
            .constructor(QuickConnectContactData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectContactData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(QUICK_CONNECT_CONTACT_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final QuickConnectContactData quickConnectContactData;

    private final Type type;

    private NextContactMetadata(BuilderImpl builder) {
        this.quickConnectContactData = builder.quickConnectContactData;
        this.type = builder.type;
    }

    /**
     * <p>
     * Quick connect contact data for the next contact metadata.
     * </p>
     * 
     * @return Quick connect contact data for the next contact metadata.
     */
    public final QuickConnectContactData quickConnectContactData() {
        return quickConnectContactData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quickConnectContactData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NextContactMetadata)) {
            return false;
        }
        NextContactMetadata other = (NextContactMetadata) obj;
        return Objects.equals(quickConnectContactData(), other.quickConnectContactData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NextContactMetadata").add("QuickConnectContactData", quickConnectContactData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuickConnectContactData":
            return Optional.ofNullable(clazz.cast(quickConnectContactData()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #quickConnectContactData()} initialized to the given value.
     *
     * <p>
     * Quick connect contact data for the next contact metadata.
     * </p>
     * 
     * @param quickConnectContactData
     *        Quick connect contact data for the next contact metadata.
     */
    public static NextContactMetadata fromQuickConnectContactData(QuickConnectContactData quickConnectContactData) {
        return builder().quickConnectContactData(quickConnectContactData).build();
    }

    /**
     * Create an instance of this class with {@link #quickConnectContactData()} initialized to the given value.
     *
     * <p>
     * Quick connect contact data for the next contact metadata.
     * </p>
     * 
     * @param quickConnectContactData
     *        Quick connect contact data for the next contact metadata.
     */
    public static NextContactMetadata fromQuickConnectContactData(
            Consumer<QuickConnectContactData.Builder> quickConnectContactData) {
        QuickConnectContactData.Builder builder = QuickConnectContactData.builder();
        quickConnectContactData.accept(builder);
        return fromQuickConnectContactData(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QuickConnectContactData", QUICK_CONNECT_CONTACT_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NextContactMetadata, T> g) {
        return obj -> g.apply((NextContactMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NextContactMetadata> {
        /**
         * <p>
         * Quick connect contact data for the next contact metadata.
         * </p>
         * 
         * @param quickConnectContactData
         *        Quick connect contact data for the next contact metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectContactData(QuickConnectContactData quickConnectContactData);

        /**
         * <p>
         * Quick connect contact data for the next contact metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuickConnectContactData.Builder} avoiding
         * the need to create one manually via {@link QuickConnectContactData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickConnectContactData.Builder#build()} is called immediately
         * and its result is passed to {@link #quickConnectContactData(QuickConnectContactData)}.
         * 
         * @param quickConnectContactData
         *        a consumer that will call methods on {@link QuickConnectContactData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quickConnectContactData(QuickConnectContactData)
         */
        default Builder quickConnectContactData(Consumer<QuickConnectContactData.Builder> quickConnectContactData) {
            return quickConnectContactData(QuickConnectContactData.builder().applyMutation(quickConnectContactData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QuickConnectContactData quickConnectContactData;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NextContactMetadata model) {
            quickConnectContactData(model.quickConnectContactData);
        }

        public final QuickConnectContactData.Builder getQuickConnectContactData() {
            return quickConnectContactData != null ? quickConnectContactData.toBuilder() : null;
        }

        public final void setQuickConnectContactData(QuickConnectContactData.BuilderImpl quickConnectContactData) {
            Object oldValue = this.quickConnectContactData;
            this.quickConnectContactData = quickConnectContactData != null ? quickConnectContactData.build() : null;
            handleUnionValueChange(Type.QUICK_CONNECT_CONTACT_DATA, oldValue, this.quickConnectContactData);
        }

        @Override
        public final Builder quickConnectContactData(QuickConnectContactData quickConnectContactData) {
            Object oldValue = this.quickConnectContactData;
            this.quickConnectContactData = quickConnectContactData;
            handleUnionValueChange(Type.QUICK_CONNECT_CONTACT_DATA, oldValue, this.quickConnectContactData);
            return this;
        }

        @Override
        public NextContactMetadata build() {
            return new NextContactMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see NextContactMetadata#type()
     */
    public enum Type {
        QUICK_CONNECT_CONTACT_DATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
