/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the name, thresholds, and metric filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDataV2 implements SdkPojo, Serializable, ToCopyableBuilder<MetricDataV2.Builder, MetricDataV2> {
    private static final SdkField<MetricV2> METRIC_FIELD = SdkField.<MetricV2> builder(MarshallingType.SDK_POJO)
            .memberName("Metric").getter(getter(MetricDataV2::metric)).setter(setter(Builder::metric))
            .constructor(MetricV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(MetricDataV2::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MetricV2 metric;

    private final Double value;

    private MetricDataV2(BuilderImpl builder) {
        this.metric = builder.metric;
        this.value = builder.value;
    }

    /**
     * <p>
     * The metric name or metricId, thresholds, and metric filters of the returned metric.
     * </p>
     * 
     * @return The metric name or metricId, thresholds, and metric filters of the returned metric.
     */
    public final MetricV2 metric() {
        return metric;
    }

    /**
     * <p>
     * The corresponding value of the metric returned in the response.
     * </p>
     * 
     * @return The corresponding value of the metric returned in the response.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDataV2)) {
            return false;
        }
        MetricDataV2 other = (MetricDataV2) obj;
        return Objects.equals(metric(), other.metric()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDataV2").add("Metric", metric()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Metric", METRIC_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricDataV2, T> g) {
        return obj -> g.apply((MetricDataV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDataV2> {
        /**
         * <p>
         * The metric name or metricId, thresholds, and metric filters of the returned metric.
         * </p>
         * 
         * @param metric
         *        The metric name or metricId, thresholds, and metric filters of the returned metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(MetricV2 metric);

        /**
         * <p>
         * The metric name or metricId, thresholds, and metric filters of the returned metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricV2.Builder} avoiding the need to
         * create one manually via {@link MetricV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricV2.Builder#build()} is called immediately and its result is
         * passed to {@link #metric(MetricV2)}.
         * 
         * @param metric
         *        a consumer that will call methods on {@link MetricV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metric(MetricV2)
         */
        default Builder metric(Consumer<MetricV2.Builder> metric) {
            return metric(MetricV2.builder().applyMutation(metric).build());
        }

        /**
         * <p>
         * The corresponding value of the metric returned in the response.
         * </p>
         * 
         * @param value
         *        The corresponding value of the metric returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private MetricV2 metric;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDataV2 model) {
            metric(model.metric);
            value(model.value);
        }

        public final MetricV2.Builder getMetric() {
            return metric != null ? metric.toBuilder() : null;
        }

        public final void setMetric(MetricV2.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(MetricV2 metric) {
            this.metric = metric;
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public MetricDataV2 build() {
            return new MetricDataV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
