/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkspacesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListWorkspacesResponse.Builder, ListWorkspacesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWorkspacesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<WorkspaceSummary>> WORKSPACE_SUMMARY_LIST_FIELD = SdkField
            .<List<WorkspaceSummary>> builder(MarshallingType.LIST)
            .memberName("WorkspaceSummaryList")
            .getter(getter(ListWorkspacesResponse::workspaceSummaryList))
            .setter(setter(Builder::workspaceSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspaceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspaceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WORKSPACE_SUMMARY_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<WorkspaceSummary> workspaceSummaryList;

    private ListWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workspaceSummaryList = builder.workspaceSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkspaceSummaryList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkspaceSummaryList() {
        return workspaceSummaryList != null && !(workspaceSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary list of workspaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaceSummaryList} method.
     * </p>
     * 
     * @return A summary list of workspaces.
     */
    public final List<WorkspaceSummary> workspaceSummaryList() {
        return workspaceSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaceSummaryList() ? workspaceSummaryList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspacesResponse)) {
            return false;
        }
        ListWorkspacesResponse other = (ListWorkspacesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWorkspaceSummaryList() == other.hasWorkspaceSummaryList()
                && Objects.equals(workspaceSummaryList(), other.workspaceSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkspacesResponse").add("NextToken", nextToken())
                .add("WorkspaceSummaryList", hasWorkspaceSummaryList() ? workspaceSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WorkspaceSummaryList":
            return Optional.ofNullable(clazz.cast(workspaceSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WorkspaceSummaryList", WORKSPACE_SUMMARY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspacesResponse, T> g) {
        return obj -> g.apply((ListWorkspacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkspacesResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A summary list of workspaces.
         * </p>
         * 
         * @param workspaceSummaryList
         *        A summary list of workspaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceSummaryList(Collection<WorkspaceSummary> workspaceSummaryList);

        /**
         * <p>
         * A summary list of workspaces.
         * </p>
         * 
         * @param workspaceSummaryList
         *        A summary list of workspaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceSummaryList(WorkspaceSummary... workspaceSummaryList);

        /**
         * <p>
         * A summary list of workspaces.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.WorkspaceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #workspaceSummaryList(List<WorkspaceSummary>)}.
         * 
         * @param workspaceSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.WorkspaceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceSummaryList(java.util.Collection<WorkspaceSummary>)
         */
        Builder workspaceSummaryList(Consumer<WorkspaceSummary.Builder>... workspaceSummaryList);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<WorkspaceSummary> workspaceSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspacesResponse model) {
            super(model);
            nextToken(model.nextToken);
            workspaceSummaryList(model.workspaceSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkspaceSummary.Builder> getWorkspaceSummaryList() {
            List<WorkspaceSummary.Builder> result = WorkspaceSummaryListCopier.copyToBuilder(this.workspaceSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaceSummaryList(Collection<WorkspaceSummary.BuilderImpl> workspaceSummaryList) {
            this.workspaceSummaryList = WorkspaceSummaryListCopier.copyFromBuilder(workspaceSummaryList);
        }

        @Override
        public final Builder workspaceSummaryList(Collection<WorkspaceSummary> workspaceSummaryList) {
            this.workspaceSummaryList = WorkspaceSummaryListCopier.copy(workspaceSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceSummaryList(WorkspaceSummary... workspaceSummaryList) {
            workspaceSummaryList(Arrays.asList(workspaceSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceSummaryList(Consumer<WorkspaceSummary.Builder>... workspaceSummaryList) {
            workspaceSummaryList(Stream.of(workspaceSummaryList).map(c -> WorkspaceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkspacesResponse build() {
            return new ListWorkspacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
