/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataTablePrimaryValuesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListDataTablePrimaryValuesResponse.Builder, ListDataTablePrimaryValuesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDataTablePrimaryValuesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RecordPrimaryValue>> PRIMARY_VALUES_LIST_FIELD = SdkField
            .<List<RecordPrimaryValue>> builder(MarshallingType.LIST)
            .memberName("PrimaryValuesList")
            .getter(getter(ListDataTablePrimaryValuesResponse::primaryValuesList))
            .setter(setter(Builder::primaryValuesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValuesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecordPrimaryValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecordPrimaryValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PRIMARY_VALUES_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<RecordPrimaryValue> primaryValuesList;

    private ListDataTablePrimaryValuesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.primaryValuesList = builder.primaryValuesList;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryValuesList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryValuesList() {
        return primaryValuesList != null && !(primaryValuesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of primary value combinations with their record IDs and modification metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryValuesList} method.
     * </p>
     * 
     * @return A list of primary value combinations with their record IDs and modification metadata.
     */
    public final List<RecordPrimaryValue> primaryValuesList() {
        return primaryValuesList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryValuesList() ? primaryValuesList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataTablePrimaryValuesResponse)) {
            return false;
        }
        ListDataTablePrimaryValuesResponse other = (ListDataTablePrimaryValuesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPrimaryValuesList() == other.hasPrimaryValuesList()
                && Objects.equals(primaryValuesList(), other.primaryValuesList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataTablePrimaryValuesResponse").add("NextToken", nextToken())
                .add("PrimaryValuesList", hasPrimaryValuesList() ? primaryValuesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PrimaryValuesList":
            return Optional.ofNullable(clazz.cast(primaryValuesList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PrimaryValuesList", PRIMARY_VALUES_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataTablePrimaryValuesResponse, T> g) {
        return obj -> g.apply((ListDataTablePrimaryValuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataTablePrimaryValuesResponse> {
        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of primary value combinations with their record IDs and modification metadata.
         * </p>
         * 
         * @param primaryValuesList
         *        A list of primary value combinations with their record IDs and modification metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValuesList(Collection<RecordPrimaryValue> primaryValuesList);

        /**
         * <p>
         * A list of primary value combinations with their record IDs and modification metadata.
         * </p>
         * 
         * @param primaryValuesList
         *        A list of primary value combinations with their record IDs and modification metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValuesList(RecordPrimaryValue... primaryValuesList);

        /**
         * <p>
         * A list of primary value combinations with their record IDs and modification metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.RecordPrimaryValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.RecordPrimaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.RecordPrimaryValue.Builder#build()} is called
         * immediately and its result is passed to {@link #primaryValuesList(List<RecordPrimaryValue>)}.
         * 
         * @param primaryValuesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.RecordPrimaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValuesList(java.util.Collection<RecordPrimaryValue>)
         */
        Builder primaryValuesList(Consumer<RecordPrimaryValue.Builder>... primaryValuesList);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RecordPrimaryValue> primaryValuesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataTablePrimaryValuesResponse model) {
            super(model);
            nextToken(model.nextToken);
            primaryValuesList(model.primaryValuesList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecordPrimaryValue.Builder> getPrimaryValuesList() {
            List<RecordPrimaryValue.Builder> result = PrimaryValuesListCopier.copyToBuilder(this.primaryValuesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValuesList(Collection<RecordPrimaryValue.BuilderImpl> primaryValuesList) {
            this.primaryValuesList = PrimaryValuesListCopier.copyFromBuilder(primaryValuesList);
        }

        @Override
        public final Builder primaryValuesList(Collection<RecordPrimaryValue> primaryValuesList) {
            this.primaryValuesList = PrimaryValuesListCopier.copy(primaryValuesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValuesList(RecordPrimaryValue... primaryValuesList) {
            primaryValuesList(Arrays.asList(primaryValuesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValuesList(Consumer<RecordPrimaryValue.Builder>... primaryValuesList) {
            primaryValuesList(Stream.of(primaryValuesList).map(c -> RecordPrimaryValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDataTablePrimaryValuesResponse build() {
            return new ListDataTablePrimaryValuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
