/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A leaf node condition which can be used to specify a List condition to search users with attributes included in Lists
 * like Proficiencies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCondition implements SdkPojo, Serializable, ToCopyableBuilder<ListCondition.Builder, ListCondition> {
    private static final SdkField<String> TARGET_LIST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetListType").getter(getter(ListCondition::targetListTypeAsString))
            .setter(setter(Builder::targetListType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetListType").build()).build();

    private static final SdkField<List<Condition>> CONDITIONS_FIELD = SdkField
            .<List<Condition>> builder(MarshallingType.LIST)
            .memberName("Conditions")
            .getter(getter(ListCondition::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Condition> builder(MarshallingType.SDK_POJO)
                                            .constructor(Condition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_LIST_TYPE_FIELD,
            CONDITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetListType;

    private final List<Condition> conditions;

    private ListCondition(BuilderImpl builder) {
        this.targetListType = builder.targetListType;
        this.conditions = builder.conditions;
    }

    /**
     * <p>
     * The type of target list that will be used to filter the users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetListType}
     * will return {@link TargetListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetListTypeAsString}.
     * </p>
     * 
     * @return The type of target list that will be used to filter the users.
     * @see TargetListType
     */
    public final TargetListType targetListType() {
        return TargetListType.fromValue(targetListType);
    }

    /**
     * <p>
     * The type of target list that will be used to filter the users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetListType}
     * will return {@link TargetListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetListTypeAsString}.
     * </p>
     * 
     * @return The type of target list that will be used to filter the users.
     * @see TargetListType
     */
    public final String targetListTypeAsString() {
        return targetListType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Condition objects which would be applied together with an AND condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return A list of Condition objects which would be applied together with an AND condition.
     */
    public final List<Condition> conditions() {
        return conditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetListTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCondition)) {
            return false;
        }
        ListCondition other = (ListCondition) obj;
        return Objects.equals(targetListTypeAsString(), other.targetListTypeAsString())
                && hasConditions() == other.hasConditions() && Objects.equals(conditions(), other.conditions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCondition").add("TargetListType", targetListTypeAsString())
                .add("Conditions", hasConditions() ? conditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetListType":
            return Optional.ofNullable(clazz.cast(targetListTypeAsString()));
        case "Conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetListType", TARGET_LIST_TYPE_FIELD);
        map.put("Conditions", CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCondition, T> g) {
        return obj -> g.apply((ListCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListCondition> {
        /**
         * <p>
         * The type of target list that will be used to filter the users.
         * </p>
         * 
         * @param targetListType
         *        The type of target list that will be used to filter the users.
         * @see TargetListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetListType
         */
        Builder targetListType(String targetListType);

        /**
         * <p>
         * The type of target list that will be used to filter the users.
         * </p>
         * 
         * @param targetListType
         *        The type of target list that will be used to filter the users.
         * @see TargetListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetListType
         */
        Builder targetListType(TargetListType targetListType);

        /**
         * <p>
         * A list of Condition objects which would be applied together with an AND condition.
         * </p>
         * 
         * @param conditions
         *        A list of Condition objects which would be applied together with an AND condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<Condition> conditions);

        /**
         * <p>
         * A list of Condition objects which would be applied together with an AND condition.
         * </p>
         * 
         * @param conditions
         *        A list of Condition objects which would be applied together with an AND condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Condition... conditions);

        /**
         * <p>
         * A list of Condition objects which would be applied together with an AND condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.Condition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.Condition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.Condition.Builder#build()} is called immediately and its
         * result is passed to {@link #conditions(List<Condition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.Condition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(java.util.Collection<Condition>)
         */
        Builder conditions(Consumer<Condition.Builder>... conditions);
    }

    static final class BuilderImpl implements Builder {
        private String targetListType;

        private List<Condition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCondition model) {
            targetListType(model.targetListType);
            conditions(model.conditions);
        }

        public final String getTargetListType() {
            return targetListType;
        }

        public final void setTargetListType(String targetListType) {
            this.targetListType = targetListType;
        }

        @Override
        public final Builder targetListType(String targetListType) {
            this.targetListType = targetListType;
            return this;
        }

        @Override
        public final Builder targetListType(TargetListType targetListType) {
            this.targetListType(targetListType == null ? null : targetListType.toString());
            return this;
        }

        public final List<Condition.Builder> getConditions() {
            List<Condition.Builder> result = ConditionsCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<Condition.BuilderImpl> conditions) {
            this.conditions = ConditionsCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<Condition> conditions) {
            this.conditions = ConditionsCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Condition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<Condition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> Condition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCondition build() {
            return new ListCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
