/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of Flow Modules an AI Agent can invoke as a tool
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowModule implements SdkPojo, Serializable, ToCopyableBuilder<FlowModule.Builder, FlowModule> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(FlowModule::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> FLOW_MODULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowModuleId").getter(getter(FlowModule::flowModuleId)).setter(setter(Builder::flowModuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowModuleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            FLOW_MODULE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String flowModuleId;

    private FlowModule(BuilderImpl builder) {
        this.type = builder.type;
        this.flowModuleId = builder.flowModuleId;
    }

    /**
     * <p>
     * Only Type we support is MCP.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowModuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Only Type we support is MCP.
     * @see FlowModuleType
     */
    public final FlowModuleType type() {
        return FlowModuleType.fromValue(type);
    }

    /**
     * <p>
     * Only Type we support is MCP.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowModuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Only Type we support is MCP.
     * @see FlowModuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * If of Flow Modules invocable as tool
     * </p>
     * 
     * @return If of Flow Modules invocable as tool
     */
    public final String flowModuleId() {
        return flowModuleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flowModuleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowModule)) {
            return false;
        }
        FlowModule other = (FlowModule) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(flowModuleId(), other.flowModuleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowModule").add("Type", typeAsString()).add("FlowModuleId", flowModuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "FlowModuleId":
            return Optional.ofNullable(clazz.cast(flowModuleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("FlowModuleId", FLOW_MODULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowModule, T> g) {
        return obj -> g.apply((FlowModule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowModule> {
        /**
         * <p>
         * Only Type we support is MCP.
         * </p>
         * 
         * @param type
         *        Only Type we support is MCP.
         * @see FlowModuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowModuleType
         */
        Builder type(String type);

        /**
         * <p>
         * Only Type we support is MCP.
         * </p>
         * 
         * @param type
         *        Only Type we support is MCP.
         * @see FlowModuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowModuleType
         */
        Builder type(FlowModuleType type);

        /**
         * <p>
         * If of Flow Modules invocable as tool
         * </p>
         * 
         * @param flowModuleId
         *        If of Flow Modules invocable as tool
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowModuleId(String flowModuleId);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String flowModuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowModule model) {
            type(model.type);
            flowModuleId(model.flowModuleId);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowModuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFlowModuleId() {
            return flowModuleId;
        }

        public final void setFlowModuleId(String flowModuleId) {
            this.flowModuleId = flowModuleId;
        }

        @Override
        public final Builder flowModuleId(String flowModuleId) {
            this.flowModuleId = flowModuleId;
            return this;
        }

        @Override
        public FlowModule build() {
            return new FlowModule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
