/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The milliseconds offset for transcript reference in suggested answer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationSuggestedAnswerTranscriptMillisecondOffsets
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<EvaluationSuggestedAnswerTranscriptMillisecondOffsets.Builder, EvaluationSuggestedAnswerTranscriptMillisecondOffsets> {
    private static final SdkField<Integer> BEGIN_OFFSET_MILLIS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffsetMillis")
            .getter(getter(EvaluationSuggestedAnswerTranscriptMillisecondOffsets::beginOffsetMillis))
            .setter(setter(Builder::beginOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_MILLIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer beginOffsetMillis;

    private EvaluationSuggestedAnswerTranscriptMillisecondOffsets(BuilderImpl builder) {
        this.beginOffsetMillis = builder.beginOffsetMillis;
    }

    /**
     * <p>
     * Offset in milliseconds from the beginning of the transcript.
     * </p>
     * 
     * @return Offset in milliseconds from the beginning of the transcript.
     */
    public final Integer beginOffsetMillis() {
        return beginOffsetMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginOffsetMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSuggestedAnswerTranscriptMillisecondOffsets)) {
            return false;
        }
        EvaluationSuggestedAnswerTranscriptMillisecondOffsets other = (EvaluationSuggestedAnswerTranscriptMillisecondOffsets) obj;
        return Objects.equals(beginOffsetMillis(), other.beginOffsetMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationSuggestedAnswerTranscriptMillisecondOffsets")
                .add("BeginOffsetMillis", beginOffsetMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BeginOffsetMillis":
            return Optional.ofNullable(clazz.cast(beginOffsetMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BeginOffsetMillis", BEGIN_OFFSET_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSuggestedAnswerTranscriptMillisecondOffsets, T> g) {
        return obj -> g.apply((EvaluationSuggestedAnswerTranscriptMillisecondOffsets) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationSuggestedAnswerTranscriptMillisecondOffsets> {
        /**
         * <p>
         * Offset in milliseconds from the beginning of the transcript.
         * </p>
         * 
         * @param beginOffsetMillis
         *        Offset in milliseconds from the beginning of the transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffsetMillis(Integer beginOffsetMillis);
    }

    static final class BuilderImpl implements Builder {
        private Integer beginOffsetMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSuggestedAnswerTranscriptMillisecondOffsets model) {
            beginOffsetMillis(model.beginOffsetMillis);
        }

        public final Integer getBeginOffsetMillis() {
            return beginOffsetMillis;
        }

        public final void setBeginOffsetMillis(Integer beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Integer beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        @Override
        public EvaluationSuggestedAnswerTranscriptMillisecondOffsets build() {
            return new EvaluationSuggestedAnswerTranscriptMillisecondOffsets(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
