/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of evaluation obtained from the search operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationSearchSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationSearchSummary.Builder, EvaluationSearchSummary> {
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationId").getter(getter(EvaluationSearchSummary::evaluationId))
            .setter(setter(Builder::evaluationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationId").build()).build();

    private static final SdkField<String> EVALUATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationArn").getter(getter(EvaluationSearchSummary::evaluationArn))
            .setter(setter(Builder::evaluationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationArn").build()).build();

    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormId").getter(getter(EvaluationSearchSummary::evaluationFormId))
            .setter(setter(Builder::evaluationFormId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()).build();

    private static final SdkField<Integer> EVALUATION_FORM_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationFormVersion").getter(getter(EvaluationSearchSummary::evaluationFormVersion))
            .setter(setter(Builder::evaluationFormVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormVersion").build())
            .build();

    private static final SdkField<String> EVALUATION_FORM_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormTitle").getter(getter(EvaluationSearchSummary::evaluationFormTitle))
            .setter(setter(Builder::evaluationFormTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormTitle").build())
            .build();

    private static final SdkField<EvaluationSearchMetadata> METADATA_FIELD = SdkField
            .<EvaluationSearchMetadata> builder(MarshallingType.SDK_POJO).memberName("Metadata")
            .getter(getter(EvaluationSearchSummary::metadata)).setter(setter(Builder::metadata))
            .constructor(EvaluationSearchMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EvaluationSearchSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationType").getter(getter(EvaluationSearchSummary::evaluationTypeAsString))
            .setter(setter(Builder::evaluationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(EvaluationSearchSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(EvaluationSearchSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(EvaluationSearchSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ID_FIELD,
            EVALUATION_ARN_FIELD, EVALUATION_FORM_ID_FIELD, EVALUATION_FORM_VERSION_FIELD, EVALUATION_FORM_TITLE_FIELD,
            METADATA_FIELD, STATUS_FIELD, EVALUATION_TYPE_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String evaluationId;

    private final String evaluationArn;

    private final String evaluationFormId;

    private final Integer evaluationFormVersion;

    private final String evaluationFormTitle;

    private final EvaluationSearchMetadata metadata;

    private final String status;

    private final String evaluationType;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final Map<String, String> tags;

    private EvaluationSearchSummary(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
        this.evaluationArn = builder.evaluationArn;
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormVersion = builder.evaluationFormVersion;
        this.evaluationFormTitle = builder.evaluationFormTitle;
        this.metadata = builder.metadata;
        this.status = builder.status;
        this.evaluationType = builder.evaluationType;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique identifier for the contact evaluation.
     * </p>
     * 
     * @return A unique identifier for the contact evaluation.
     */
    public final String evaluationId() {
        return evaluationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the contact evaluation resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the contact evaluation resource.
     */
    public final String evaluationArn() {
        return evaluationArn;
    }

    /**
     * <p>
     * The unique identifier for the evaluation form.
     * </p>
     * 
     * @return The unique identifier for the evaluation form.
     */
    public final String evaluationFormId() {
        return evaluationFormId;
    }

    /**
     * <p>
     * A version of the evaluation form.
     * </p>
     * 
     * @return A version of the evaluation form.
     */
    public final Integer evaluationFormVersion() {
        return evaluationFormVersion;
    }

    /**
     * <p>
     * Title of the evaluation form.
     * </p>
     * 
     * @return Title of the evaluation form.
     */
    public final String evaluationFormTitle() {
        return evaluationFormTitle;
    }

    /**
     * <p>
     * Summary information about the evaluation search.
     * </p>
     * 
     * @return Summary information about the evaluation search.
     */
    public final EvaluationSearchMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The status of the evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the evaluation.
     * @see EvaluationStatus
     */
    public final EvaluationStatus status() {
        return EvaluationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the evaluation.
     * @see EvaluationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Type of the evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationType}
     * will return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationTypeAsString}.
     * </p>
     * 
     * @return Type of the evaluation.
     * @see EvaluationType
     */
    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(evaluationType);
    }

    /**
     * <p>
     * Type of the evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationType}
     * will return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationTypeAsString}.
     * </p>
     * 
     * @return Type of the evaluation.
     * @see EvaluationType
     */
    public final String evaluationTypeAsString() {
        return evaluationType;
    }

    /**
     * <p>
     * The date and time when the evaluation was created, in UTC time.
     * </p>
     * 
     * @return The date and time when the evaluation was created, in UTC time.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time when the evaluation was modified last time, in UTC time.
     * </p>
     * 
     * @return The date and time when the evaluation was modified last time, in UTC time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "Tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationArn());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormVersion());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormTitle());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSearchSummary)) {
            return false;
        }
        EvaluationSearchSummary other = (EvaluationSearchSummary) obj;
        return Objects.equals(evaluationId(), other.evaluationId()) && Objects.equals(evaluationArn(), other.evaluationArn())
                && Objects.equals(evaluationFormId(), other.evaluationFormId())
                && Objects.equals(evaluationFormVersion(), other.evaluationFormVersion())
                && Objects.equals(evaluationFormTitle(), other.evaluationFormTitle())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(evaluationTypeAsString(), other.evaluationTypeAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationSearchSummary").add("EvaluationId", evaluationId())
                .add("EvaluationArn", evaluationArn()).add("EvaluationFormId", evaluationFormId())
                .add("EvaluationFormVersion", evaluationFormVersion()).add("EvaluationFormTitle", evaluationFormTitle())
                .add("Metadata", metadata()).add("Status", statusAsString()).add("EvaluationType", evaluationTypeAsString())
                .add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.ofNullable(clazz.cast(evaluationId()));
        case "EvaluationArn":
            return Optional.ofNullable(clazz.cast(evaluationArn()));
        case "EvaluationFormId":
            return Optional.ofNullable(clazz.cast(evaluationFormId()));
        case "EvaluationFormVersion":
            return Optional.ofNullable(clazz.cast(evaluationFormVersion()));
        case "EvaluationFormTitle":
            return Optional.ofNullable(clazz.cast(evaluationFormTitle()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "EvaluationType":
            return Optional.ofNullable(clazz.cast(evaluationTypeAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EvaluationId", EVALUATION_ID_FIELD);
        map.put("EvaluationArn", EVALUATION_ARN_FIELD);
        map.put("EvaluationFormId", EVALUATION_FORM_ID_FIELD);
        map.put("EvaluationFormVersion", EVALUATION_FORM_VERSION_FIELD);
        map.put("EvaluationFormTitle", EVALUATION_FORM_TITLE_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("EvaluationType", EVALUATION_TYPE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSearchSummary, T> g) {
        return obj -> g.apply((EvaluationSearchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationSearchSummary> {
        /**
         * <p>
         * A unique identifier for the contact evaluation.
         * </p>
         * 
         * @param evaluationId
         *        A unique identifier for the contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the contact evaluation resource.
         * </p>
         * 
         * @param evaluationArn
         *        The Amazon Resource Name (ARN) for the contact evaluation resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationArn(String evaluationArn);

        /**
         * <p>
         * The unique identifier for the evaluation form.
         * </p>
         * 
         * @param evaluationFormId
         *        The unique identifier for the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormId(String evaluationFormId);

        /**
         * <p>
         * A version of the evaluation form.
         * </p>
         * 
         * @param evaluationFormVersion
         *        A version of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormVersion(Integer evaluationFormVersion);

        /**
         * <p>
         * Title of the evaluation form.
         * </p>
         * 
         * @param evaluationFormTitle
         *        Title of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormTitle(String evaluationFormTitle);

        /**
         * <p>
         * Summary information about the evaluation search.
         * </p>
         * 
         * @param metadata
         *        Summary information about the evaluation search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(EvaluationSearchMetadata metadata);

        /**
         * <p>
         * Summary information about the evaluation search.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationSearchMetadata.Builder}
         * avoiding the need to create one manually via {@link EvaluationSearchMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationSearchMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #metadata(EvaluationSearchMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link EvaluationSearchMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(EvaluationSearchMetadata)
         */
        default Builder metadata(Consumer<EvaluationSearchMetadata.Builder> metadata) {
            return metadata(EvaluationSearchMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The status of the evaluation.
         * </p>
         * 
         * @param status
         *        The status of the evaluation.
         * @see EvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the evaluation.
         * </p>
         * 
         * @param status
         *        The status of the evaluation.
         * @see EvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationStatus
         */
        Builder status(EvaluationStatus status);

        /**
         * <p>
         * Type of the evaluation.
         * </p>
         * 
         * @param evaluationType
         *        Type of the evaluation.
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluationType(String evaluationType);

        /**
         * <p>
         * Type of the evaluation.
         * </p>
         * 
         * @param evaluationType
         *        Type of the evaluation.
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluationType(EvaluationType evaluationType);

        /**
         * <p>
         * The date and time when the evaluation was created, in UTC time.
         * </p>
         * 
         * @param createdTime
         *        The date and time when the evaluation was created, in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The date and time when the evaluation was modified last time, in UTC time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time when the evaluation was modified last time, in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "Tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "Tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationId;

        private String evaluationArn;

        private String evaluationFormId;

        private Integer evaluationFormVersion;

        private String evaluationFormTitle;

        private EvaluationSearchMetadata metadata;

        private String status;

        private String evaluationType;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSearchSummary model) {
            evaluationId(model.evaluationId);
            evaluationArn(model.evaluationArn);
            evaluationFormId(model.evaluationFormId);
            evaluationFormVersion(model.evaluationFormVersion);
            evaluationFormTitle(model.evaluationFormTitle);
            metadata(model.metadata);
            status(model.status);
            evaluationType(model.evaluationType);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            tags(model.tags);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final String getEvaluationArn() {
            return evaluationArn;
        }

        public final void setEvaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
        }

        @Override
        public final Builder evaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
            return this;
        }

        public final String getEvaluationFormId() {
            return evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final Integer getEvaluationFormVersion() {
            return evaluationFormVersion;
        }

        public final void setEvaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
        }

        @Override
        public final Builder evaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
            return this;
        }

        public final String getEvaluationFormTitle() {
            return evaluationFormTitle;
        }

        public final void setEvaluationFormTitle(String evaluationFormTitle) {
            this.evaluationFormTitle = evaluationFormTitle;
        }

        @Override
        public final Builder evaluationFormTitle(String evaluationFormTitle) {
            this.evaluationFormTitle = evaluationFormTitle;
            return this;
        }

        public final EvaluationSearchMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(EvaluationSearchMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(EvaluationSearchMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEvaluationType() {
            return evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public EvaluationSearchSummary build() {
            return new EvaluationSearchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
