/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about scores of a contact evaluation item (section or question).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationScore implements SdkPojo, Serializable, ToCopyableBuilder<EvaluationScore.Builder, EvaluationScore> {
    private static final SdkField<Double> PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Percentage").getter(getter(EvaluationScore::percentage)).setter(setter(Builder::percentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentage").build()).build();

    private static final SdkField<Boolean> NOT_APPLICABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NotApplicable").getter(getter(EvaluationScore::notApplicable)).setter(setter(Builder::notApplicable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotApplicable").build()).build();

    private static final SdkField<Boolean> AUTOMATIC_FAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutomaticFail").getter(getter(EvaluationScore::automaticFail)).setter(setter(Builder::automaticFail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFail").build()).build();

    private static final SdkField<Double> APPLIED_WEIGHT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AppliedWeight").getter(getter(EvaluationScore::appliedWeight)).setter(setter(Builder::appliedWeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedWeight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTAGE_FIELD,
            NOT_APPLICABLE_FIELD, AUTOMATIC_FAIL_FIELD, APPLIED_WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double percentage;

    private final Boolean notApplicable;

    private final Boolean automaticFail;

    private final Double appliedWeight;

    private EvaluationScore(BuilderImpl builder) {
        this.percentage = builder.percentage;
        this.notApplicable = builder.notApplicable;
        this.automaticFail = builder.automaticFail;
        this.appliedWeight = builder.appliedWeight;
    }

    /**
     * <p>
     * The score percentage for an item in a contact evaluation.
     * </p>
     * 
     * @return The score percentage for an item in a contact evaluation.
     */
    public final Double percentage() {
        return percentage;
    }

    /**
     * <p>
     * The flag to mark the item as not applicable for scoring.
     * </p>
     * 
     * @return The flag to mark the item as not applicable for scoring.
     */
    public final Boolean notApplicable() {
        return notApplicable;
    }

    /**
     * <p>
     * The flag that marks the item as automatic fail. If the item or a child item gets an automatic fail answer, this
     * flag will be true.
     * </p>
     * 
     * @return The flag that marks the item as automatic fail. If the item or a child item gets an automatic fail
     *         answer, this flag will be true.
     */
    public final Boolean automaticFail() {
        return automaticFail;
    }

    /**
     * <p>
     * Weight applied to this evaluation score.
     * </p>
     * 
     * @return Weight applied to this evaluation score.
     */
    public final Double appliedWeight() {
        return appliedWeight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(percentage());
        hashCode = 31 * hashCode + Objects.hashCode(notApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFail());
        hashCode = 31 * hashCode + Objects.hashCode(appliedWeight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationScore)) {
            return false;
        }
        EvaluationScore other = (EvaluationScore) obj;
        return Objects.equals(percentage(), other.percentage()) && Objects.equals(notApplicable(), other.notApplicable())
                && Objects.equals(automaticFail(), other.automaticFail())
                && Objects.equals(appliedWeight(), other.appliedWeight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationScore").add("Percentage", percentage()).add("NotApplicable", notApplicable())
                .add("AutomaticFail", automaticFail()).add("AppliedWeight", appliedWeight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Percentage":
            return Optional.ofNullable(clazz.cast(percentage()));
        case "NotApplicable":
            return Optional.ofNullable(clazz.cast(notApplicable()));
        case "AutomaticFail":
            return Optional.ofNullable(clazz.cast(automaticFail()));
        case "AppliedWeight":
            return Optional.ofNullable(clazz.cast(appliedWeight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Percentage", PERCENTAGE_FIELD);
        map.put("NotApplicable", NOT_APPLICABLE_FIELD);
        map.put("AutomaticFail", AUTOMATIC_FAIL_FIELD);
        map.put("AppliedWeight", APPLIED_WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationScore, T> g) {
        return obj -> g.apply((EvaluationScore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationScore> {
        /**
         * <p>
         * The score percentage for an item in a contact evaluation.
         * </p>
         * 
         * @param percentage
         *        The score percentage for an item in a contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentage(Double percentage);

        /**
         * <p>
         * The flag to mark the item as not applicable for scoring.
         * </p>
         * 
         * @param notApplicable
         *        The flag to mark the item as not applicable for scoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notApplicable(Boolean notApplicable);

        /**
         * <p>
         * The flag that marks the item as automatic fail. If the item or a child item gets an automatic fail answer,
         * this flag will be true.
         * </p>
         * 
         * @param automaticFail
         *        The flag that marks the item as automatic fail. If the item or a child item gets an automatic fail
         *        answer, this flag will be true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticFail(Boolean automaticFail);

        /**
         * <p>
         * Weight applied to this evaluation score.
         * </p>
         * 
         * @param appliedWeight
         *        Weight applied to this evaluation score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedWeight(Double appliedWeight);
    }

    static final class BuilderImpl implements Builder {
        private Double percentage;

        private Boolean notApplicable;

        private Boolean automaticFail;

        private Double appliedWeight;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationScore model) {
            percentage(model.percentage);
            notApplicable(model.notApplicable);
            automaticFail(model.automaticFail);
            appliedWeight(model.appliedWeight);
        }

        public final Double getPercentage() {
            return percentage;
        }

        public final void setPercentage(Double percentage) {
            this.percentage = percentage;
        }

        @Override
        public final Builder percentage(Double percentage) {
            this.percentage = percentage;
            return this;
        }

        public final Boolean getNotApplicable() {
            return notApplicable;
        }

        public final void setNotApplicable(Boolean notApplicable) {
            this.notApplicable = notApplicable;
        }

        @Override
        public final Builder notApplicable(Boolean notApplicable) {
            this.notApplicable = notApplicable;
            return this;
        }

        public final Boolean getAutomaticFail() {
            return automaticFail;
        }

        public final void setAutomaticFail(Boolean automaticFail) {
            this.automaticFail = automaticFail;
        }

        @Override
        public final Builder automaticFail(Boolean automaticFail) {
            this.automaticFail = automaticFail;
            return this;
        }

        public final Double getAppliedWeight() {
            return appliedWeight;
        }

        public final void setAppliedWeight(Double appliedWeight) {
            this.appliedWeight = appliedWeight;
        }

        @Override
        public final Builder appliedWeight(Double appliedWeight) {
            this.appliedWeight = appliedWeight;
            return this;
        }

        @Override
        public EvaluationScore build() {
            return new EvaluationScore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
