/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the options in single select questions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormSingleSelectQuestionProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormSingleSelectQuestionProperties.Builder, EvaluationFormSingleSelectQuestionProperties> {
    private static final SdkField<List<EvaluationFormSingleSelectQuestionOption>> OPTIONS_FIELD = SdkField
            .<List<EvaluationFormSingleSelectQuestionOption>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(EvaluationFormSingleSelectQuestionProperties::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormSingleSelectQuestionOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormSingleSelectQuestionOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DISPLAY_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayAs").getter(getter(EvaluationFormSingleSelectQuestionProperties::displayAsAsString))
            .setter(setter(Builder::displayAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayAs").build()).build();

    private static final SdkField<EvaluationFormSingleSelectQuestionAutomation> AUTOMATION_FIELD = SdkField
            .<EvaluationFormSingleSelectQuestionAutomation> builder(MarshallingType.SDK_POJO).memberName("Automation")
            .getter(getter(EvaluationFormSingleSelectQuestionProperties::automation)).setter(setter(Builder::automation))
            .constructor(EvaluationFormSingleSelectQuestionAutomation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD,
            DISPLAY_AS_FIELD, AUTOMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EvaluationFormSingleSelectQuestionOption> options;

    private final String displayAs;

    private final EvaluationFormSingleSelectQuestionAutomation automation;

    private EvaluationFormSingleSelectQuestionProperties(BuilderImpl builder) {
        this.options = builder.options;
        this.displayAs = builder.displayAs;
        this.automation = builder.automation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The answer options of the single select question.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The answer options of the single select question.
     */
    public final List<EvaluationFormSingleSelectQuestionOption> options() {
        return options;
    }

    /**
     * <p>
     * The display mode of the single select question.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #displayAs} will
     * return {@link EvaluationFormSingleSelectQuestionDisplayMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #displayAsAsString}.
     * </p>
     * 
     * @return The display mode of the single select question.
     * @see EvaluationFormSingleSelectQuestionDisplayMode
     */
    public final EvaluationFormSingleSelectQuestionDisplayMode displayAs() {
        return EvaluationFormSingleSelectQuestionDisplayMode.fromValue(displayAs);
    }

    /**
     * <p>
     * The display mode of the single select question.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #displayAs} will
     * return {@link EvaluationFormSingleSelectQuestionDisplayMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #displayAsAsString}.
     * </p>
     * 
     * @return The display mode of the single select question.
     * @see EvaluationFormSingleSelectQuestionDisplayMode
     */
    public final String displayAsAsString() {
        return displayAs;
    }

    /**
     * <p>
     * The display mode of the single select question.
     * </p>
     * 
     * @return The display mode of the single select question.
     */
    public final EvaluationFormSingleSelectQuestionAutomation automation() {
        return automation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(displayAsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(automation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormSingleSelectQuestionProperties)) {
            return false;
        }
        EvaluationFormSingleSelectQuestionProperties other = (EvaluationFormSingleSelectQuestionProperties) obj;
        return hasOptions() == other.hasOptions() && Objects.equals(options(), other.options())
                && Objects.equals(displayAsAsString(), other.displayAsAsString())
                && Objects.equals(automation(), other.automation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormSingleSelectQuestionProperties").add("Options", hasOptions() ? options() : null)
                .add("DisplayAs", displayAsAsString()).add("Automation", automation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "DisplayAs":
            return Optional.ofNullable(clazz.cast(displayAsAsString()));
        case "Automation":
            return Optional.ofNullable(clazz.cast(automation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Options", OPTIONS_FIELD);
        map.put("DisplayAs", DISPLAY_AS_FIELD);
        map.put("Automation", AUTOMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormSingleSelectQuestionProperties, T> g) {
        return obj -> g.apply((EvaluationFormSingleSelectQuestionProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormSingleSelectQuestionProperties> {
        /**
         * <p>
         * The answer options of the single select question.
         * </p>
         * 
         * @param options
         *        The answer options of the single select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<EvaluationFormSingleSelectQuestionOption> options);

        /**
         * <p>
         * The answer options of the single select question.
         * </p>
         * 
         * @param options
         *        The answer options of the single select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(EvaluationFormSingleSelectQuestionOption... options);

        /**
         * <p>
         * The answer options of the single select question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionOption.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionOption.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #options(List<EvaluationFormSingleSelectQuestionOption>)}.
         * 
         * @param options
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(java.util.Collection<EvaluationFormSingleSelectQuestionOption>)
         */
        Builder options(Consumer<EvaluationFormSingleSelectQuestionOption.Builder>... options);

        /**
         * <p>
         * The display mode of the single select question.
         * </p>
         * 
         * @param displayAs
         *        The display mode of the single select question.
         * @see EvaluationFormSingleSelectQuestionDisplayMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormSingleSelectQuestionDisplayMode
         */
        Builder displayAs(String displayAs);

        /**
         * <p>
         * The display mode of the single select question.
         * </p>
         * 
         * @param displayAs
         *        The display mode of the single select question.
         * @see EvaluationFormSingleSelectQuestionDisplayMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormSingleSelectQuestionDisplayMode
         */
        Builder displayAs(EvaluationFormSingleSelectQuestionDisplayMode displayAs);

        /**
         * <p>
         * The display mode of the single select question.
         * </p>
         * 
         * @param automation
         *        The display mode of the single select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automation(EvaluationFormSingleSelectQuestionAutomation automation);

        /**
         * <p>
         * The display mode of the single select question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormSingleSelectQuestionAutomation.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormSingleSelectQuestionAutomation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormSingleSelectQuestionAutomation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #automation(EvaluationFormSingleSelectQuestionAutomation)}.
         * 
         * @param automation
         *        a consumer that will call methods on {@link EvaluationFormSingleSelectQuestionAutomation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automation(EvaluationFormSingleSelectQuestionAutomation)
         */
        default Builder automation(Consumer<EvaluationFormSingleSelectQuestionAutomation.Builder> automation) {
            return automation(EvaluationFormSingleSelectQuestionAutomation.builder().applyMutation(automation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<EvaluationFormSingleSelectQuestionOption> options = DefaultSdkAutoConstructList.getInstance();

        private String displayAs;

        private EvaluationFormSingleSelectQuestionAutomation automation;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormSingleSelectQuestionProperties model) {
            options(model.options);
            displayAs(model.displayAs);
            automation(model.automation);
        }

        public final List<EvaluationFormSingleSelectQuestionOption.Builder> getOptions() {
            List<EvaluationFormSingleSelectQuestionOption.Builder> result = EvaluationFormSingleSelectQuestionOptionListCopier
                    .copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<EvaluationFormSingleSelectQuestionOption.BuilderImpl> options) {
            this.options = EvaluationFormSingleSelectQuestionOptionListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<EvaluationFormSingleSelectQuestionOption> options) {
            this.options = EvaluationFormSingleSelectQuestionOptionListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(EvaluationFormSingleSelectQuestionOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<EvaluationFormSingleSelectQuestionOption.Builder>... options) {
            options(Stream.of(options).map(c -> EvaluationFormSingleSelectQuestionOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDisplayAs() {
            return displayAs;
        }

        public final void setDisplayAs(String displayAs) {
            this.displayAs = displayAs;
        }

        @Override
        public final Builder displayAs(String displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @Override
        public final Builder displayAs(EvaluationFormSingleSelectQuestionDisplayMode displayAs) {
            this.displayAs(displayAs == null ? null : displayAs.toString());
            return this;
        }

        public final EvaluationFormSingleSelectQuestionAutomation.Builder getAutomation() {
            return automation != null ? automation.toBuilder() : null;
        }

        public final void setAutomation(EvaluationFormSingleSelectQuestionAutomation.BuilderImpl automation) {
            this.automation = automation != null ? automation.build() : null;
        }

        @Override
        public final Builder automation(EvaluationFormSingleSelectQuestionAutomation automation) {
            this.automation = automation;
            return this;
        }

        @Override
        public EvaluationFormSingleSelectQuestionProperties build() {
            return new EvaluationFormSingleSelectQuestionProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
