/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An automation option for a multi-select question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormMultiSelectQuestionAutomationOption
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<EvaluationFormMultiSelectQuestionAutomationOption.Builder, EvaluationFormMultiSelectQuestionAutomationOption> {
    private static final SdkField<MultiSelectQuestionRuleCategoryAutomation> RULE_CATEGORY_FIELD = SdkField
            .<MultiSelectQuestionRuleCategoryAutomation> builder(MarshallingType.SDK_POJO).memberName("RuleCategory")
            .getter(getter(EvaluationFormMultiSelectQuestionAutomationOption::ruleCategory))
            .setter(setter(Builder::ruleCategory)).constructor(MultiSelectQuestionRuleCategoryAutomation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MultiSelectQuestionRuleCategoryAutomation ruleCategory;

    private final Type type;

    private EvaluationFormMultiSelectQuestionAutomationOption(BuilderImpl builder) {
        this.ruleCategory = builder.ruleCategory;
        this.type = builder.type;
    }

    /**
     * <p>
     * Rule category configuration for this automation option.
     * </p>
     * 
     * @return Rule category configuration for this automation option.
     */
    public final MultiSelectQuestionRuleCategoryAutomation ruleCategory() {
        return ruleCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleCategory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormMultiSelectQuestionAutomationOption)) {
            return false;
        }
        EvaluationFormMultiSelectQuestionAutomationOption other = (EvaluationFormMultiSelectQuestionAutomationOption) obj;
        return Objects.equals(ruleCategory(), other.ruleCategory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormMultiSelectQuestionAutomationOption").add("RuleCategory", ruleCategory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleCategory":
            return Optional.ofNullable(clazz.cast(ruleCategory()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #ruleCategory()} initialized to the given value.
     *
     * <p>
     * Rule category configuration for this automation option.
     * </p>
     * 
     * @param ruleCategory
     *        Rule category configuration for this automation option.
     */
    public static EvaluationFormMultiSelectQuestionAutomationOption fromRuleCategory(
            MultiSelectQuestionRuleCategoryAutomation ruleCategory) {
        return builder().ruleCategory(ruleCategory).build();
    }

    /**
     * Create an instance of this class with {@link #ruleCategory()} initialized to the given value.
     *
     * <p>
     * Rule category configuration for this automation option.
     * </p>
     * 
     * @param ruleCategory
     *        Rule category configuration for this automation option.
     */
    public static EvaluationFormMultiSelectQuestionAutomationOption fromRuleCategory(
            Consumer<MultiSelectQuestionRuleCategoryAutomation.Builder> ruleCategory) {
        MultiSelectQuestionRuleCategoryAutomation.Builder builder = MultiSelectQuestionRuleCategoryAutomation.builder();
        ruleCategory.accept(builder);
        return fromRuleCategory(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleCategory", RULE_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormMultiSelectQuestionAutomationOption, T> g) {
        return obj -> g.apply((EvaluationFormMultiSelectQuestionAutomationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormMultiSelectQuestionAutomationOption> {
        /**
         * <p>
         * Rule category configuration for this automation option.
         * </p>
         * 
         * @param ruleCategory
         *        Rule category configuration for this automation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleCategory(MultiSelectQuestionRuleCategoryAutomation ruleCategory);

        /**
         * <p>
         * Rule category configuration for this automation option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MultiSelectQuestionRuleCategoryAutomation.Builder} avoiding the need to create one manually via
         * {@link MultiSelectQuestionRuleCategoryAutomation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiSelectQuestionRuleCategoryAutomation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #ruleCategory(MultiSelectQuestionRuleCategoryAutomation)}.
         * 
         * @param ruleCategory
         *        a consumer that will call methods on {@link MultiSelectQuestionRuleCategoryAutomation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleCategory(MultiSelectQuestionRuleCategoryAutomation)
         */
        default Builder ruleCategory(Consumer<MultiSelectQuestionRuleCategoryAutomation.Builder> ruleCategory) {
            return ruleCategory(MultiSelectQuestionRuleCategoryAutomation.builder().applyMutation(ruleCategory).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MultiSelectQuestionRuleCategoryAutomation ruleCategory;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormMultiSelectQuestionAutomationOption model) {
            ruleCategory(model.ruleCategory);
        }

        public final MultiSelectQuestionRuleCategoryAutomation.Builder getRuleCategory() {
            return ruleCategory != null ? ruleCategory.toBuilder() : null;
        }

        public final void setRuleCategory(MultiSelectQuestionRuleCategoryAutomation.BuilderImpl ruleCategory) {
            Object oldValue = this.ruleCategory;
            this.ruleCategory = ruleCategory != null ? ruleCategory.build() : null;
            handleUnionValueChange(Type.RULE_CATEGORY, oldValue, this.ruleCategory);
        }

        @Override
        public final Builder ruleCategory(MultiSelectQuestionRuleCategoryAutomation ruleCategory) {
            Object oldValue = this.ruleCategory;
            this.ruleCategory = ruleCategory;
            handleUnionValueChange(Type.RULE_CATEGORY, oldValue, this.ruleCategory);
            return this;
        }

        @Override
        public EvaluationFormMultiSelectQuestionAutomationOption build() {
            return new EvaluationFormMultiSelectQuestionAutomationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationFormMultiSelectQuestionAutomationOption#type()
     */
    public enum Type {
        RULE_CATEGORY,

        UNKNOWN_TO_SDK_VERSION
    }
}
