/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Analysis details providing explanation for Contact Lens automation decision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationContactLensAnswerAnalysisDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationContactLensAnswerAnalysisDetails.Builder, EvaluationContactLensAnswerAnalysisDetails> {
    private static final SdkField<List<EvaluationAutomationRuleCategory>> MATCHED_RULE_CATEGORIES_FIELD = SdkField
            .<List<EvaluationAutomationRuleCategory>> builder(MarshallingType.LIST)
            .memberName("MatchedRuleCategories")
            .getter(getter(EvaluationContactLensAnswerAnalysisDetails::matchedRuleCategories))
            .setter(setter(Builder::matchedRuleCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedRuleCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationAutomationRuleCategory> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationAutomationRuleCategory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MATCHED_RULE_CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EvaluationAutomationRuleCategory> matchedRuleCategories;

    private EvaluationContactLensAnswerAnalysisDetails(BuilderImpl builder) {
        this.matchedRuleCategories = builder.matchedRuleCategories;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchedRuleCategories property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMatchedRuleCategories() {
        return matchedRuleCategories != null && !(matchedRuleCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of match rule categories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchedRuleCategories} method.
     * </p>
     * 
     * @return A list of match rule categories.
     */
    public final List<EvaluationAutomationRuleCategory> matchedRuleCategories() {
        return matchedRuleCategories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchedRuleCategories() ? matchedRuleCategories() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationContactLensAnswerAnalysisDetails)) {
            return false;
        }
        EvaluationContactLensAnswerAnalysisDetails other = (EvaluationContactLensAnswerAnalysisDetails) obj;
        return hasMatchedRuleCategories() == other.hasMatchedRuleCategories()
                && Objects.equals(matchedRuleCategories(), other.matchedRuleCategories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationContactLensAnswerAnalysisDetails")
                .add("MatchedRuleCategories", hasMatchedRuleCategories() ? matchedRuleCategories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchedRuleCategories":
            return Optional.ofNullable(clazz.cast(matchedRuleCategories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MatchedRuleCategories", MATCHED_RULE_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationContactLensAnswerAnalysisDetails, T> g) {
        return obj -> g.apply((EvaluationContactLensAnswerAnalysisDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationContactLensAnswerAnalysisDetails> {
        /**
         * <p>
         * A list of match rule categories.
         * </p>
         * 
         * @param matchedRuleCategories
         *        A list of match rule categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedRuleCategories(Collection<EvaluationAutomationRuleCategory> matchedRuleCategories);

        /**
         * <p>
         * A list of match rule categories.
         * </p>
         * 
         * @param matchedRuleCategories
         *        A list of match rule categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedRuleCategories(EvaluationAutomationRuleCategory... matchedRuleCategories);

        /**
         * <p>
         * A list of match rule categories.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationAutomationRuleCategory.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationAutomationRuleCategory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationAutomationRuleCategory.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #matchedRuleCategories(List<EvaluationAutomationRuleCategory>)}.
         * 
         * @param matchedRuleCategories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationAutomationRuleCategory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchedRuleCategories(java.util.Collection<EvaluationAutomationRuleCategory>)
         */
        Builder matchedRuleCategories(Consumer<EvaluationAutomationRuleCategory.Builder>... matchedRuleCategories);
    }

    static final class BuilderImpl implements Builder {
        private List<EvaluationAutomationRuleCategory> matchedRuleCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationContactLensAnswerAnalysisDetails model) {
            matchedRuleCategories(model.matchedRuleCategories);
        }

        public final List<EvaluationAutomationRuleCategory.Builder> getMatchedRuleCategories() {
            List<EvaluationAutomationRuleCategory.Builder> result = EvaluationAutomationRuleCategoryListCopier
                    .copyToBuilder(this.matchedRuleCategories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchedRuleCategories(Collection<EvaluationAutomationRuleCategory.BuilderImpl> matchedRuleCategories) {
            this.matchedRuleCategories = EvaluationAutomationRuleCategoryListCopier.copyFromBuilder(matchedRuleCategories);
        }

        @Override
        public final Builder matchedRuleCategories(Collection<EvaluationAutomationRuleCategory> matchedRuleCategories) {
            this.matchedRuleCategories = EvaluationAutomationRuleCategoryListCopier.copy(matchedRuleCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRuleCategories(EvaluationAutomationRuleCategory... matchedRuleCategories) {
            matchedRuleCategories(Arrays.asList(matchedRuleCategories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRuleCategories(Consumer<EvaluationAutomationRuleCategory.Builder>... matchedRuleCategories) {
            matchedRuleCategories(Stream.of(matchedRuleCategories)
                    .map(c -> EvaluationAutomationRuleCategory.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EvaluationContactLensAnswerAnalysisDetails build() {
            return new EvaluationContactLensAnswerAnalysisDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
