/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateDataTableValuesRequest extends ConnectRequest implements
        ToCopyableBuilder<EvaluateDataTableValuesRequest.Builder, EvaluateDataTableValuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(EvaluateDataTableValuesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTableId").getter(getter(EvaluateDataTableValuesRequest::dataTableId))
            .setter(setter(Builder::dataTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()).build();

    private static final SdkField<List<DataTableValueEvaluationSet>> VALUES_FIELD = SdkField
            .<List<DataTableValueEvaluationSet>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(EvaluateDataTableValuesRequest::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataTableValueEvaluationSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataTableValueEvaluationSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(EvaluateDataTableValuesRequest::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(EvaluateDataTableValuesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(EvaluateDataTableValuesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DATA_TABLE_ID_FIELD, VALUES_FIELD, TIME_ZONE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String dataTableId;

    private final List<DataTableValueEvaluationSet> values;

    private final String timeZone;

    private final String nextToken;

    private final Integer maxResults;

    private EvaluateDataTableValuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.values = builder.values;
        this.timeZone = builder.timeZone;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Connect instance.
     * </p>
     * 
     * @return The unique identifier for the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
     * </p>
     * 
     * @return The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
     */
    public final String dataTableId() {
        return dataTableId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of value evaluation sets specifying which primary values and attributes to evaluate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of value evaluation sets specifying which primary values and attributes to evaluate.
     */
    public final List<DataTableValueEvaluationSet> values() {
        return values;
    }

    /**
     * <p>
     * Optional IANA timezone identifier to use when resolving time based dynamic values. Defaults to the data table
     * time zone if not provided.
     * </p>
     * 
     * @return Optional IANA timezone identifier to use when resolving time based dynamic values. Defaults to the data
     *         table time zone if not provided.
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of data table values to return in one page of results.
     * </p>
     * 
     * @return The maximum number of data table values to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateDataTableValuesRequest)) {
            return false;
        }
        EvaluateDataTableValuesRequest other = (EvaluateDataTableValuesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(dataTableId(), other.dataTableId())
                && hasValues() == other.hasValues() && Objects.equals(values(), other.values())
                && Objects.equals(timeZone(), other.timeZone()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateDataTableValuesRequest").add("InstanceId", instanceId())
                .add("DataTableId", dataTableId()).add("Values", hasValues() ? values() : null).add("TimeZone", timeZone())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DataTableId":
            return Optional.ofNullable(clazz.cast(dataTableId()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("TimeZone", TIME_ZONE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateDataTableValuesRequest, T> g) {
        return obj -> g.apply((EvaluateDataTableValuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateDataTableValuesRequest> {
        /**
         * <p>
         * The unique identifier for the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier for the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
         * </p>
         * 
         * @param dataTableId
         *        The unique identifier for the data table. Must also accept the table ARN with or without a version
         *        alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableId(String dataTableId);

        /**
         * <p>
         * A list of value evaluation sets specifying which primary values and attributes to evaluate.
         * </p>
         * 
         * @param values
         *        A list of value evaluation sets specifying which primary values and attributes to evaluate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<DataTableValueEvaluationSet> values);

        /**
         * <p>
         * A list of value evaluation sets specifying which primary values and attributes to evaluate.
         * </p>
         * 
         * @param values
         *        A list of value evaluation sets specifying which primary values and attributes to evaluate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(DataTableValueEvaluationSet... values);

        /**
         * <p>
         * A list of value evaluation sets specifying which primary values and attributes to evaluate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.DataTableValueEvaluationSet.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.DataTableValueEvaluationSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.DataTableValueEvaluationSet.Builder#build()} is called
         * immediately and its result is passed to {@link #values(List<DataTableValueEvaluationSet>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.DataTableValueEvaluationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<DataTableValueEvaluationSet>)
         */
        Builder values(Consumer<DataTableValueEvaluationSet.Builder>... values);

        /**
         * <p>
         * Optional IANA timezone identifier to use when resolving time based dynamic values. Defaults to the data table
         * time zone if not provided.
         * </p>
         * 
         * @param timeZone
         *        Optional IANA timezone identifier to use when resolving time based dynamic values. Defaults to the
         *        data table time zone if not provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of data table values to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of data table values to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String dataTableId;

        private List<DataTableValueEvaluationSet> values = DefaultSdkAutoConstructList.getInstance();

        private String timeZone;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateDataTableValuesRequest model) {
            super(model);
            instanceId(model.instanceId);
            dataTableId(model.dataTableId);
            values(model.values);
            timeZone(model.timeZone);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final List<DataTableValueEvaluationSet.Builder> getValues() {
            List<DataTableValueEvaluationSet.Builder> result = DataTableValueEvaluationSetListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<DataTableValueEvaluationSet.BuilderImpl> values) {
            this.values = DataTableValueEvaluationSetListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<DataTableValueEvaluationSet> values) {
            this.values = DataTableValueEvaluationSetListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(DataTableValueEvaluationSet... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<DataTableValueEvaluationSet.Builder>... values) {
            values(Stream.of(values).map(c -> DataTableValueEvaluationSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvaluateDataTableValuesRequest build() {
            return new EvaluateDataTableValuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
