/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateWorkspaceResponse extends ConnectResponse implements
        ToCopyableBuilder<DisassociateWorkspaceResponse.Builder, DisassociateWorkspaceResponse> {
    private static final SdkField<List<SuccessfulBatchAssociationSummary>> SUCCESSFUL_LIST_FIELD = SdkField
            .<List<SuccessfulBatchAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("SuccessfulList")
            .getter(getter(DisassociateWorkspaceResponse::successfulList))
            .setter(setter(Builder::successfulList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuccessfulBatchAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuccessfulBatchAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FailedBatchAssociationSummary>> FAILED_LIST_FIELD = SdkField
            .<List<FailedBatchAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("FailedList")
            .getter(getter(DisassociateWorkspaceResponse::failedList))
            .setter(setter(Builder::failedList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedBatchAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedBatchAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_LIST_FIELD,
            FAILED_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SuccessfulBatchAssociationSummary> successfulList;

    private final List<FailedBatchAssociationSummary> failedList;

    private DisassociateWorkspaceResponse(BuilderImpl builder) {
        super(builder);
        this.successfulList = builder.successfulList;
        this.failedList = builder.failedList;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfulList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuccessfulList() {
        return successfulList != null && !(successfulList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resources that were successfully disassociated from the workspace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfulList} method.
     * </p>
     * 
     * @return A list of resources that were successfully disassociated from the workspace.
     */
    public final List<SuccessfulBatchAssociationSummary> successfulList() {
        return successfulList;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailedList() {
        return failedList != null && !(failedList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resources that failed to be disassociated from the workspace, including error details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedList} method.
     * </p>
     * 
     * @return A list of resources that failed to be disassociated from the workspace, including error details.
     */
    public final List<FailedBatchAssociationSummary> failedList() {
        return failedList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulList() ? successfulList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedList() ? failedList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateWorkspaceResponse)) {
            return false;
        }
        DisassociateWorkspaceResponse other = (DisassociateWorkspaceResponse) obj;
        return hasSuccessfulList() == other.hasSuccessfulList() && Objects.equals(successfulList(), other.successfulList())
                && hasFailedList() == other.hasFailedList() && Objects.equals(failedList(), other.failedList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateWorkspaceResponse")
                .add("SuccessfulList", hasSuccessfulList() ? successfulList() : null)
                .add("FailedList", hasFailedList() ? failedList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulList":
            return Optional.ofNullable(clazz.cast(successfulList()));
        case "FailedList":
            return Optional.ofNullable(clazz.cast(failedList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SuccessfulList", SUCCESSFUL_LIST_FIELD);
        map.put("FailedList", FAILED_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateWorkspaceResponse, T> g) {
        return obj -> g.apply((DisassociateWorkspaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateWorkspaceResponse> {
        /**
         * <p>
         * A list of resources that were successfully disassociated from the workspace.
         * </p>
         * 
         * @param successfulList
         *        A list of resources that were successfully disassociated from the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulList(Collection<SuccessfulBatchAssociationSummary> successfulList);

        /**
         * <p>
         * A list of resources that were successfully disassociated from the workspace.
         * </p>
         * 
         * @param successfulList
         *        A list of resources that were successfully disassociated from the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulList(SuccessfulBatchAssociationSummary... successfulList);

        /**
         * <p>
         * A list of resources that were successfully disassociated from the workspace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.SuccessfulBatchAssociationSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.SuccessfulBatchAssociationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.SuccessfulBatchAssociationSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #successfulList(List<SuccessfulBatchAssociationSummary>)}.
         * 
         * @param successfulList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.SuccessfulBatchAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulList(java.util.Collection<SuccessfulBatchAssociationSummary>)
         */
        Builder successfulList(Consumer<SuccessfulBatchAssociationSummary.Builder>... successfulList);

        /**
         * <p>
         * A list of resources that failed to be disassociated from the workspace, including error details.
         * </p>
         * 
         * @param failedList
         *        A list of resources that failed to be disassociated from the workspace, including error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedList(Collection<FailedBatchAssociationSummary> failedList);

        /**
         * <p>
         * A list of resources that failed to be disassociated from the workspace, including error details.
         * </p>
         * 
         * @param failedList
         *        A list of resources that failed to be disassociated from the workspace, including error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedList(FailedBatchAssociationSummary... failedList);

        /**
         * <p>
         * A list of resources that failed to be disassociated from the workspace, including error details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.FailedBatchAssociationSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.FailedBatchAssociationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.FailedBatchAssociationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #failedList(List<FailedBatchAssociationSummary>)}.
         * 
         * @param failedList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.FailedBatchAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedList(java.util.Collection<FailedBatchAssociationSummary>)
         */
        Builder failedList(Consumer<FailedBatchAssociationSummary.Builder>... failedList);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<SuccessfulBatchAssociationSummary> successfulList = DefaultSdkAutoConstructList.getInstance();

        private List<FailedBatchAssociationSummary> failedList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateWorkspaceResponse model) {
            super(model);
            successfulList(model.successfulList);
            failedList(model.failedList);
        }

        public final List<SuccessfulBatchAssociationSummary.Builder> getSuccessfulList() {
            List<SuccessfulBatchAssociationSummary.Builder> result = SuccessfulBatchAssociationSummaryListCopier
                    .copyToBuilder(this.successfulList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulList(Collection<SuccessfulBatchAssociationSummary.BuilderImpl> successfulList) {
            this.successfulList = SuccessfulBatchAssociationSummaryListCopier.copyFromBuilder(successfulList);
        }

        @Override
        public final Builder successfulList(Collection<SuccessfulBatchAssociationSummary> successfulList) {
            this.successfulList = SuccessfulBatchAssociationSummaryListCopier.copy(successfulList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulList(SuccessfulBatchAssociationSummary... successfulList) {
            successfulList(Arrays.asList(successfulList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulList(Consumer<SuccessfulBatchAssociationSummary.Builder>... successfulList) {
            successfulList(Stream.of(successfulList)
                    .map(c -> SuccessfulBatchAssociationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FailedBatchAssociationSummary.Builder> getFailedList() {
            List<FailedBatchAssociationSummary.Builder> result = FailedBatchAssociationSummaryListCopier
                    .copyToBuilder(this.failedList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedList(Collection<FailedBatchAssociationSummary.BuilderImpl> failedList) {
            this.failedList = FailedBatchAssociationSummaryListCopier.copyFromBuilder(failedList);
        }

        @Override
        public final Builder failedList(Collection<FailedBatchAssociationSummary> failedList) {
            this.failedList = FailedBatchAssociationSummaryListCopier.copy(failedList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedList(FailedBatchAssociationSummary... failedList) {
            failedList(Arrays.asList(failedList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedList(Consumer<FailedBatchAssociationSummary.Builder>... failedList) {
            failedList(Stream.of(failedList).map(c -> FailedBatchAssociationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DisassociateWorkspaceResponse build() {
            return new DisassociateWorkspaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
