/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataTableResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeDataTableResponse.Builder, DescribeDataTableResponse> {
    private static final SdkField<DataTable> DATA_TABLE_FIELD = SdkField.<DataTable> builder(MarshallingType.SDK_POJO)
            .memberName("DataTable").getter(getter(DescribeDataTableResponse::dataTable)).setter(setter(Builder::dataTable))
            .constructor(DataTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DataTable dataTable;

    private DescribeDataTableResponse(BuilderImpl builder) {
        super(builder);
        this.dataTable = builder.dataTable;
    }

    /**
     * <p>
     * The complete data table information including metadata, configuration, and versioning details.
     * </p>
     * 
     * @return The complete data table information including metadata, configuration, and versioning details.
     */
    public final DataTable dataTable() {
        return dataTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataTableResponse)) {
            return false;
        }
        DescribeDataTableResponse other = (DescribeDataTableResponse) obj;
        return Objects.equals(dataTable(), other.dataTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataTableResponse").add("DataTable", dataTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTable":
            return Optional.ofNullable(clazz.cast(dataTable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataTable", DATA_TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataTableResponse, T> g) {
        return obj -> g.apply((DescribeDataTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDataTableResponse> {
        /**
         * <p>
         * The complete data table information including metadata, configuration, and versioning details.
         * </p>
         * 
         * @param dataTable
         *        The complete data table information including metadata, configuration, and versioning details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTable(DataTable dataTable);

        /**
         * <p>
         * The complete data table information including metadata, configuration, and versioning details.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataTable.Builder} avoiding the need to
         * create one manually via {@link DataTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTable.Builder#build()} is called immediately and its result
         * is passed to {@link #dataTable(DataTable)}.
         * 
         * @param dataTable
         *        a consumer that will call methods on {@link DataTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataTable(DataTable)
         */
        default Builder dataTable(Consumer<DataTable.Builder> dataTable) {
            return dataTable(DataTable.builder().applyMutation(dataTable).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private DataTable dataTable;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataTableResponse model) {
            super(model);
            dataTable(model.dataTable);
        }

        public final DataTable.Builder getDataTable() {
            return dataTable != null ? dataTable.toBuilder() : null;
        }

        public final void setDataTable(DataTable.BuilderImpl dataTable) {
            this.dataTable = dataTable != null ? dataTable.build() : null;
        }

        @Override
        public final Builder dataTable(DataTable dataTable) {
            this.dataTable = dataTable;
            return this;
        }

        @Override
        public DescribeDataTableResponse build() {
            return new DescribeDataTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
