/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteContactFlowModuleVersionRequest extends ConnectRequest implements
        ToCopyableBuilder<DeleteContactFlowModuleVersionRequest.Builder, DeleteContactFlowModuleVersionRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(DeleteContactFlowModuleVersionRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_FLOW_MODULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowModuleId").getter(getter(DeleteContactFlowModuleVersionRequest::contactFlowModuleId))
            .setter(setter(Builder::contactFlowModuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowModuleId").build()).build();

    private static final SdkField<Long> CONTACT_FLOW_MODULE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ContactFlowModuleVersion")
            .getter(getter(DeleteContactFlowModuleVersionRequest::contactFlowModuleVersion))
            .setter(setter(Builder::contactFlowModuleVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowModuleVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_FLOW_MODULE_ID_FIELD, CONTACT_FLOW_MODULE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String contactFlowModuleId;

    private final Long contactFlowModuleVersion;

    private DeleteContactFlowModuleVersionRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactFlowModuleId = builder.contactFlowModuleId;
        this.contactFlowModuleVersion = builder.contactFlowModuleVersion;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     * 
     * @return The identifier of the flow module.
     */
    public final String contactFlowModuleId() {
        return contactFlowModuleId;
    }

    /**
     * <p>
     * The version of the flow module to delete.
     * </p>
     * 
     * @return The version of the flow module to delete.
     */
    public final Long contactFlowModuleVersion() {
        return contactFlowModuleVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleId());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteContactFlowModuleVersionRequest)) {
            return false;
        }
        DeleteContactFlowModuleVersionRequest other = (DeleteContactFlowModuleVersionRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(contactFlowModuleId(), other.contactFlowModuleId())
                && Objects.equals(contactFlowModuleVersion(), other.contactFlowModuleVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteContactFlowModuleVersionRequest").add("InstanceId", instanceId())
                .add("ContactFlowModuleId", contactFlowModuleId()).add("ContactFlowModuleVersion", contactFlowModuleVersion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactFlowModuleId":
            return Optional.ofNullable(clazz.cast(contactFlowModuleId()));
        case "ContactFlowModuleVersion":
            return Optional.ofNullable(clazz.cast(contactFlowModuleVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactFlowModuleId", CONTACT_FLOW_MODULE_ID_FIELD);
        map.put("ContactFlowModuleVersion", CONTACT_FLOW_MODULE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteContactFlowModuleVersionRequest, T> g) {
        return obj -> g.apply((DeleteContactFlowModuleVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteContactFlowModuleVersionRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the flow module.
         * </p>
         * 
         * @param contactFlowModuleId
         *        The identifier of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleId(String contactFlowModuleId);

        /**
         * <p>
         * The version of the flow module to delete.
         * </p>
         * 
         * @param contactFlowModuleVersion
         *        The version of the flow module to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleVersion(Long contactFlowModuleVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactFlowModuleId;

        private Long contactFlowModuleVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteContactFlowModuleVersionRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactFlowModuleId(model.contactFlowModuleId);
            contactFlowModuleVersion(model.contactFlowModuleVersion);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactFlowModuleId() {
            return contactFlowModuleId;
        }

        public final void setContactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
        }

        @Override
        public final Builder contactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
            return this;
        }

        public final Long getContactFlowModuleVersion() {
            return contactFlowModuleVersion;
        }

        public final void setContactFlowModuleVersion(Long contactFlowModuleVersion) {
            this.contactFlowModuleVersion = contactFlowModuleVersion;
        }

        @Override
        public final Builder contactFlowModuleVersion(Long contactFlowModuleVersion) {
            this.contactFlowModuleVersion = contactFlowModuleVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteContactFlowModuleVersionRequest build() {
            return new DeleteContactFlowModuleVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
