/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an attribute (column) in a data table. Attributes define the schema and validation rules for values that
 * can be stored in the table. They specify the data type, constraints, and whether the attribute is used as a primary
 * key for record identification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataTableAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<DataTableAttribute.Builder, DataTableAttribute> {
    private static final SdkField<String> ATTRIBUTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeId").getter(getter(DataTableAttribute::attributeId)).setter(setter(Builder::attributeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DataTableAttribute::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueType").getter(getter(DataTableAttribute::valueTypeAsString)).setter(setter(Builder::valueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DataTableAttribute::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTableId").getter(getter(DataTableAttribute::dataTableId)).setter(setter(Builder::dataTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTableId").build()).build();

    private static final SdkField<String> DATA_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTableArn").getter(getter(DataTableAttribute::dataTableArn)).setter(setter(Builder::dataTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTableArn").build()).build();

    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Primary").getter(getter(DataTableAttribute::primary)).setter(setter(Builder::primary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(DataTableAttribute::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<DataTableLockVersion> LOCK_VERSION_FIELD = SdkField
            .<DataTableLockVersion> builder(MarshallingType.SDK_POJO).memberName("LockVersion")
            .getter(getter(DataTableAttribute::lockVersion)).setter(setter(Builder::lockVersion))
            .constructor(DataTableLockVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockVersion").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DataTableAttribute::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(DataTableAttribute::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final SdkField<Validation> VALIDATION_FIELD = SdkField.<Validation> builder(MarshallingType.SDK_POJO)
            .memberName("Validation").getter(getter(DataTableAttribute::validation)).setter(setter(Builder::validation))
            .constructor(Validation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_ID_FIELD,
            NAME_FIELD, VALUE_TYPE_FIELD, DESCRIPTION_FIELD, DATA_TABLE_ID_FIELD, DATA_TABLE_ARN_FIELD, PRIMARY_FIELD,
            VERSION_FIELD, LOCK_VERSION_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD, VALIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeId;

    private final String name;

    private final String valueType;

    private final String description;

    private final String dataTableId;

    private final String dataTableArn;

    private final Boolean primary;

    private final String version;

    private final DataTableLockVersion lockVersion;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private final Validation validation;

    private DataTableAttribute(BuilderImpl builder) {
        this.attributeId = builder.attributeId;
        this.name = builder.name;
        this.valueType = builder.valueType;
        this.description = builder.description;
        this.dataTableId = builder.dataTableId;
        this.dataTableArn = builder.dataTableArn;
        this.primary = builder.primary;
        this.version = builder.version;
        this.lockVersion = builder.lockVersion;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.validation = builder.validation;
    }

    /**
     * <p>
     * The unique identifier for the attribute within the data table.
     * </p>
     * 
     * @return The unique identifier for the attribute within the data table.
     */
    public final String attributeId() {
        return attributeId;
    }

    /**
     * <p>
     * The human-readable name of the attribute. Must be unique within the data table and conform to Connect naming
     * standards.
     * </p>
     * 
     * @return The human-readable name of the attribute. Must be unique within the data table and conform to Connect
     *         naming standards.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of value allowed for this attribute. Must be one of TEXT, TEXT_LIST, NUMBER, NUMBER_LIST, or BOOLEAN.
     * Determines how values are validated and processed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link DataTableAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The type of value allowed for this attribute. Must be one of TEXT, TEXT_LIST, NUMBER, NUMBER_LIST, or
     *         BOOLEAN. Determines how values are validated and processed.
     * @see DataTableAttributeValueType
     */
    public final DataTableAttributeValueType valueType() {
        return DataTableAttributeValueType.fromValue(valueType);
    }

    /**
     * <p>
     * The type of value allowed for this attribute. Must be one of TEXT, TEXT_LIST, NUMBER, NUMBER_LIST, or BOOLEAN.
     * Determines how values are validated and processed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link DataTableAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The type of value allowed for this attribute. Must be one of TEXT, TEXT_LIST, NUMBER, NUMBER_LIST, or
     *         BOOLEAN. Determines how values are validated and processed.
     * @see DataTableAttributeValueType
     */
    public final String valueTypeAsString() {
        return valueType;
    }

    /**
     * <p>
     * An optional description explaining the purpose and usage of this attribute.
     * </p>
     * 
     * @return An optional description explaining the purpose and usage of this attribute.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the data table that contains this attribute.
     * </p>
     * 
     * @return The unique identifier of the data table that contains this attribute.
     */
    public final String dataTableId() {
        return dataTableId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the data table that contains this attribute.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the data table that contains this attribute.
     */
    public final String dataTableArn() {
        return dataTableArn;
    }

    /**
     * <p>
     * Boolean indicating whether this attribute is used as a primary key for record identification. Primary attributes
     * must have unique value combinations and cannot contain expressions.
     * </p>
     * 
     * @return Boolean indicating whether this attribute is used as a primary key for record identification. Primary
     *         attributes must have unique value combinations and cannot contain expressions.
     */
    public final Boolean primary() {
        return primary;
    }

    /**
     * <p>
     * The version identifier for this attribute, used for versioning and change tracking.
     * </p>
     * 
     * @return The version identifier for this attribute, used for versioning and change tracking.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The lock version for this attribute, used for optimistic locking to prevent concurrent modification conflicts.
     * </p>
     * 
     * @return The lock version for this attribute, used for optimistic locking to prevent concurrent modification
     *         conflicts.
     */
    public final DataTableLockVersion lockVersion() {
        return lockVersion;
    }

    /**
     * <p>
     * The timestamp when this attribute was last modified.
     * </p>
     * 
     * @return The timestamp when this attribute was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The AWS region where this attribute was last modified, used for region replication.
     * </p>
     * 
     * @return The AWS region where this attribute was last modified, used for region replication.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    /**
     * <p>
     * The validation rules applied to values of this attribute. Based on JSON Schema Draft 2020-12 with additional
     * Connect-specific validations for data integrity.
     * </p>
     * 
     * @return The validation rules applied to values of this attribute. Based on JSON Schema Draft 2020-12 with
     *         additional Connect-specific validations for data integrity.
     */
    public final Validation validation() {
        return validation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(dataTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(lockVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(validation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableAttribute)) {
            return false;
        }
        DataTableAttribute other = (DataTableAttribute) obj;
        return Objects.equals(attributeId(), other.attributeId()) && Objects.equals(name(), other.name())
                && Objects.equals(valueTypeAsString(), other.valueTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(dataTableId(), other.dataTableId())
                && Objects.equals(dataTableArn(), other.dataTableArn()) && Objects.equals(primary(), other.primary())
                && Objects.equals(version(), other.version()) && Objects.equals(lockVersion(), other.lockVersion())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion())
                && Objects.equals(validation(), other.validation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataTableAttribute").add("AttributeId", attributeId()).add("Name", name())
                .add("ValueType", valueTypeAsString()).add("Description", description()).add("DataTableId", dataTableId())
                .add("DataTableArn", dataTableArn()).add("Primary", primary()).add("Version", version())
                .add("LockVersion", lockVersion()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedRegion", lastModifiedRegion()).add("Validation", validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeId":
            return Optional.ofNullable(clazz.cast(attributeId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ValueType":
            return Optional.ofNullable(clazz.cast(valueTypeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DataTableId":
            return Optional.ofNullable(clazz.cast(dataTableId()));
        case "DataTableArn":
            return Optional.ofNullable(clazz.cast(dataTableArn()));
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "LockVersion":
            return Optional.ofNullable(clazz.cast(lockVersion()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        case "Validation":
            return Optional.ofNullable(clazz.cast(validation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeId", ATTRIBUTE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("DataTableArn", DATA_TABLE_ARN_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("LockVersion", LOCK_VERSION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("Validation", VALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableAttribute, T> g) {
        return obj -> g.apply((DataTableAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataTableAttribute> {
        /**
         * <p>
         * The unique identifier for the attribute within the data table.
         * </p>
         * 
         * @param attributeId
         *        The unique identifier for the attribute within the data table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeId(String attributeId);

        /**
         * <p>
         * The human-readable name of the attribute. Must be unique within the data table and conform to Connect naming
         * standards.
         * </p>
         * 
         * @param name
         *        The human-readable name of the attribute. Must be unique within the data table and conform to Connect
         *        naming standards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of value allowed for this attribute. Must be one of TEXT, TEXT_LIST, NUMBER, NUMBER_LIST, or
         * BOOLEAN. Determines how values are validated and processed.
         * </p>
         * 
         * @param valueType
         *        The type of value allowed for this attribute. Must be one of TEXT, TEXT_LIST, NUMBER, NUMBER_LIST, or
         *        BOOLEAN. Determines how values are validated and processed.
         * @see DataTableAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableAttributeValueType
         */
        Builder valueType(String valueType);

        /**
         * <p>
         * The type of value allowed for this attribute. Must be one of TEXT, TEXT_LIST, NUMBER, NUMBER_LIST, or
         * BOOLEAN. Determines how values are validated and processed.
         * </p>
         * 
         * @param valueType
         *        The type of value allowed for this attribute. Must be one of TEXT, TEXT_LIST, NUMBER, NUMBER_LIST, or
         *        BOOLEAN. Determines how values are validated and processed.
         * @see DataTableAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableAttributeValueType
         */
        Builder valueType(DataTableAttributeValueType valueType);

        /**
         * <p>
         * An optional description explaining the purpose and usage of this attribute.
         * </p>
         * 
         * @param description
         *        An optional description explaining the purpose and usage of this attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the data table that contains this attribute.
         * </p>
         * 
         * @param dataTableId
         *        The unique identifier of the data table that contains this attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableId(String dataTableId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the data table that contains this attribute.
         * </p>
         * 
         * @param dataTableArn
         *        The Amazon Resource Name (ARN) of the data table that contains this attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableArn(String dataTableArn);

        /**
         * <p>
         * Boolean indicating whether this attribute is used as a primary key for record identification. Primary
         * attributes must have unique value combinations and cannot contain expressions.
         * </p>
         * 
         * @param primary
         *        Boolean indicating whether this attribute is used as a primary key for record identification. Primary
         *        attributes must have unique value combinations and cannot contain expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);

        /**
         * <p>
         * The version identifier for this attribute, used for versioning and change tracking.
         * </p>
         * 
         * @param version
         *        The version identifier for this attribute, used for versioning and change tracking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The lock version for this attribute, used for optimistic locking to prevent concurrent modification
         * conflicts.
         * </p>
         * 
         * @param lockVersion
         *        The lock version for this attribute, used for optimistic locking to prevent concurrent modification
         *        conflicts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockVersion(DataTableLockVersion lockVersion);

        /**
         * <p>
         * The lock version for this attribute, used for optimistic locking to prevent concurrent modification
         * conflicts.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataTableLockVersion.Builder} avoiding
         * the need to create one manually via {@link DataTableLockVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTableLockVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #lockVersion(DataTableLockVersion)}.
         * 
         * @param lockVersion
         *        a consumer that will call methods on {@link DataTableLockVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lockVersion(DataTableLockVersion)
         */
        default Builder lockVersion(Consumer<DataTableLockVersion.Builder> lockVersion) {
            return lockVersion(DataTableLockVersion.builder().applyMutation(lockVersion).build());
        }

        /**
         * <p>
         * The timestamp when this attribute was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when this attribute was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The AWS region where this attribute was last modified, used for region replication.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The AWS region where this attribute was last modified, used for region replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);

        /**
         * <p>
         * The validation rules applied to values of this attribute. Based on JSON Schema Draft 2020-12 with additional
         * Connect-specific validations for data integrity.
         * </p>
         * 
         * @param validation
         *        The validation rules applied to values of this attribute. Based on JSON Schema Draft 2020-12 with
         *        additional Connect-specific validations for data integrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validation(Validation validation);

        /**
         * <p>
         * The validation rules applied to values of this attribute. Based on JSON Schema Draft 2020-12 with additional
         * Connect-specific validations for data integrity.
         * </p>
         * This is a convenience method that creates an instance of the {@link Validation.Builder} avoiding the need to
         * create one manually via {@link Validation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Validation.Builder#build()} is called immediately and its result
         * is passed to {@link #validation(Validation)}.
         * 
         * @param validation
         *        a consumer that will call methods on {@link Validation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validation(Validation)
         */
        default Builder validation(Consumer<Validation.Builder> validation) {
            return validation(Validation.builder().applyMutation(validation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String attributeId;

        private String name;

        private String valueType;

        private String description;

        private String dataTableId;

        private String dataTableArn;

        private Boolean primary;

        private String version;

        private DataTableLockVersion lockVersion;

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private Validation validation;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableAttribute model) {
            attributeId(model.attributeId);
            name(model.name);
            valueType(model.valueType);
            description(model.description);
            dataTableId(model.dataTableId);
            dataTableArn(model.dataTableArn);
            primary(model.primary);
            version(model.version);
            lockVersion(model.lockVersion);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
            validation(model.validation);
        }

        public final String getAttributeId() {
            return attributeId;
        }

        public final void setAttributeId(String attributeId) {
            this.attributeId = attributeId;
        }

        @Override
        public final Builder attributeId(String attributeId) {
            this.attributeId = attributeId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueType() {
            return valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DataTableAttributeValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDataTableId() {
            return dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final String getDataTableArn() {
            return dataTableArn;
        }

        public final void setDataTableArn(String dataTableArn) {
            this.dataTableArn = dataTableArn;
        }

        @Override
        public final Builder dataTableArn(String dataTableArn) {
            this.dataTableArn = dataTableArn;
            return this;
        }

        public final Boolean getPrimary() {
            return primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final DataTableLockVersion.Builder getLockVersion() {
            return lockVersion != null ? lockVersion.toBuilder() : null;
        }

        public final void setLockVersion(DataTableLockVersion.BuilderImpl lockVersion) {
            this.lockVersion = lockVersion != null ? lockVersion.build() : null;
        }

        @Override
        public final Builder lockVersion(DataTableLockVersion lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Validation.Builder getValidation() {
            return validation != null ? validation.toBuilder() : null;
        }

        public final void setValidation(Validation.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        public final Builder validation(Validation validation) {
            this.validation = validation;
            return this;
        }

        @Override
        public DataTableAttribute build() {
            return new DataTableAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
