/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateRuleRequest.Builder, CreateRuleRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateRuleRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<RuleTriggerEventSource> TRIGGER_EVENT_SOURCE_FIELD = SdkField
            .<RuleTriggerEventSource> builder(MarshallingType.SDK_POJO).memberName("TriggerEventSource")
            .getter(getter(CreateRuleRequest::triggerEventSource)).setter(setter(Builder::triggerEventSource))
            .constructor(RuleTriggerEventSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerEventSource").build())
            .build();

    private static final SdkField<String> FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Function").getter(getter(CreateRuleRequest::function)).setter(setter(Builder::function))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()).build();

    private static final SdkField<List<RuleAction>> ACTIONS_FIELD = SdkField
            .<List<RuleAction>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(CreateRuleRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PUBLISH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublishStatus").getter(getter(CreateRuleRequest::publishStatusAsString))
            .setter(setter(Builder::publishStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishStatus").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateRuleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD,
            TRIGGER_EVENT_SOURCE_FIELD, FUNCTION_FIELD, ACTIONS_FIELD, PUBLISH_STATUS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String name;

    private final RuleTriggerEventSource triggerEventSource;

    private final String function;

    private final List<RuleAction> actions;

    private final String publishStatus;

    private final String clientToken;

    private CreateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.triggerEventSource = builder.triggerEventSource;
        this.function = builder.function;
        this.actions = builder.actions;
        this.publishStatus = builder.publishStatus;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A unique name for the rule.
     * </p>
     * 
     * @return A unique name for the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The event source to trigger the rule.
     * </p>
     * 
     * @return The event source to trigger the rule.
     */
    public final RuleTriggerEventSource triggerEventSource() {
        return triggerEventSource;
    }

    /**
     * <p>
     * The conditions of the rule.
     * </p>
     * 
     * @return The conditions of the rule.
     */
    public final String function() {
        return function;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of actions to be run when the rule is triggered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return A list of actions to be run when the rule is triggered.
     */
    public final List<RuleAction> actions() {
        return actions;
    }

    /**
     * <p>
     * The publish status of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publishStatus}
     * will return {@link RulePublishStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publishStatusAsString}.
     * </p>
     * 
     * @return The publish status of the rule.
     * @see RulePublishStatus
     */
    public final RulePublishStatus publishStatus() {
        return RulePublishStatus.fromValue(publishStatus);
    }

    /**
     * <p>
     * The publish status of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publishStatus}
     * will return {@link RulePublishStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publishStatusAsString}.
     * </p>
     * 
     * @return The publish status of the rule.
     * @see RulePublishStatus
     */
    public final String publishStatusAsString() {
        return publishStatus;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(triggerEventSource());
        hashCode = 31 * hashCode + Objects.hashCode(function());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && Objects.equals(triggerEventSource(), other.triggerEventSource())
                && Objects.equals(function(), other.function()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions())
                && Objects.equals(publishStatusAsString(), other.publishStatusAsString())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleRequest").add("InstanceId", instanceId()).add("Name", name())
                .add("TriggerEventSource", triggerEventSource()).add("Function", function())
                .add("Actions", hasActions() ? actions() : null).add("PublishStatus", publishStatusAsString())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TriggerEventSource":
            return Optional.ofNullable(clazz.cast(triggerEventSource()));
        case "Function":
            return Optional.ofNullable(clazz.cast(function()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "PublishStatus":
            return Optional.ofNullable(clazz.cast(publishStatusAsString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("TriggerEventSource", TRIGGER_EVENT_SOURCE_FIELD);
        map.put("Function", FUNCTION_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("PublishStatus", PUBLISH_STATUS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleRequest, T> g) {
        return obj -> g.apply((CreateRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A unique name for the rule.
         * </p>
         * 
         * @param name
         *        A unique name for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The event source to trigger the rule.
         * </p>
         * 
         * @param triggerEventSource
         *        The event source to trigger the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerEventSource(RuleTriggerEventSource triggerEventSource);

        /**
         * <p>
         * The event source to trigger the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleTriggerEventSource.Builder} avoiding
         * the need to create one manually via {@link RuleTriggerEventSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleTriggerEventSource.Builder#build()} is called immediately and
         * its result is passed to {@link #triggerEventSource(RuleTriggerEventSource)}.
         * 
         * @param triggerEventSource
         *        a consumer that will call methods on {@link RuleTriggerEventSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerEventSource(RuleTriggerEventSource)
         */
        default Builder triggerEventSource(Consumer<RuleTriggerEventSource.Builder> triggerEventSource) {
            return triggerEventSource(RuleTriggerEventSource.builder().applyMutation(triggerEventSource).build());
        }

        /**
         * <p>
         * The conditions of the rule.
         * </p>
         * 
         * @param function
         *        The conditions of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder function(String function);

        /**
         * <p>
         * A list of actions to be run when the rule is triggered.
         * </p>
         * 
         * @param actions
         *        A list of actions to be run when the rule is triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<RuleAction> actions);

        /**
         * <p>
         * A list of actions to be run when the rule is triggered.
         * </p>
         * 
         * @param actions
         *        A list of actions to be run when the rule is triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(RuleAction... actions);

        /**
         * <p>
         * A list of actions to be run when the rule is triggered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.RuleAction.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.RuleAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.RuleAction.Builder#build()} is called immediately and
         * its result is passed to {@link #actions(List<RuleAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.RuleAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<RuleAction>)
         */
        Builder actions(Consumer<RuleAction.Builder>... actions);

        /**
         * <p>
         * The publish status of the rule.
         * </p>
         * 
         * @param publishStatus
         *        The publish status of the rule.
         * @see RulePublishStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RulePublishStatus
         */
        Builder publishStatus(String publishStatus);

        /**
         * <p>
         * The publish status of the rule.
         * </p>
         * 
         * @param publishStatus
         *        The publish status of the rule.
         * @see RulePublishStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RulePublishStatus
         */
        Builder publishStatus(RulePublishStatus publishStatus);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String name;

        private RuleTriggerEventSource triggerEventSource;

        private String function;

        private List<RuleAction> actions = DefaultSdkAutoConstructList.getInstance();

        private String publishStatus;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            super(model);
            instanceId(model.instanceId);
            name(model.name);
            triggerEventSource(model.triggerEventSource);
            function(model.function);
            actions(model.actions);
            publishStatus(model.publishStatus);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleTriggerEventSource.Builder getTriggerEventSource() {
            return triggerEventSource != null ? triggerEventSource.toBuilder() : null;
        }

        public final void setTriggerEventSource(RuleTriggerEventSource.BuilderImpl triggerEventSource) {
            this.triggerEventSource = triggerEventSource != null ? triggerEventSource.build() : null;
        }

        @Override
        public final Builder triggerEventSource(RuleTriggerEventSource triggerEventSource) {
            this.triggerEventSource = triggerEventSource;
            return this;
        }

        public final String getFunction() {
            return function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final List<RuleAction.Builder> getActions() {
            List<RuleAction.Builder> result = RuleActionsCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<RuleAction.BuilderImpl> actions) {
            this.actions = RuleActionsCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<RuleAction> actions) {
            this.actions = RuleActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(RuleAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<RuleAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> RuleAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPublishStatus() {
            return publishStatus;
        }

        public final void setPublishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
        }

        @Override
        public final Builder publishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        @Override
        public final Builder publishStatus(RulePublishStatus publishStatus) {
            this.publishStatus(publishStatus == null ? null : publishStatus.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
