/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataTableRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateDataTableRequest.Builder, CreateDataTableRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateDataTableRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDataTableRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateDataTableRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(CreateDataTableRequest::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final SdkField<String> VALUE_LOCK_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueLockLevel").getter(getter(CreateDataTableRequest::valueLockLevelAsString))
            .setter(setter(Builder::valueLockLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLockLevel").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateDataTableRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDataTableRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, TIME_ZONE_FIELD, VALUE_LOCK_LEVEL_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String name;

    private final String description;

    private final String timeZone;

    private final String valueLockLevel;

    private final String status;

    private final Map<String, String> tags;

    private CreateDataTableRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.description = builder.description;
        this.timeZone = builder.timeZone;
        this.valueLockLevel = builder.valueLockLevel;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Connect instance where the data table will be created.
     * </p>
     * 
     * @return The unique identifier for the Amazon Connect instance where the data table will be created.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name for the data table. Must conform to Connect human readable string specification and have 1-127
     * characters. Whitespace must be trimmed first. Must not start with the reserved case insensitive values 'connect:'
     * and 'aws:'. Must be unique for the instance using case-insensitive comparison.
     * </p>
     * 
     * @return The name for the data table. Must conform to Connect human readable string specification and have 1-127
     *         characters. Whitespace must be trimmed first. Must not start with the reserved case insensitive values
     *         'connect:' and 'aws:'. Must be unique for the instance using case-insensitive comparison.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description for the data table. Must conform to Connect human readable string specification and have
     * 0-250 characters. Whitespace must be trimmed first.
     * </p>
     * 
     * @return An optional description for the data table. Must conform to Connect human readable string specification
     *         and have 0-250 characters. Whitespace must be trimmed first.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The IANA timezone identifier to use when resolving time based dynamic values. Required even if no time slices are
     * specified.
     * </p>
     * 
     * @return The IANA timezone identifier to use when resolving time based dynamic values. Required even if no time
     *         slices are specified.
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * <p>
     * The data level that concurrent value edits are locked on. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE, and
     * NONE. NONE is the default if unspecified. This determines how concurrent edits are handled when multiple users
     * attempt to modify values simultaneously.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueLockLevel}
     * will return {@link DataTableLockLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #valueLockLevelAsString}.
     * </p>
     * 
     * @return The data level that concurrent value edits are locked on. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE,
     *         VALUE, and NONE. NONE is the default if unspecified. This determines how concurrent edits are handled
     *         when multiple users attempt to modify values simultaneously.
     * @see DataTableLockLevel
     */
    public final DataTableLockLevel valueLockLevel() {
        return DataTableLockLevel.fromValue(valueLockLevel);
    }

    /**
     * <p>
     * The data level that concurrent value edits are locked on. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE, and
     * NONE. NONE is the default if unspecified. This determines how concurrent edits are handled when multiple users
     * attempt to modify values simultaneously.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueLockLevel}
     * will return {@link DataTableLockLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #valueLockLevelAsString}.
     * </p>
     * 
     * @return The data level that concurrent value edits are locked on. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE,
     *         VALUE, and NONE. NONE is the default if unspecified. This determines how concurrent edits are handled
     *         when multiple users attempt to modify values simultaneously.
     * @see DataTableLockLevel
     */
    public final String valueLockLevelAsString() {
        return valueLockLevel;
    }

    /**
     * <p>
     * The status of the data table. One of PUBLISHED or SAVED. Required parameter that determines the initial state of
     * the table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataTableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data table. One of PUBLISHED or SAVED. Required parameter that determines the initial
     *         state of the table.
     * @see DataTableStatus
     */
    public final DataTableStatus status() {
        return DataTableStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data table. One of PUBLISHED or SAVED. Required parameter that determines the initial state of
     * the table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataTableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data table. One of PUBLISHED or SAVED. Required parameter that determines the initial
     *         state of the table.
     * @see DataTableStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key value pairs for attribute based access control (TBAC or ABAC). Optional tags to apply to the data table for
     * organization and access control purposes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key value pairs for attribute based access control (TBAC or ABAC). Optional tags to apply to the data
     *         table for organization and access control purposes.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(valueLockLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataTableRequest)) {
            return false;
        }
        CreateDataTableRequest other = (CreateDataTableRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(timeZone(), other.timeZone())
                && Objects.equals(valueLockLevelAsString(), other.valueLockLevelAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataTableRequest").add("InstanceId", instanceId()).add("Name", name())
                .add("Description", description()).add("TimeZone", timeZone()).add("ValueLockLevel", valueLockLevelAsString())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "ValueLockLevel":
            return Optional.ofNullable(clazz.cast(valueLockLevelAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TimeZone", TIME_ZONE_FIELD);
        map.put("ValueLockLevel", VALUE_LOCK_LEVEL_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataTableRequest, T> g) {
        return obj -> g.apply((CreateDataTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataTableRequest> {
        /**
         * <p>
         * The unique identifier for the Amazon Connect instance where the data table will be created.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier for the Amazon Connect instance where the data table will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name for the data table. Must conform to Connect human readable string specification and have 1-127
         * characters. Whitespace must be trimmed first. Must not start with the reserved case insensitive values
         * 'connect:' and 'aws:'. Must be unique for the instance using case-insensitive comparison.
         * </p>
         * 
         * @param name
         *        The name for the data table. Must conform to Connect human readable string specification and have
         *        1-127 characters. Whitespace must be trimmed first. Must not start with the reserved case insensitive
         *        values 'connect:' and 'aws:'. Must be unique for the instance using case-insensitive comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description for the data table. Must conform to Connect human readable string specification and
         * have 0-250 characters. Whitespace must be trimmed first.
         * </p>
         * 
         * @param description
         *        An optional description for the data table. Must conform to Connect human readable string
         *        specification and have 0-250 characters. Whitespace must be trimmed first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IANA timezone identifier to use when resolving time based dynamic values. Required even if no time slices
         * are specified.
         * </p>
         * 
         * @param timeZone
         *        The IANA timezone identifier to use when resolving time based dynamic values. Required even if no time
         *        slices are specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * The data level that concurrent value edits are locked on. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE,
         * and NONE. NONE is the default if unspecified. This determines how concurrent edits are handled when multiple
         * users attempt to modify values simultaneously.
         * </p>
         * 
         * @param valueLockLevel
         *        The data level that concurrent value edits are locked on. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE,
         *        VALUE, and NONE. NONE is the default if unspecified. This determines how concurrent edits are handled
         *        when multiple users attempt to modify values simultaneously.
         * @see DataTableLockLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableLockLevel
         */
        Builder valueLockLevel(String valueLockLevel);

        /**
         * <p>
         * The data level that concurrent value edits are locked on. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE,
         * and NONE. NONE is the default if unspecified. This determines how concurrent edits are handled when multiple
         * users attempt to modify values simultaneously.
         * </p>
         * 
         * @param valueLockLevel
         *        The data level that concurrent value edits are locked on. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE,
         *        VALUE, and NONE. NONE is the default if unspecified. This determines how concurrent edits are handled
         *        when multiple users attempt to modify values simultaneously.
         * @see DataTableLockLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableLockLevel
         */
        Builder valueLockLevel(DataTableLockLevel valueLockLevel);

        /**
         * <p>
         * The status of the data table. One of PUBLISHED or SAVED. Required parameter that determines the initial state
         * of the table.
         * </p>
         * 
         * @param status
         *        The status of the data table. One of PUBLISHED or SAVED. Required parameter that determines the
         *        initial state of the table.
         * @see DataTableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data table. One of PUBLISHED or SAVED. Required parameter that determines the initial state
         * of the table.
         * </p>
         * 
         * @param status
         *        The status of the data table. One of PUBLISHED or SAVED. Required parameter that determines the
         *        initial state of the table.
         * @see DataTableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableStatus
         */
        Builder status(DataTableStatus status);

        /**
         * <p>
         * Key value pairs for attribute based access control (TBAC or ABAC). Optional tags to apply to the data table
         * for organization and access control purposes.
         * </p>
         * 
         * @param tags
         *        Key value pairs for attribute based access control (TBAC or ABAC). Optional tags to apply to the data
         *        table for organization and access control purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String name;

        private String description;

        private String timeZone;

        private String valueLockLevel;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataTableRequest model) {
            super(model);
            instanceId(model.instanceId);
            name(model.name);
            description(model.description);
            timeZone(model.timeZone);
            valueLockLevel(model.valueLockLevel);
            status(model.status);
            tags(model.tags);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getValueLockLevel() {
            return valueLockLevel;
        }

        public final void setValueLockLevel(String valueLockLevel) {
            this.valueLockLevel = valueLockLevel;
        }

        @Override
        public final Builder valueLockLevel(String valueLockLevel) {
            this.valueLockLevel = valueLockLevel;
            return this;
        }

        @Override
        public final Builder valueLockLevel(DataTableLockLevel valueLockLevel) {
            this.valueLockLevel(valueLockLevel == null ? null : valueLockLevel.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataTableStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataTableRequest build() {
            return new CreateDataTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
