/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a flow module.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlowModule implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactFlowModule.Builder, ContactFlowModule> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ContactFlowModule::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ContactFlowModule::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ContactFlowModule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(ContactFlowModule::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ContactFlowModule::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ContactFlowModule::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ContactFlowModule::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(ContactFlowModule::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FLOW_MODULE_CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowModuleContentSha256").getter(getter(ContactFlowModule::flowModuleContentSha256))
            .setter(setter(Builder::flowModuleContentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowModuleContentSha256").build())
            .build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(ContactFlowModule::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(ContactFlowModule::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<String> SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Settings").getter(getter(ContactFlowModule::settings)).setter(setter(Builder::settings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<ExternalInvocationConfiguration> EXTERNAL_INVOCATION_CONFIGURATION_FIELD = SdkField
            .<ExternalInvocationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ExternalInvocationConfiguration")
            .getter(getter(ContactFlowModule::externalInvocationConfiguration))
            .setter(setter(Builder::externalInvocationConfiguration))
            .constructor(ExternalInvocationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalInvocationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, CONTENT_FIELD, DESCRIPTION_FIELD, STATE_FIELD, STATUS_FIELD, TAGS_FIELD,
            FLOW_MODULE_CONTENT_SHA256_FIELD, VERSION_FIELD, VERSION_DESCRIPTION_FIELD, SETTINGS_FIELD,
            EXTERNAL_INVOCATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String name;

    private final String content;

    private final String description;

    private final String state;

    private final String status;

    private final Map<String, String> tags;

    private final String flowModuleContentSha256;

    private final Long version;

    private final String versionDescription;

    private final String settings;

    private final ExternalInvocationConfiguration externalInvocationConfiguration;

    private ContactFlowModule(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.content = builder.content;
        this.description = builder.description;
        this.state = builder.state;
        this.status = builder.status;
        this.tags = builder.tags;
        this.flowModuleContentSha256 = builder.flowModuleContentSha256;
        this.version = builder.version;
        this.versionDescription = builder.versionDescription;
        this.settings = builder.settings;
        this.externalInvocationConfiguration = builder.externalInvocationConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN).
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     * 
     * @return The identifier of the flow module.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the flow module.
     * </p>
     * 
     * @return The name of the flow module.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The JSON string that represents the content of the flow. For an example, see <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in Amazon
     * Connect Flow language</a>.
     * </p>
     * 
     * @return The JSON string that represents the content of the flow. For an example, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in
     *         Amazon Connect Flow language</a>.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The description of the flow module.
     * </p>
     * 
     * @return The description of the flow module.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of flow module.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ContactFlowModuleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The type of flow module.
     * @see ContactFlowModuleState
     */
    public final ContactFlowModuleState state() {
        return ContactFlowModuleState.fromValue(state);
    }

    /**
     * <p>
     * The type of flow module.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ContactFlowModuleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The type of flow module.
     * @see ContactFlowModuleState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The status of the flow module.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContactFlowModuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flow module.
     * @see ContactFlowModuleStatus
     */
    public final ContactFlowModuleStatus status() {
        return ContactFlowModuleStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the flow module.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContactFlowModuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flow module.
     * @see ContactFlowModuleStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "Tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Hash of the module content for integrity verification.
     * </p>
     * 
     * @return Hash of the module content for integrity verification.
     */
    public final String flowModuleContentSha256() {
        return flowModuleContentSha256;
    }

    /**
     * <p>
     * The version of the flow module.
     * </p>
     * 
     * @return The version of the flow module.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * Description of the version.
     * </p>
     * 
     * @return Description of the version.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * The configuration settings for the flow module.
     * </p>
     * 
     * @return The configuration settings for the flow module.
     */
    public final String settings() {
        return settings;
    }

    /**
     * <p>
     * The external invocation configuration for the flow module
     * </p>
     * 
     * @return The external invocation configuration for the flow module
     */
    public final ExternalInvocationConfiguration externalInvocationConfiguration() {
        return externalInvocationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(flowModuleContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(externalInvocationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowModule)) {
            return false;
        }
        ContactFlowModule other = (ContactFlowModule) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(content(), other.content()) && Objects.equals(description(), other.description())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(flowModuleContentSha256(), other.flowModuleContentSha256())
                && Objects.equals(version(), other.version()) && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(settings(), other.settings())
                && Objects.equals(externalInvocationConfiguration(), other.externalInvocationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFlowModule").add("Arn", arn()).add("Id", id()).add("Name", name())
                .add("Content", content()).add("Description", description()).add("State", stateAsString())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null)
                .add("FlowModuleContentSha256", flowModuleContentSha256()).add("Version", version())
                .add("VersionDescription", versionDescription()).add("Settings", settings())
                .add("ExternalInvocationConfiguration", externalInvocationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "FlowModuleContentSha256":
            return Optional.ofNullable(clazz.cast(flowModuleContentSha256()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "ExternalInvocationConfiguration":
            return Optional.ofNullable(clazz.cast(externalInvocationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("FlowModuleContentSha256", FLOW_MODULE_CONTENT_SHA256_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("ExternalInvocationConfiguration", EXTERNAL_INVOCATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowModule, T> g) {
        return obj -> g.apply((ContactFlowModule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlowModule> {
        /**
         * <p>
         * The Amazon Resource Name (ARN).
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The identifier of the flow module.
         * </p>
         * 
         * @param id
         *        The identifier of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the flow module.
         * </p>
         * 
         * @param name
         *        The name of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The JSON string that represents the content of the flow. For an example, see <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in
         * Amazon Connect Flow language</a>.
         * </p>
         * 
         * @param content
         *        The JSON string that represents the content of the flow. For an example, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow
         *        in Amazon Connect Flow language</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The description of the flow module.
         * </p>
         * 
         * @param description
         *        The description of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of flow module.
         * </p>
         * 
         * @param state
         *        The type of flow module.
         * @see ContactFlowModuleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowModuleState
         */
        Builder state(String state);

        /**
         * <p>
         * The type of flow module.
         * </p>
         * 
         * @param state
         *        The type of flow module.
         * @see ContactFlowModuleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowModuleState
         */
        Builder state(ContactFlowModuleState state);

        /**
         * <p>
         * The status of the flow module.
         * </p>
         * 
         * @param status
         *        The status of the flow module.
         * @see ContactFlowModuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowModuleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the flow module.
         * </p>
         * 
         * @param status
         *        The status of the flow module.
         * @see ContactFlowModuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowModuleStatus
         */
        Builder status(ContactFlowModuleStatus status);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "Tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "Tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Hash of the module content for integrity verification.
         * </p>
         * 
         * @param flowModuleContentSha256
         *        Hash of the module content for integrity verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowModuleContentSha256(String flowModuleContentSha256);

        /**
         * <p>
         * The version of the flow module.
         * </p>
         * 
         * @param version
         *        The version of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * Description of the version.
         * </p>
         * 
         * @param versionDescription
         *        Description of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * The configuration settings for the flow module.
         * </p>
         * 
         * @param settings
         *        The configuration settings for the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(String settings);

        /**
         * <p>
         * The external invocation configuration for the flow module
         * </p>
         * 
         * @param externalInvocationConfiguration
         *        The external invocation configuration for the flow module
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalInvocationConfiguration(ExternalInvocationConfiguration externalInvocationConfiguration);

        /**
         * <p>
         * The external invocation configuration for the flow module
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalInvocationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExternalInvocationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalInvocationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #externalInvocationConfiguration(ExternalInvocationConfiguration)}.
         * 
         * @param externalInvocationConfiguration
         *        a consumer that will call methods on {@link ExternalInvocationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalInvocationConfiguration(ExternalInvocationConfiguration)
         */
        default Builder externalInvocationConfiguration(
                Consumer<ExternalInvocationConfiguration.Builder> externalInvocationConfiguration) {
            return externalInvocationConfiguration(ExternalInvocationConfiguration.builder()
                    .applyMutation(externalInvocationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String content;

        private String description;

        private String state;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String flowModuleContentSha256;

        private Long version;

        private String versionDescription;

        private String settings;

        private ExternalInvocationConfiguration externalInvocationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowModule model) {
            arn(model.arn);
            id(model.id);
            name(model.name);
            content(model.content);
            description(model.description);
            state(model.state);
            status(model.status);
            tags(model.tags);
            flowModuleContentSha256(model.flowModuleContentSha256);
            version(model.version);
            versionDescription(model.versionDescription);
            settings(model.settings);
            externalInvocationConfiguration(model.externalInvocationConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ContactFlowModuleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContactFlowModuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getFlowModuleContentSha256() {
            return flowModuleContentSha256;
        }

        public final void setFlowModuleContentSha256(String flowModuleContentSha256) {
            this.flowModuleContentSha256 = flowModuleContentSha256;
        }

        @Override
        public final Builder flowModuleContentSha256(String flowModuleContentSha256) {
            this.flowModuleContentSha256 = flowModuleContentSha256;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final String getSettings() {
            return settings;
        }

        public final void setSettings(String settings) {
            this.settings = settings;
        }

        @Override
        @Transient
        public final Builder settings(String settings) {
            this.settings = settings;
            return this;
        }

        public final ExternalInvocationConfiguration.Builder getExternalInvocationConfiguration() {
            return externalInvocationConfiguration != null ? externalInvocationConfiguration.toBuilder() : null;
        }

        public final void setExternalInvocationConfiguration(
                ExternalInvocationConfiguration.BuilderImpl externalInvocationConfiguration) {
            this.externalInvocationConfiguration = externalInvocationConfiguration != null ? externalInvocationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder externalInvocationConfiguration(ExternalInvocationConfiguration externalInvocationConfiguration) {
            this.externalInvocationConfiguration = externalInvocationConfiguration;
            return this;
        }

        @Override
        public ContactFlowModule build() {
            return new ContactFlowModule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
