/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateDataTableValueResponse extends ConnectResponse implements
        ToCopyableBuilder<BatchUpdateDataTableValueResponse.Builder, BatchUpdateDataTableValueResponse> {
    private static final SdkField<List<BatchUpdateDataTableValueSuccessResult>> SUCCESSFUL_FIELD = SdkField
            .<List<BatchUpdateDataTableValueSuccessResult>> builder(MarshallingType.LIST)
            .memberName("Successful")
            .getter(getter(BatchUpdateDataTableValueResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateDataTableValueSuccessResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateDataTableValueSuccessResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchUpdateDataTableValueFailureResult>> FAILED_FIELD = SdkField
            .<List<BatchUpdateDataTableValueFailureResult>> builder(MarshallingType.LIST)
            .memberName("Failed")
            .getter(getter(BatchUpdateDataTableValueResponse::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateDataTableValueFailureResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateDataTableValueFailureResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUCCESSFUL_FIELD, FAILED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchUpdateDataTableValueSuccessResult> successful;

    private final List<BatchUpdateDataTableValueFailureResult> failed;

    private BatchUpdateDataTableValueResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successful property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of successfully updated values with their new lock versions and identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessful} method.
     * </p>
     * 
     * @return A list of successfully updated values with their new lock versions and identifiers.
     */
    public final List<BatchUpdateDataTableValueSuccessResult> successful() {
        return successful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failed property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailed() {
        return failed != null && !(failed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of values that failed to be updated with error messages explaining the failure reason.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailed} method.
     * </p>
     * 
     * @return A list of values that failed to be updated with error messages explaining the failure reason.
     */
    public final List<BatchUpdateDataTableValueFailureResult> failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailed() ? failed() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDataTableValueResponse)) {
            return false;
        }
        BatchUpdateDataTableValueResponse other = (BatchUpdateDataTableValueResponse) obj;
        return hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful())
                && hasFailed() == other.hasFailed() && Objects.equals(failed(), other.failed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateDataTableValueResponse").add("Successful", hasSuccessful() ? successful() : null)
                .add("Failed", hasFailed() ? failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Successful", SUCCESSFUL_FIELD);
        map.put("Failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDataTableValueResponse, T> g) {
        return obj -> g.apply((BatchUpdateDataTableValueResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateDataTableValueResponse> {
        /**
         * <p>
         * A list of successfully updated values with their new lock versions and identifiers.
         * </p>
         * 
         * @param successful
         *        A list of successfully updated values with their new lock versions and identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<BatchUpdateDataTableValueSuccessResult> successful);

        /**
         * <p>
         * A list of successfully updated values with their new lock versions and identifiers.
         * </p>
         * 
         * @param successful
         *        A list of successfully updated values with their new lock versions and identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(BatchUpdateDataTableValueSuccessResult... successful);

        /**
         * <p>
         * A list of successfully updated values with their new lock versions and identifiers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueSuccessResult.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueSuccessResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueSuccessResult.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #successful(List<BatchUpdateDataTableValueSuccessResult>)}.
         * 
         * @param successful
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueSuccessResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(java.util.Collection<BatchUpdateDataTableValueSuccessResult>)
         */
        Builder successful(Consumer<BatchUpdateDataTableValueSuccessResult.Builder>... successful);

        /**
         * <p>
         * A list of values that failed to be updated with error messages explaining the failure reason.
         * </p>
         * 
         * @param failed
         *        A list of values that failed to be updated with error messages explaining the failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<BatchUpdateDataTableValueFailureResult> failed);

        /**
         * <p>
         * A list of values that failed to be updated with error messages explaining the failure reason.
         * </p>
         * 
         * @param failed
         *        A list of values that failed to be updated with error messages explaining the failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(BatchUpdateDataTableValueFailureResult... failed);

        /**
         * <p>
         * A list of values that failed to be updated with error messages explaining the failure reason.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueFailureResult.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueFailureResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueFailureResult.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #failed(List<BatchUpdateDataTableValueFailureResult>)}.
         * 
         * @param failed
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueFailureResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(java.util.Collection<BatchUpdateDataTableValueFailureResult>)
         */
        Builder failed(Consumer<BatchUpdateDataTableValueFailureResult.Builder>... failed);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<BatchUpdateDataTableValueSuccessResult> successful = DefaultSdkAutoConstructList.getInstance();

        private List<BatchUpdateDataTableValueFailureResult> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDataTableValueResponse model) {
            super(model);
            successful(model.successful);
            failed(model.failed);
        }

        public final List<BatchUpdateDataTableValueSuccessResult.Builder> getSuccessful() {
            List<BatchUpdateDataTableValueSuccessResult.Builder> result = BatchUpdateDataTableValueSuccessResultListCopier
                    .copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<BatchUpdateDataTableValueSuccessResult.BuilderImpl> successful) {
            this.successful = BatchUpdateDataTableValueSuccessResultListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<BatchUpdateDataTableValueSuccessResult> successful) {
            this.successful = BatchUpdateDataTableValueSuccessResultListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(BatchUpdateDataTableValueSuccessResult... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<BatchUpdateDataTableValueSuccessResult.Builder>... successful) {
            successful(Stream.of(successful).map(c -> BatchUpdateDataTableValueSuccessResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateDataTableValueFailureResult.Builder> getFailed() {
            List<BatchUpdateDataTableValueFailureResult.Builder> result = BatchUpdateDataTableValueFailureResultListCopier
                    .copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchUpdateDataTableValueFailureResult.BuilderImpl> failed) {
            this.failed = BatchUpdateDataTableValueFailureResultListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchUpdateDataTableValueFailureResult> failed) {
            this.failed = BatchUpdateDataTableValueFailureResultListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchUpdateDataTableValueFailureResult... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchUpdateDataTableValueFailureResult.Builder>... failed) {
            failed(Stream.of(failed).map(c -> BatchUpdateDataTableValueFailureResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateDataTableValueResponse build() {
            return new BatchUpdateDataTableValueResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
