/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDisassociateAnalyticsDataSetResponse extends ConnectResponse implements
        ToCopyableBuilder<BatchDisassociateAnalyticsDataSetResponse.Builder, BatchDisassociateAnalyticsDataSetResponse> {
    private static final SdkField<List<String>> DELETED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Deleted")
            .getter(getter(BatchDisassociateAnalyticsDataSetResponse::deleted))
            .setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deleted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ErrorResult>> ERRORS_FIELD = SdkField
            .<List<ErrorResult>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchDisassociateAnalyticsDataSetResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> deleted;

    private final List<ErrorResult> errors;

    private BatchDisassociateAnalyticsDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.deleted = builder.deleted;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Deleted property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDeleted() {
        return deleted != null && !(deleted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of successfully disassociated dataset identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeleted} method.
     * </p>
     * 
     * @return An array of successfully disassociated dataset identifiers.
     */
    public final List<String> deleted() {
        return deleted;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors for any datasets not successfully removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors for any datasets not successfully removed.
     */
    public final List<ErrorResult> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeleted() ? deleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateAnalyticsDataSetResponse)) {
            return false;
        }
        BatchDisassociateAnalyticsDataSetResponse other = (BatchDisassociateAnalyticsDataSetResponse) obj;
        return hasDeleted() == other.hasDeleted() && Objects.equals(deleted(), other.deleted())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDisassociateAnalyticsDataSetResponse").add("Deleted", hasDeleted() ? deleted() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Deleted", DELETED_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateAnalyticsDataSetResponse, T> g) {
        return obj -> g.apply((BatchDisassociateAnalyticsDataSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDisassociateAnalyticsDataSetResponse> {
        /**
         * <p>
         * An array of successfully disassociated dataset identifiers.
         * </p>
         * 
         * @param deleted
         *        An array of successfully disassociated dataset identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Collection<String> deleted);

        /**
         * <p>
         * An array of successfully disassociated dataset identifiers.
         * </p>
         * 
         * @param deleted
         *        An array of successfully disassociated dataset identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(String... deleted);

        /**
         * <p>
         * A list of errors for any datasets not successfully removed.
         * </p>
         * 
         * @param errors
         *        A list of errors for any datasets not successfully removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<ErrorResult> errors);

        /**
         * <p>
         * A list of errors for any datasets not successfully removed.
         * </p>
         * 
         * @param errors
         *        A list of errors for any datasets not successfully removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(ErrorResult... errors);

        /**
         * <p>
         * A list of errors for any datasets not successfully removed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ErrorResult.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.ErrorResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ErrorResult.Builder#build()} is called immediately and
         * its result is passed to {@link #errors(List<ErrorResult>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ErrorResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<ErrorResult>)
         */
        Builder errors(Consumer<ErrorResult.Builder>... errors);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<String> deleted = DefaultSdkAutoConstructList.getInstance();

        private List<ErrorResult> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateAnalyticsDataSetResponse model) {
            super(model);
            deleted(model.deleted);
            errors(model.errors);
        }

        public final Collection<String> getDeleted() {
            if (deleted instanceof SdkAutoConstructList) {
                return null;
            }
            return deleted;
        }

        public final void setDeleted(Collection<String> deleted) {
            this.deleted = DataSetIdsCopier.copy(deleted);
        }

        @Override
        public final Builder deleted(Collection<String> deleted) {
            this.deleted = DataSetIdsCopier.copy(deleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleted(String... deleted) {
            deleted(Arrays.asList(deleted));
            return this;
        }

        public final List<ErrorResult.Builder> getErrors() {
            List<ErrorResult.Builder> result = ErrorResultsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ErrorResult.BuilderImpl> errors) {
            this.errors = ErrorResultsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ErrorResult> errors) {
            this.errors = ErrorResultsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ErrorResult... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ErrorResult.Builder>... errors) {
            errors(Stream.of(errors).map(c -> ErrorResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDisassociateAnalyticsDataSetResponse build() {
            return new BatchDisassociateAnalyticsDataSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
